/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.operations.dependencies.variants.ComponentIdentifier;
import org.gradle.operations.dependencies.variants.OpaqueComponentIdentifier;
import org.gradle.operations.dependencies.variants.ProjectComponentIdentifier;

public class ComponentToOperationConverter {
    public static ComponentIdentifier convertComponentIdentifier(final org.gradle.api.artifacts.component.ComponentIdentifier componentId) {
        if (componentId instanceof org.gradle.api.artifacts.component.ProjectComponentIdentifier) {
            final org.gradle.api.artifacts.component.ProjectComponentIdentifier projectComponentIdentifier = (org.gradle.api.artifacts.component.ProjectComponentIdentifier)componentId;
            return new ProjectComponentIdentifier(){

                public String getBuildPath() {
                    return projectComponentIdentifier.getBuild().getBuildPath();
                }

                public String getProjectPath() {
                    return projectComponentIdentifier.getProjectPath();
                }

                public String toString() {
                    return projectComponentIdentifier.getDisplayName();
                }
            };
        }
        if (componentId instanceof ModuleComponentIdentifier) {
            final ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)componentId;
            return new org.gradle.operations.dependencies.variants.ModuleComponentIdentifier(){

                public String getGroup() {
                    return moduleComponentIdentifier.getGroup();
                }

                public String getModule() {
                    return moduleComponentIdentifier.getModule();
                }

                public String getVersion() {
                    return moduleComponentIdentifier.getVersion();
                }

                public String toString() {
                    return moduleComponentIdentifier.getDisplayName();
                }
            };
        }
        return new OpaqueComponentIdentifier(){

            public String getDisplayName() {
                return componentId.getDisplayName();
            }

            public String getClassName() {
                return componentId.getClass().getName();
            }

            public String toString() {
                return componentId.getDisplayName();
            }
        };
    }
}

