﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/GuardDuty_EXPORTS.h>

namespace Aws {
namespace GuardDuty {
namespace Model {
enum class FreeTrialFeatureResult {
  NOT_SET,
  FLOW_LOGS,
  CLOUD_TRAIL,
  DNS_LOGS,
  S3_DATA_EVENTS,
  EKS_AUDIT_LOGS,
  EBS_MALWARE_PROTECTION,
  RDS_LOGIN_EVENTS,
  EKS_RUNTIME_MONITORING,
  LAMBDA_NETWORK_LOGS,
  FARGATE_RUNTIME_MONITORING,
  EC2_RUNTIME_MONITORING
};

namespace FreeTrialFeatureResultMapper {
AWS_GUARDDUTY_API FreeTrialFeatureResult GetFreeTrialFeatureResultForName(const Aws::String& name);

AWS_GUARDDUTY_API Aws::String GetNameForFreeTrialFeatureResult(FreeTrialFeatureResult value);
}  // namespace FreeTrialFeatureResultMapper
}  // namespace Model
}  // namespace GuardDuty
}  // namespace Aws
