/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.json;

import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonExistsFunction;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonExistsErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonPathPassingClause;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerJsonExistsFunction
extends JsonExistsFunction {
    private final boolean supportsExtendedJson;

    public SQLServerJsonExistsFunction(boolean supportsExtendedJson, TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
        this.supportsExtendedJson = supportsExtendedJson;
    }

    @Override
    protected void render(SqlAppender sqlAppender, JsonExistsFunction.JsonExistsArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        if (arguments.errorBehavior() == JsonExistsErrorBehavior.TRUE) {
            throw new QueryException("Can't emulate json_exists(... true on error) on SQL Server");
        }
        if (this.supportsExtendedJson) {
            if (arguments.errorBehavior() == JsonExistsErrorBehavior.ERROR) {
                sqlAppender.append('(');
            }
            sqlAppender.appendSql("json_path_exists(");
            arguments.jsonDocument().accept(walker);
            sqlAppender.appendSql(',');
            JsonPathPassingClause passingClause = arguments.passingClause();
            if (passingClause != null) {
                JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
            } else {
                walker.getSessionFactory().getJdbcServices().getDialect().appendLiteral(sqlAppender, (String)walker.getLiteralValue(arguments.jsonPath()));
            }
            sqlAppender.appendSql(")=1");
            if (arguments.errorBehavior() == JsonExistsErrorBehavior.ERROR) {
                sqlAppender.appendSql(" or (select v from openjson(");
                arguments.jsonDocument().accept(walker);
                sqlAppender.appendSql(") with (v varchar(max) ");
                if (passingClause != null) {
                    JsonPathHelper.appendInlinedJsonPathIncludingPassingClause(sqlAppender, "", arguments.jsonPath(), passingClause, walker);
                } else {
                    walker.getSessionFactory().getJdbcServices().getDialect().appendLiteral(sqlAppender, (String)walker.getLiteralValue(arguments.jsonPath()));
                }
                sqlAppender.appendSql(")) is null)");
            }
        } else {
            String terminalKey;
            if (arguments.errorBehavior() == JsonExistsErrorBehavior.FALSE) {
                throw new QueryException("Can't emulate json_exists(... false on error) on SQL Server");
            }
            String jsonPath = (String)walker.getLiteralValue(arguments.jsonPath());
            JsonPathPassingClause passingClause = arguments.passingClause();
            List<JsonPathHelper.JsonPathElement> pathElements = JsonPathHelper.parseJsonPathElements(jsonPath);
            if (passingClause != null) {
                JsonPathHelper.inlinePassingClause(pathElements, passingClause, walker);
            }
            JsonPathHelper.JsonPathElement lastPathElement = pathElements.get(pathElements.size() - 1);
            String prefix = JsonPathHelper.toJsonPath(pathElements, 0, pathElements.size() - 1);
            if (lastPathElement instanceof JsonPathHelper.JsonIndexAccess) {
                JsonPathHelper.JsonIndexAccess indexAccess = (JsonPathHelper.JsonIndexAccess)lastPathElement;
                terminalKey = String.valueOf(indexAccess.index());
            } else if (lastPathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)lastPathElement;
                terminalKey = attribute.attribute();
            } else {
                throw new AssertionFailure("Unrecognized json path element: " + String.valueOf(lastPathElement));
            }
            sqlAppender.appendSql("(select 1 from openjson(");
            arguments.jsonDocument().accept(walker);
            sqlAppender.appendSql(',');
            sqlAppender.appendSingleQuoteEscapedString(prefix);
            sqlAppender.appendSql(") t where t.[key]=");
            sqlAppender.appendSingleQuoteEscapedString(terminalKey);
            sqlAppender.appendSql(")=1");
        }
    }
}

