/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.lib.IntLookup;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

class DiskNode
extends Node {
    protected Row rData;
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;
    static final int SIZE_IN_BYTE = 16;

    DiskNode(CachedRow cachedRow, RowInputInterface rowInputInterface, int n) throws IOException, HsqlException {
        this.iId = n;
        this.rData = cachedRow;
        this.iBalance = rowInputInterface.readIntData();
        this.iLeft = rowInputInterface.readIntData();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = rowInputInterface.readIntData();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = rowInputInterface.readIntData();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    DiskNode(CachedRow cachedRow, int n) {
        this.iId = n;
        this.rData = cachedRow;
    }

    @Override
    void delete() {
        this.rData = null;
        this.iBalance = -2;
    }

    @Override
    int getKey() {
        if (this.rData != null) {
            return ((CachedRow)this.rData).iPos;
        }
        return -1;
    }

    @Override
    Row getRow() throws HsqlException {
        return this.rData;
    }

    private Node findNode(int n) throws HsqlException {
        Node node = null;
        CachedRow cachedRow = ((CachedRow)this.rData).getTable().getRow(n);
        if (cachedRow != null) {
            node = cachedRow.getNode(this.iId);
        }
        return node;
    }

    @Override
    boolean isLeft(Node node) throws HsqlException {
        if (node == null) {
            return this.iLeft == -1;
        }
        return this.iLeft == ((DiskNode)node).getKey();
    }

    @Override
    boolean isRight(Node node) throws HsqlException {
        if (node == null) {
            return this.iRight == -1;
        }
        return this.iRight == ((DiskNode)node).getKey();
    }

    @Override
    Node getLeft() throws HsqlException {
        if (this.iLeft == -1) {
            return null;
        }
        return this.findNode(this.iLeft);
    }

    @Override
    Node getRight() throws HsqlException {
        if (this.iRight == -1) {
            return null;
        }
        return this.findNode(this.iRight);
    }

    @Override
    Node getParent() throws HsqlException {
        if (this.iParent == -1) {
            return null;
        }
        return this.findNode(this.iParent);
    }

    @Override
    boolean isRoot() {
        return this.iParent == -1;
    }

    @Override
    boolean isFromLeft() throws HsqlException {
        if (this.isRoot()) {
            return true;
        }
        DiskNode diskNode = (DiskNode)this.getParent();
        return this.getKey() == diskNode.iLeft;
    }

    @Override
    Object[] getData() throws HsqlException {
        return this.rData.getData();
    }

    @Override
    void setParent(Node node) throws HsqlException {
        ((CachedRow)this.rData).setChanged();
        this.iParent = node == null ? -1 : node.getKey();
    }

    @Override
    void setBalance(int n) throws HsqlException {
        if (this.iBalance != n) {
            ((CachedRow)this.rData).setChanged();
            this.iBalance = n;
        }
    }

    @Override
    void setLeft(Node node) throws HsqlException {
        ((CachedRow)this.rData).setChanged();
        this.iLeft = node == null ? -1 : node.getKey();
    }

    @Override
    void setRight(Node node) throws HsqlException {
        ((CachedRow)this.rData).setChanged();
        this.iRight = node == null ? -1 : node.getKey();
    }

    @Override
    boolean equals(Node node) {
        return this == node || node != null && this.getKey() == ((DiskNode)node).getKey();
    }

    @Override
    void write(RowOutputInterface rowOutputInterface) throws IOException {
        rowOutputInterface.writeIntData(this.iBalance);
        rowOutputInterface.writeIntData(this.iLeft == -1 ? 0 : this.iLeft);
        rowOutputInterface.writeIntData(this.iRight == -1 ? 0 : this.iRight);
        rowOutputInterface.writeIntData(this.iParent == -1 ? 0 : this.iParent);
    }

    @Override
    Node getUpdatedNode() throws HsqlException {
        Row row = this.rData.getUpdatedRow();
        return row == null ? null : row.getNode(this.iId);
    }

    void writeTranslate(RowOutputInterface rowOutputInterface, IntLookup intLookup) {
        rowOutputInterface.writeIntData(this.iBalance);
        this.writeTranslatePointer(this.iLeft, rowOutputInterface, intLookup);
        this.writeTranslatePointer(this.iRight, rowOutputInterface, intLookup);
        this.writeTranslatePointer(this.iParent, rowOutputInterface, intLookup);
    }

    private void writeTranslatePointer(int n, RowOutputInterface rowOutputInterface, IntLookup intLookup) {
        int n2 = 0;
        if (n != -1) {
            n2 = intLookup.lookupFirstEqual(n);
        }
        rowOutputInterface.writeIntData(n2);
    }
}

