/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils;

import java.util.LinkedList;
import java.util.List;

public abstract class ArgumentTokenizer {
    private static final int NO_TOKEN_STATE = 0;
    private static final int NORMAL_TOKEN_STATE = 1;
    private static final int SINGLE_QUOTE_STATE = 2;
    private static final int DOUBLE_QUOTE_STATE = 3;

    public static List<String> tokenize(String arguments) {
        return ArgumentTokenizer.tokenize(arguments, false);
    }

    public static List<String> tokenize(String arguments, boolean stringify) {
        LinkedList<String> argList = new LinkedList<String>();
        StringBuilder currArg = new StringBuilder();
        boolean escaped = false;
        int state = 0;
        int len = arguments.length();
        int i = 0;
        while (i < len) {
            char c = arguments.charAt(i);
            if (escaped) {
                escaped = false;
                if (c != 'n' && c != 't' && c != '\\') {
                    currArg.append('\\');
                }
                currArg.append(c);
            } else {
                block0 : switch (state) {
                    case 2: {
                        if (c == '\'') {
                            state = 1;
                            break;
                        }
                        currArg.append(c);
                        break;
                    }
                    case 3: {
                        if (c == '\"') {
                            state = 1;
                            break;
                        }
                        if (c == '\\') {
                            char next;
                            if ((next = arguments.charAt(++i)) == '\"' || next == '\\') {
                                currArg.append(next);
                                break;
                            }
                            currArg.append(c);
                            currArg.append(next);
                            break;
                        }
                        currArg.append(c);
                        break;
                    }
                    case 0: 
                    case 1: {
                        switch (c) {
                            case '\\': {
                                escaped = true;
                                state = 1;
                                break block0;
                            }
                            case '\'': {
                                state = 2;
                                break block0;
                            }
                            case '\"': {
                                state = 3;
                                break block0;
                            }
                        }
                        if (!Character.isWhitespace(c)) {
                            currArg.append(c);
                            state = 1;
                            break;
                        }
                        if (state != 1) break;
                        argList.add(currArg.toString());
                        currArg = new StringBuilder();
                        state = 0;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("ArgumentTokenizer state " + state + " is invalid!");
                    }
                }
            }
            ++i;
        }
        if (escaped) {
            currArg.append('\\');
            argList.add(currArg.toString());
        } else if (state != 0) {
            argList.add(currArg.toString());
        }
        if (stringify) {
            i = 0;
            while (i < argList.size()) {
                argList.set(i, "\"" + ArgumentTokenizer._escapeQuotesAndBackslashes(argList.get(i)) + "\"");
                ++i;
            }
        }
        return argList;
    }

    protected static String _escapeQuotesAndBackslashes(String s) {
        StringBuilder buf = new StringBuilder(s);
        int i = s.length() - 1;
        while (i >= 0) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\"') {
                buf.insert(i, '\\');
            } else if (c == '\n') {
                buf.deleteCharAt(i);
                buf.insert(i, "\\n");
            } else if (c == '\t') {
                buf.deleteCharAt(i);
                buf.insert(i, "\\t");
            } else if (c == '\r') {
                buf.deleteCharAt(i);
                buf.insert(i, "\\r");
            } else if (c == '\b') {
                buf.deleteCharAt(i);
                buf.insert(i, "\\b");
            } else if (c == '\f') {
                buf.deleteCharAt(i);
                buf.insert(i, "\\f");
            }
            --i;
        }
        return buf.toString();
    }
}

