/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.util;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.PageSelectorList;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.DefaultStyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.LexicalValue;
import io.sf.carte.doc.style.css.property.ShorthandDatabase;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.util.Minify;
import io.sf.carte.util.BufferSimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

class MinifySheetHandler
implements CSSHandler {
    private static final short FEATURE_MAP = 63;
    private boolean ignoreImports = false;
    private LinkedList<Short> currentRule = new LinkedList();
    private BitSet ruleContent = new BitSet();
    private ValueFactory factory = new ValueFactory();
    private BufferSimpleWriter writer;
    private StringBuilder ruleBuf = new StringBuilder(128);
    private final Minify.Config config;
    private final char preserveCommentChar;

    MinifySheetHandler(BufferSimpleWriter wri, Minify.Config config) {
        this.writer = wri;
        this.config = config;
        this.preserveCommentChar = config.getPreserveCommentChar();
    }

    @Override
    public void parseStart(ParserControl parserctl) {
        this.ignoreImports = false;
    }

    @Override
    public void endOfStream() {
    }

    private void write(char c) {
        this.writer.write(c);
    }

    private void write(CharSequence string) {
        this.writer.write(string);
    }

    private void writeBuf() {
        if (this.ruleBuf.length() > 0) {
            this.write(this.ruleBuf);
            this.ruleBuf.setLength(0);
        }
    }

    private void appendBuf(char c) {
        this.ruleBuf.append(c);
    }

    private void appendBuf(CharSequence seq) {
        this.ruleBuf.append(seq);
    }

    @Override
    public void comment(String text, boolean precededByLF) {
        if (!text.isEmpty() && text.charAt(0) == this.preserveCommentChar) {
            this.appendBuf("/*");
            this.appendBuf(text);
            this.appendBuf("*/");
            this.setRuleContent();
        }
    }

    @Override
    public void ignorableAtRule(String atRule) {
        this.writeBuf();
        this.setRuleContent();
        try {
            Minify.shallowMinify(new StringReader(atRule), this.ruleBuf);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.write(this.ruleBuf);
        this.ruleBuf.setLength(0);
    }

    @Override
    public void namespaceDeclaration(String prefix, String uri) {
        this.writeBuf();
        this.setRuleContent();
        this.write("@namespace ");
        if (prefix != null && !prefix.isEmpty()) {
            this.write(prefix);
            this.write(' ');
        }
        this.writeURL(uri);
        this.write(';');
    }

    private void writeURL(String uri) {
        String quoted = ParseHelper.quote(uri, '\"');
        this.write(quoted);
    }

    @Override
    public void importStyle(String uri, String layer, BooleanCondition supportsCondition, MediaQueryList media, String defaultNamespaceURI) throws CSSException {
        if (this.ignoreImports) {
            return;
        }
        this.checkMediaErrors(media);
        this.writeBuf();
        this.write("@import ");
        this.writeURL(uri);
        if (layer != null) {
            this.write(' ');
            this.write("layer");
            if (!layer.isEmpty()) {
                this.write('(');
                this.write(layer);
                this.write(')');
            }
        }
        if (supportsCondition != null) {
            this.write(' ');
            this.write("supports");
            this.write('(');
            supportsCondition.appendMinifiedText(this.ruleBuf);
            this.write(this.ruleBuf);
            this.ruleBuf.setLength(0);
            this.write(')');
        }
        if (media != null) {
            this.write(' ');
            this.write(media.getMinifiedMedia());
        }
        this.write(';');
    }

    private void checkMediaErrors(MediaQueryList media) throws CSSException {
        if (media.hasErrors()) {
            List<CSSParseException> exs = media.getExceptions();
            if (exs != null) {
                throw exs.get(0);
            }
            throw new CSSException("Media query has errors.");
        }
    }

    @Override
    public void startSupports(BooleanCondition condition) {
        this.ignoreImports = true;
        this.currentRule.add((short)12);
        this.writeBuf();
        this.appendBuf("@supports ");
        condition.appendMinifiedText(this.ruleBuf);
        this.appendBuf('{');
    }

    @Override
    public void endSupports(BooleanCondition condition) {
        this.endDeclarationsRule();
    }

    @Override
    public void startMedia(MediaQueryList media) throws CSSException {
        this.checkMediaErrors(media);
        this.ignoreImports = true;
        this.currentRule.add((short)4);
        this.writeBuf();
        this.appendBuf("@media");
        if (media != null) {
            this.appendBuf(' ');
            this.appendBuf(media.getMinifiedMedia());
        }
        this.appendBuf('{');
    }

    @Override
    public void endMedia(MediaQueryList media) {
        this.endDeclarationsRule();
    }

    @Override
    public void startPage(PageSelectorList pageSelectorList) {
        this.ignoreImports = true;
        this.writeBuf();
        this.currentRule.add((short)6);
        this.appendBuf("@page");
        if (pageSelectorList != null) {
            this.appendBuf(' ');
            this.appendBuf(pageSelectorList.toString());
        }
        this.appendBuf('{');
    }

    @Override
    public void endPage(PageSelectorList pageSelectorList) {
        this.endDeclarationsRule();
    }

    @Override
    public void startMargin(String name) {
        this.writeBuf();
        this.currentRule.add((short)9);
        this.appendBuf('@');
        this.appendBuf(name);
        this.appendBuf('{');
    }

    @Override
    public void endMargin() {
        this.endDeclarationsRule();
    }

    @Override
    public void startFontFace() {
        this.ignoreImports = true;
        this.writeBuf();
        this.currentRule.add((short)5);
        this.appendBuf("@font-face{");
    }

    @Override
    public void endFontFace() {
        this.endDeclarationsRule();
    }

    @Override
    public void startCounterStyle(String name) {
        this.ignoreImports = true;
        this.writeBuf();
        this.currentRule.add((short)11);
        this.appendBuf("@counter-style ");
        this.appendBuf(name);
        this.appendBuf('{');
    }

    @Override
    public void endCounterStyle() {
        this.endDeclarationsRule();
    }

    @Override
    public void startKeyframes(String name) {
        this.ignoreImports = true;
        this.writeBuf();
        this.currentRule.add((short)7);
        this.appendBuf("@keyframes ");
        this.appendBuf(name);
        this.appendBuf('{');
    }

    @Override
    public void endKeyframes() {
        this.endGenericRule((short)7);
    }

    @Override
    public void startKeyframe(LexicalUnit keyframeSelector) {
        this.writeBuf();
        this.setRuleContent((short)7);
        this.currentRule.add((short)6);
        this.miniKeyframeSelector(keyframeSelector);
        this.appendBuf('{');
    }

    private void miniKeyframeSelector(LexicalUnit selunit) {
        this.appendMiniSelector(selunit);
        LexicalUnit lu = selunit.getNextLexicalUnit();
        while (lu != null) {
            LexicalUnit nextlu = lu.getNextLexicalUnit();
            this.ruleBuf.append(',');
            this.appendMiniSelector(nextlu);
            lu = nextlu.getNextLexicalUnit();
        }
    }

    private void appendMiniSelector(LexicalUnit selunit) {
        LexicalUnit.LexicalType type = selunit.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.STRING) {
            this.ruleBuf.append(selunit.getStringValue());
        } else if (type == LexicalUnit.LexicalType.PERCENTAGE) {
            float floatValue = selunit.getFloatValue();
            if (floatValue == 0.0f) {
                this.ruleBuf.append('0');
                return;
            }
            if (floatValue % 1.0f != 0.0f) {
                this.ruleBuf.append(String.format(Locale.ROOT, "%s", Float.valueOf(floatValue)));
            } else {
                this.ruleBuf.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(floatValue)));
            }
            this.ruleBuf.append('%');
        } else if (type == LexicalUnit.LexicalType.INTEGER && selunit.getIntegerValue() == 0) {
            this.ruleBuf.append('0');
        } else {
            this.ruleBuf.append(selunit.getCssText());
        }
    }

    @Override
    public void endKeyframe() {
        this.endDeclarationsRule();
    }

    @Override
    public void startFontFeatures(String[] familyName) {
        this.ignoreImports = true;
        this.writeBuf();
        this.currentRule.add((short)14);
        this.appendBuf("@font-feature-values ");
        this.appendBuf(familyName[0]);
        for (int i = 1; i < familyName.length; ++i) {
            this.appendBuf(',');
            this.appendBuf(familyName[i]);
        }
        this.appendBuf('{');
    }

    @Override
    public void endFontFeatures() {
        this.endGenericRule((short)14);
    }

    @Override
    public void startFeatureMap(String mapName) {
        this.writeBuf();
        this.setRuleContent((short)14);
        this.currentRule.add((short)63);
        this.appendBuf('@');
        this.appendBuf(mapName);
        this.appendBuf('{');
    }

    @Override
    public void endFeatureMap() {
        this.endDeclarationsRule();
    }

    @Override
    public void startProperty(String name) {
        this.ignoreImports = true;
        this.writeBuf();
        this.currentRule.add((short)18);
        this.appendBuf("@property ");
        this.appendBuf(name);
        this.appendBuf('{');
    }

    @Override
    public void endProperty(boolean discard) {
        this.endDeclarationsRule();
    }

    @Override
    public void startSelector(SelectorList selectors) {
        this.ignoreImports = true;
        this.writeBuf();
        this.currentRule.add((short)1);
        this.config.serializeSelectors(selectors, this.ruleBuf);
        this.appendBuf('{');
    }

    @Override
    public void endSelector(SelectorList selectors) {
        this.endDeclarationsRule();
    }

    private void endDeclarationsRule() {
        short idx = this.currentRule.removeLast();
        if (this.ruleContent.get(idx)) {
            char last;
            int len;
            if (!this.currentRule.contains(idx)) {
                this.ruleContent.set((int)idx, false);
            }
            if ((len = this.ruleBuf.length()) > 0 && (last = this.ruleBuf.charAt(len - 1)) == ';') {
                this.ruleBuf.setLength(len - 1);
            }
            this.appendBuf('}');
            this.write(this.ruleBuf);
        }
        this.ruleBuf.setLength(0);
    }

    private void endGenericRule(short ruleId) {
        if (this.ruleContent.get(ruleId)) {
            if (!this.currentRule.contains(ruleId)) {
                this.ruleContent.set((int)ruleId, false);
            }
            this.appendBuf('}');
            this.write(this.ruleBuf);
        }
        this.ruleBuf.setLength(0);
    }

    @Override
    public void property(String name, LexicalUnit value, boolean important) {
        this.setRuleContent();
        this.appendBuf(name);
        this.appendBuf(':');
        if (ShorthandDatabase.getInstance().isShorthand(name) && !this.config.isDisabledShorthand(name)) {
            StringBuilder buf = new StringBuilder(32);
            this.serializeValue(name, value, buf, false);
            final DefaultStyleDeclarationErrorHandler eh = new DefaultStyleDeclarationErrorHandler();
            BaseCSSStyleDeclaration style = new BaseCSSStyleDeclaration(){
                private static final long serialVersionUID = 1L;

                @Override
                public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
                    return eh;
                }
            };
            CharSequence seq = buf;
            try {
                style.setProperty(name, value, important);
                if (!style.getStyleDeclarationErrorHandler().hasErrors()) {
                    String decl = style.getMinifiedPropertyValue(name);
                    if (buf.length() > decl.length() && !decl.isEmpty()) {
                        seq = decl;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.appendBuf(seq);
        } else {
            this.serializeValue(name, value, this.ruleBuf, false);
        }
        if (important) {
            this.appendBuf("!important");
        }
        this.appendBuf(';');
    }

    private void setRuleContent(short ruleId) {
        this.ruleContent.set(ruleId);
    }

    private void setRuleContent() {
        Iterator iterator = this.currentRule.iterator();
        while (iterator.hasNext()) {
            short ruleId = (Short)iterator.next();
            this.ruleContent.set(ruleId);
        }
    }

    private void serializeValue(String propertyName, LexicalUnit value, StringBuilder buf, boolean keepZeroUnit) {
        String mini = LexicalValue.serializeMinifiedSequence(value, propertyName, keepZeroUnit);
        try {
            String ommini;
            StyleValue omvalue = this.factory.createCSSValue(value);
            if (omvalue.getPrimitiveType() != CSSValue.Type.LEXICAL && (ommini = omvalue.getMinifiedCssText()).length() < mini.length()) {
                this.config.serializeValue(propertyName, ommini, buf);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.config.serializeValue(propertyName, mini, buf);
    }

    @Override
    public void lexicalProperty(String name, LexicalUnit lunit, boolean important) {
        this.setRuleContent();
        this.appendBuf(name);
        this.appendBuf(':');
        this.serializeValue("", lunit, this.ruleBuf, true);
        if (important) {
            this.appendBuf("!important");
        }
        this.appendBuf(';');
    }
}

