/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.exception.AssertException;

public class PdbBitField
extends BitFieldDataType {
    private int bitOffsetWithinBaseType;

    protected PdbBitField(DataType baseDataType, int bitSize, int bitOffsetWithinBaseType) throws InvalidDataTypeException {
        super(baseDataType, bitSize, PdbBitField.getMinimalBitOffset(baseDataType, bitSize, bitOffsetWithinBaseType));
        if (bitSize < 1) {
            throw new InvalidDataTypeException("invalid PDB bit size: " + bitSize);
        }
        if (bitOffsetWithinBaseType < -1) {
            throw new InvalidDataTypeException("invalid PDB bit offset: " + bitOffsetWithinBaseType);
        }
        this.bitOffsetWithinBaseType = bitOffsetWithinBaseType;
    }

    private static int getMinimalBitOffset(DataType baseDataType, int bitSize, int bitOffsetWithinBaseType) {
        if (bitOffsetWithinBaseType < 0) {
            return 0;
        }
        return bitOffsetWithinBaseType % 8;
    }

    public int getBitOffsetWithinBase() {
        return this.bitOffsetWithinBaseType;
    }

    public BitFieldDataType clone(DataTypeManager dtm) {
        if (dtm != this.getDataTypeManager()) {
            throw new AssertException("unsupported clone operation");
        }
        return this;
    }

    public String toString() {
        return this.getDisplayName() + "(baseSize:" + this.getBaseTypeSize() + ",bitOffsetInBase:" + this.bitOffsetWithinBaseType + ")";
    }
}

