/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.checkbox.GCheckBox;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.filters.CheckBoxBasedAncillaryFilter;
import ghidra.feature.vt.gui.filters.CheckBoxInfo;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class MatchTypeFilter
extends CheckBoxBasedAncillaryFilter<VTMatch> {
    public MatchTypeFilter() {
        super("Match Type");
    }

    @Override
    protected void createCheckBoxInfos() {
        VTAssociationType[] values;
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MatchTypeFilter.this.fireStatusChanged(MatchTypeFilter.this.getFilterStatus());
            }
        };
        for (VTAssociationType status : values = VTAssociationType.values()) {
            GCheckBox checkBox = new GCheckBox(status.toString(), true);
            checkBox.addItemListener(listener);
            AssociationTypeCheckBoxInfo info = new AssociationTypeCheckBoxInfo(this, (JCheckBox)checkBox, status);
            this.checkBoxInfos.add(info);
        }
    }

    private class AssociationTypeCheckBoxInfo
    extends CheckBoxInfo<VTMatch> {
        private VTAssociationType associationType;

        public AssociationTypeCheckBoxInfo(MatchTypeFilter matchTypeFilter, JCheckBox checkBox, VTAssociationType associationType) {
            super(checkBox);
            this.associationType = associationType;
        }

        @Override
        public boolean matchesStatus(VTMatch match) {
            if (!this.isSelected()) {
                return false;
            }
            return match.getAssociation().getType().equals((Object)this.associationType);
        }
    }
}

