/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.rust.demangler;

import ghidra.app.plugin.core.analysis.rust.demangler.RustConst;
import ghidra.app.plugin.core.analysis.rust.demangler.RustLifetime;
import ghidra.app.plugin.core.analysis.rust.demangler.RustType;
import ghidra.app.plugin.core.analysis.rust.demangler.Symbol;
import ghidra.app.plugin.core.analysis.rust.demangler.SymbolNode;

class RustGenericArg
implements SymbolNode {
    SymbolNode child;

    public RustGenericArg(SymbolNode child) {
        this.child = child;
    }

    public static RustGenericArg parse(Symbol s) {
        RustType type;
        SymbolNode lifetime = RustLifetime.parse(s);
        if (lifetime != null) {
            return new RustGenericArg(lifetime);
        }
        if (s.nextChar() == 'K') {
            s.popChar();
            RustConst constant = RustConst.parse(s);
            if (constant != null) {
                return new RustGenericArg(constant);
            }
        }
        if ((type = RustType.parse(s)) != null) {
            return new RustGenericArg(type);
        }
        return null;
    }

    public String toString() {
        return this.child.toString();
    }
}

