/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.sys;

import ghidra.pcode.emu.sys.EmuSystemException;
import ghidra.pcode.exec.PcodeArithmetic;
import java.math.BigInteger;

public class EmuProcessExitedException
extends EmuSystemException {
    private final Object status;

    public static <T> String tryConcereteToString(PcodeArithmetic<T> arithmetic, T status) {
        try {
            BigInteger value = arithmetic.toBigInteger(status, PcodeArithmetic.Purpose.INSPECT);
            return value.toString();
        }
        catch (Exception e) {
            return status.toString();
        }
    }

    public <T> EmuProcessExitedException(PcodeArithmetic<T> arithmetic, T status) {
        super("Process exited with status " + EmuProcessExitedException.tryConcereteToString(arithmetic, status));
        this.status = status;
    }

    public Object getStatus() {
        return this.status;
    }
}

