/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.struct;

import ghidra.pcode.struct.Expr;
import ghidra.pcode.struct.RValInternal;
import ghidra.pcode.struct.StringTree;
import ghidra.pcode.struct.StructuredSleigh;
import ghidra.program.model.data.DataType;

class BinExpr
extends Expr {
    protected final RValInternal lhs;
    protected final String op;
    protected final RValInternal rhs;

    protected BinExpr(StructuredSleigh ctx, StructuredSleigh.RVal lhs, String op, StructuredSleigh.RVal rhs, DataType type) {
        super(ctx, type);
        this.lhs = (RValInternal)lhs;
        this.op = op;
        this.rhs = (RValInternal)rhs;
    }

    @Override
    public StructuredSleigh.RVal cast(DataType type) {
        return new BinExpr(this.ctx, this.lhs, this.op, this.rhs, type);
    }

    public String toString() {
        return "<" + this.getClass().getSimpleName() + " " + String.valueOf(this.lhs) + " " + this.op + " " + String.valueOf(this.rhs) + ">";
    }

    @Override
    public StringTree generate(RValInternal parent) {
        StringTree st = new StringTree();
        st.append("(");
        st.append(this.lhs.generate(this));
        st.append(" ");
        st.append(this.op);
        st.append(" ");
        st.append(this.rhs.generate(this));
        st.append(")");
        return st;
    }
}

