/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.time;

import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GColor;
import ghidra.app.plugin.core.debug.gui.time.SnapshotRow;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.docking.settings.Settings;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.DateUtils;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerSnapshotTablePanel
extends JPanel {
    private static final Color COLOR_FOREGROUND_STALE = new GColor("color.debugger.plugin.resources.register.stale");
    private static final Color COLOR_FOREGROUND_STALE_SEL = new GColor("color.debugger.plugin.resources.register.stale.selected");
    final TableCellRenderer styleCurrentRenderer = new AbstractGColumnRenderer<Object>(){

        protected String formatNumber(Number value, Settings settings) {
            Number number = value;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class}, (Object)number, n)) {
                case -1 -> "";
                case 0 -> {
                    Long snap = (Long)number;
                    yield DebuggerSnapshotTablePanel.this.getTimeRadix().format(snap.longValue());
                }
                default -> super.formatNumber(value, settings);
            };
        }

        protected String getText(Object value) {
            Object object = value;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Date.class, TraceSchedule.class}, (Object)object, n)) {
                case -1 -> "";
                case 0 -> {
                    Date date = (Date)object;
                    yield DateUtils.formatDateTimestamp((Date)date);
                }
                case 1 -> {
                    TraceSchedule schedule = (TraceSchedule)object;
                    yield schedule.toString(DebuggerSnapshotTablePanel.this.getTimeRadix());
                }
                default -> value.toString();
            };
        }

        public String getFilterString(Object t, Settings settings) {
            Object object = t;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Number.class}, (Object)object, n)) {
                case -1 -> "";
                case 0 -> {
                    Long snap = (Long)object;
                    yield DebuggerSnapshotTablePanel.this.getTimeRadix().format(snap.longValue());
                }
                case 1 -> {
                    Number n = (Number)object;
                    yield this.formatNumber(n, settings);
                }
                default -> this.getText(t);
            };
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            SnapshotRow row = (SnapshotRow)data.getRowObject();
            if (row == null || DebuggerSnapshotTablePanel.this.current == DebuggerCoordinates.NOWHERE) {
                return this;
            }
            if (DebuggerSnapshotTablePanel.this.current.getViewSnap() == row.getSnap()) {
                this.setBold();
            } else if (DebuggerSnapshotTablePanel.this.current.getSnap() == row.getSnap()) {
                this.setItalic();
            }
            TraceSnapshot snapshot = row.getSnapshot();
            if (snapshot.isStale(true)) {
                this.setForeground(data.isSelected() ? COLOR_FOREGROUND_STALE_SEL : COLOR_FOREGROUND_STALE);
            } else {
                JTable table = data.getTable();
                this.setForeground(data.isSelected() ? table.getSelectionForeground() : table.getForeground());
            }
            return this;
        }
    };
    protected final PluginTool tool;
    protected final SnapshotTableModel snapshotTableModel;
    protected final GTable snapshotTable;
    protected final GhidraTableFilterPanel<SnapshotRow> snapshotFilterPanel;
    protected boolean hideScratch = false;
    private Trace currentTrace;
    private volatile DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected final SnapshotListener listener = new SnapshotListener();

    public DebuggerSnapshotTablePanel(PluginTool tool) {
        super(new BorderLayout());
        this.tool = tool;
        this.snapshotTableModel = new SnapshotTableModel(tool);
        this.snapshotTable = new GTable((TableModel)((Object)this.snapshotTableModel));
        this.snapshotTable.setSelectionMode(0);
        this.add(new JScrollPane((Component)this.snapshotTable));
        this.snapshotFilterPanel = new GhidraTableFilterPanel((JTable)this.snapshotTable, (RowObjectTableModel)this.snapshotTableModel);
        this.add((Component)this.snapshotFilterPanel, "South");
        TableColumnModel columnModel = this.snapshotTable.getColumnModel();
        TableColumn snapCol = columnModel.getColumn(SnapshotTableColumns.SNAP.ordinal());
        snapCol.setPreferredWidth(20);
        snapCol.setCellRenderer(this.styleCurrentRenderer);
        TableColumn timeCol = columnModel.getColumn(SnapshotTableColumns.TIME.ordinal());
        timeCol.setPreferredWidth(20);
        timeCol.setCellRenderer(this.styleCurrentRenderer);
        TableColumn etCol = columnModel.getColumn(SnapshotTableColumns.EVENT_THREAD.ordinal());
        etCol.setPreferredWidth(20);
        etCol.setCellRenderer(this.styleCurrentRenderer);
        TableColumn pcCol = columnModel.getColumn(SnapshotTableColumns.PC.ordinal());
        pcCol.setPreferredWidth(40);
        pcCol.setCellRenderer(this.styleCurrentRenderer);
        TableColumn moduleCol = columnModel.getColumn(SnapshotTableColumns.MODULE.ordinal());
        moduleCol.setPreferredWidth(40);
        moduleCol.setCellRenderer(this.styleCurrentRenderer);
        TableColumn functionCol = columnModel.getColumn(SnapshotTableColumns.FUNCTION.ordinal());
        functionCol.setPreferredWidth(40);
        functionCol.setCellRenderer(this.styleCurrentRenderer);
        TableColumn timeStampCol = columnModel.getColumn(SnapshotTableColumns.TIMESTAMP.ordinal());
        timeStampCol.setPreferredWidth(200);
        timeStampCol.setCellRenderer(this.styleCurrentRenderer);
        TableColumn schdCol = columnModel.getColumn(SnapshotTableColumns.SCHEDULE.ordinal());
        schdCol.setPreferredWidth(60);
        schdCol.setCellRenderer(this.styleCurrentRenderer);
        TableColumn descCol = columnModel.getColumn(SnapshotTableColumns.DESCRIPTION.ordinal());
        descCol.setPreferredWidth(20);
        descCol.setCellRenderer(this.styleCurrentRenderer);
    }

    protected TraceSchedule.TimeRadix getTimeRadix() {
        return this.currentTrace == null ? TraceSchedule.TimeRadix.DEFAULT : this.currentTrace.getTimeManager().getTimeRadix();
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.listener);
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.listener);
    }

    public void setTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadSnapshots();
    }

    public Trace getTrace() {
        return this.currentTrace;
    }

    public void setHideScratchSnapshots(boolean hideScratch) {
        if (this.hideScratch == hideScratch) {
            return;
        }
        this.hideScratch = hideScratch;
        if (hideScratch) {
            this.deleteScratchSnapshots();
        } else {
            this.loadScratchSnapshots();
        }
    }

    protected void loadSnapshots() {
        this.snapshotTableModel.clear();
        if (this.currentTrace == null) {
            return;
        }
        TraceTimeManager manager = this.currentTrace.getTimeManager();
        ArrayList<SnapshotRow> toAdd = new ArrayList<SnapshotRow>();
        for (TraceSnapshot snapshot : this.hideScratch ? manager.getSnapshots(0L, true, Long.MAX_VALUE, true) : manager.getAllSnapshots()) {
            SnapshotRow row = new SnapshotRow(snapshot, (ServiceProvider)this.tool);
            toAdd.add(row);
            if (this.current != DebuggerCoordinates.NOWHERE && snapshot.getKey() != this.current.getViewSnap()) continue;
        }
        this.snapshotTableModel.addAll(toAdd);
    }

    protected void deleteScratchSnapshots() {
        this.snapshotTableModel.deleteWith(s -> s.getSnap() < 0L);
    }

    protected void loadScratchSnapshots() {
        if (this.currentTrace == null) {
            return;
        }
        TraceTimeManager manager = this.currentTrace.getTimeManager();
        Collection sratch = manager.getSnapshots(Long.MIN_VALUE, true, 0L, false);
        this.snapshotTableModel.addAll(sratch.stream().map(s -> new SnapshotRow((TraceSnapshot)s, (ServiceProvider)this.tool)).collect(Collectors.toList()));
    }

    public ListSelectionModel getSelectionModel() {
        return this.snapshotTable.getSelectionModel();
    }

    public Long getSelectedSnapshot() {
        SnapshotRow row = (SnapshotRow)this.snapshotFilterPanel.getSelectedItem();
        return row == null ? null : Long.valueOf(row.getSnap());
    }

    public void setCurrent(DebuggerCoordinates coords) {
        boolean fire = coords.getViewSnap() != this.current.getViewSnap();
        this.current = coords;
        if (fire) {
            this.snapshotTableModel.fireTableDataChanged();
        }
    }

    public void setSelectedSnapshot(Long snap) {
        Long curSnap;
        if (snap == null) {
            this.snapshotTable.clearSelection();
            return;
        }
        SnapshotRow sel = (SnapshotRow)this.snapshotFilterPanel.getSelectedItem();
        Long l = curSnap = sel == null ? null : Long.valueOf(sel.getSnap());
        if (Objects.equals(curSnap, snap)) {
            return;
        }
        SnapshotRow row = (SnapshotRow)this.snapshotTableModel.findFirst(r -> r.getSnap() == snap.longValue());
        if (row == null) {
            this.snapshotTable.clearSelection();
            return;
        }
        this.snapshotFilterPanel.setSelectedItem((Object)row);
    }

    private class SnapshotListener
    extends TraceDomainObjectListener {
        public SnapshotListener() {
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, e -> this.objectRestored());
            this.listenFor((TraceEvent)TraceEvents.SNAPSHOT_ADDED, this::snapAdded);
            this.listenFor((TraceEvent)TraceEvents.SNAPSHOT_CHANGED, this::snapChanged);
            this.listenFor((TraceEvent)TraceEvents.SNAPSHOT_DELETED, this::snapDeleted);
            this.listenFor((TraceEvent)TraceEvents.VALUE_CREATED, this::valueCreated);
            this.listenFor((TraceEvent)TraceEvents.VALUE_DELETED, this::valueDeleted);
        }

        private void objectRestored() {
            DebuggerSnapshotTablePanel.this.loadSnapshots();
        }

        private void snapAdded(TraceSnapshot snapshot) {
            if (snapshot.getKey() < 0L && DebuggerSnapshotTablePanel.this.hideScratch) {
                return;
            }
            SnapshotRow row = new SnapshotRow(snapshot, (ServiceProvider)DebuggerSnapshotTablePanel.this.tool);
            DebuggerSnapshotTablePanel.this.snapshotTableModel.add(row);
        }

        private void snapChanged(TraceSnapshot snapshot) {
            if (snapshot.getKey() < 0L && DebuggerSnapshotTablePanel.this.hideScratch) {
                return;
            }
            DebuggerSnapshotTablePanel.this.snapshotTableModel.notifyUpdatedWith(row -> row.getSnapshot() == snapshot);
        }

        private void snapDeleted(TraceSnapshot snapshot) {
            if (snapshot.getKey() < 0L && DebuggerSnapshotTablePanel.this.hideScratch) {
                return;
            }
            DebuggerSnapshotTablePanel.this.snapshotTableModel.deleteWith(row -> row.getSnapshot() == snapshot);
        }

        private void valueCreated(TraceObjectValue value) {
            if (value.getCanonicalPath().equals((Object)KeyPath.of((String[])new String[]{"_time_radix"}))) {
                DebuggerSnapshotTablePanel.this.snapshotTableModel.fireTableDataChanged();
            }
        }

        private void valueDeleted(TraceObjectValue value) {
            if (value.getCanonicalPath().equals((Object)KeyPath.of((String[])new String[]{"_time_radix"}))) {
                DebuggerSnapshotTablePanel.this.snapshotTableModel.fireTableDataChanged();
            }
        }
    }

    protected static class SnapshotTableModel
    extends DefaultEnumeratedColumnTableModel<SnapshotTableColumns, SnapshotRow> {
        public SnapshotTableModel(PluginTool tool) {
            super(tool, "Snapshots", SnapshotTableColumns.class);
        }

        public List<SnapshotTableColumns> defaultSortOrder() {
            return List.of(SnapshotTableColumns.TIME);
        }
    }

    protected static enum SnapshotTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<SnapshotTableColumns, SnapshotRow>
    {
        SNAP("Snap", Long.class, SnapshotRow::getSnap, false),
        TIME("Time", TraceSchedule.class, SnapshotRow::getTime, true),
        EVENT_THREAD("Event Thread", String.class, SnapshotRow::getEventThreadName, true),
        PC("PC", Address.class, SnapshotRow::getProgramCounter, true),
        MODULE("Module", String.class, SnapshotRow::getModuleName, true),
        FUNCTION("Function", ghidra.program.model.listing.Function.class, SnapshotRow::getFunction, true),
        TIMESTAMP("Timestamp", Date.class, SnapshotRow::getTimeStamp, false),
        SCHEDULE("Schedule", TraceSchedule.class, SnapshotRow::getSchedule, false),
        DESCRIPTION("Description", String.class, SnapshotRow::getDescription, SnapshotRow::setDescription, true);

        private final String header;
        private final Function<SnapshotRow, ?> getter;
        private final BiConsumer<SnapshotRow, Object> setter;
        private final Class<?> cls;
        private final boolean visible;

        private <T> SnapshotTableColumns(String header, Class<T> cls, Function<SnapshotRow, T> getter, boolean visible) {
            this(header, cls, getter, null, visible);
        }

        private <T> SnapshotTableColumns(String header, Class<T> cls, Function<SnapshotRow, T> getter, BiConsumer<SnapshotRow, T> setter, boolean visible) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
            this.visible = visible;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(SnapshotRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public boolean isEditable(SnapshotRow row) {
            return this.setter != null;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public void setValueOf(SnapshotRow row, Object value) {
            this.setter.accept(row, value);
        }
    }
}

