/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import ghidra.app.plugin.core.debug.service.emulation.DefaultEmulatorFactory;
import ghidra.app.script.GhidraScript;
import ghidra.debug.api.emulation.PcodeDebuggerAccess;
import ghidra.debug.flatapi.FlatDebuggerAPI;
import ghidra.pcode.emu.*;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.exec.trace.TraceEmulationIntegration.Writer;
import ghidra.program.model.lang.Language;

public class InstallCustomLibraryScript extends GhidraScript implements FlatDebuggerAPI {
	public static class CustomPcodeEmulator extends PcodeEmulator {
		private CustomPcodeEmulator(Language language, PcodeEmulationCallbacks<byte[]> cb) {
			super(language, cb);
		}

		@Override
		protected PcodeUseropLibrary<byte[]> createUseropLibrary() {
			return super.createUseropLibrary()
					.compose(new ModelingScript.SleighStdLibPcodeUseropLibrary<>(getLanguage()));
		}
	}

	public static class CustomBytesDebuggerPcodeEmulatorFactory
			extends DefaultEmulatorFactory {
		@Override
		public PcodeMachine<?> create(PcodeDebuggerAccess access, Writer writer) {
			return new CustomPcodeEmulator(access.getLanguage(), writer.callbacks());
		}
	}

	@Override
	protected void run() throws Exception {
		getEmulationService().setEmulatorFactory(new CustomBytesDebuggerPcodeEmulatorFactory());
	}
}
