/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import java.io.IOException;
import java.util.regex.Pattern;

public final class MavenEscapeWindowsCharacterUtils {
    private static final Pattern WINDOWS_PATH_PATTERN = Pattern.compile("^(.*)[a-zA-Z]:\\\\(.*)");

    public static void escapeWindowsPath(Appendable result, String val) throws IOException {
        if (!val.isEmpty() && WINDOWS_PATH_PATTERN.matcher(val).matches()) {
            int end;
            int start = 0;
            while ((end = val.indexOf(92, start)) != -1) {
                result.append(val, start, end).append("\\\\");
                start = end + 1;
                if (val.indexOf(92, end + 1) != end + 1) continue;
                ++start;
            }
            result.append(val, start, val.length());
        } else {
            result.append(val);
        }
    }
}

