/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.router;

import com.jetbrains.cef.remote.RemoteServerObject;
import com.jetbrains.cef.remote.RpcContext;
import com.jetbrains.cef.remote.browser.RemoteBrowser;
import com.jetbrains.cef.remote.router.RemoteMessageRouterHandler;
import com.jetbrains.cef.remote.thrift_codegen.RObject;
import java.util.ArrayList;
import java.util.List;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefMessageRouter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.misc.CefLog;

public class RemoteMessageRouterImpl
extends RemoteServerObject {
    private final List<RemoteMessageRouterHandler> myHandlers = new ArrayList<RemoteMessageRouterHandler>();
    private String myQuery;
    private String myCancel;

    private RemoteMessageRouterImpl(RpcContext rpcContext, RObject robj, String query, String cancel) {
        super(rpcContext, robj);
        this.myQuery = query;
        this.myCancel = cancel;
    }

    public static RemoteMessageRouterImpl create(RpcContext rpcContext, CefMessageRouter.CefMessageRouterConfig config) {
        if (config == null) {
            config = new CefMessageRouter.CefMessageRouterConfig();
        }
        String jsQueryFunction = config.jsQueryFunction;
        String jsCancelFunction = config.jsCancelFunction;
        RObject robj = rpcContext.execObj(s -> s.MessageRouter_Create(jsQueryFunction, jsCancelFunction));
        if (robj.isNull) {
            CefLog.Error("MessageRouter_Create returns invalid objId %d (queryFunction='%s', cancelFunction='%s')", robj.objId, jsQueryFunction, jsCancelFunction);
            return null;
        }
        return new RemoteMessageRouterImpl(rpcContext, robj, jsQueryFunction, jsCancelFunction);
    }

    public void addToBrowser(int bid) {
        this.myRpc.exec(s -> s.MessageRouter_AddMessageRouterToBrowser(this.thriftId(), bid));
    }

    public void removeFromBrowser(int bid) {
        this.myRpc.exec(s -> s.MessageRouter_RemoveMessageRouterFromBrowser(this.thriftId(), bid));
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void disposeOnServerImpl() {
        List<RemoteMessageRouterHandler> list = this.myHandlers;
        synchronized (list) {
            for (RemoteMessageRouterHandler h : this.myHandlers) {
                RemoteMessageRouterHandler.FACTORY.dispose(h.getId());
            }
            this.myHandlers.clear();
        }
        RObject id = this.thriftId();
        this.myRpc.invokeLater(s -> s.MessageRouter_Dispose(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHandler(CefMessageRouterHandler handler, boolean first) {
        RemoteMessageRouterHandler rhandler = RemoteMessageRouterHandler.create(handler);
        List<RemoteMessageRouterHandler> list = this.myHandlers;
        synchronized (list) {
            this.myHandlers.add(rhandler);
        }
        this.myRpc.exec(s -> s.MessageRouter_AddHandler(this.thriftId(), rhandler.thriftId(), first));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHandler(CefMessageRouterHandler handler) {
        CefLog.Debug("%s remove handler by delegate %s", this, handler);
        RemoteMessageRouterHandler rhandler = RemoteMessageRouterHandler.findByDelegate(handler);
        if (rhandler == null) {
            return false;
        }
        List<RemoteMessageRouterHandler> list = this.myHandlers;
        synchronized (list) {
            boolean removed = this.myHandlers.remove(rhandler);
            if (!removed) {
                CefLog.Error("RemoteMessageRouterHandler %s [%d] wasn't found in myHandlers list", rhandler, rhandler.getId());
            }
        }
        this.myRpc.exec(s -> s.MessageRouter_RemoveHandler(this.thriftId(), rhandler.thriftId()));
        RemoteMessageRouterHandler.FACTORY.dispose(rhandler.getId());
        return true;
    }

    public void cancelPending(CefBrowser browser, CefMessageRouterHandler handler) {
        RemoteMessageRouterHandler rhandler = RemoteMessageRouterHandler.findByDelegate(handler);
        if (rhandler == null) {
            return;
        }
        if (browser != null && !(browser instanceof RemoteBrowser)) {
            CefLog.Error("Can't cancelPending on non-remote browser " + browser, new Object[0]);
        } else {
            int bid = browser == null ? -1 : ((RemoteBrowser)browser).getBid();
            this.myRpc.exec(s -> s.MessageRouter_CancelPending(this.thriftId(), bid, rhandler.thriftId()));
        }
    }

    public String toString() {
        return String.format("Router<%s | %s>", this.myQuery, this.myCancel);
    }
}

