/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import org.jetbrains.annotations.NotNull;

public enum Nullability {
    NULL(true, false),
    NOT_NULL(false, true),
    UNKNOWN(true, true),
    IMPOSSIBLE(false, false);

    private final boolean canBeNull;
    private final boolean canBeNonNull;

    @NotNull
    public static Nullability fromFlags(boolean canBeNull, boolean canBeNonNull) {
        if (!canBeNull && !canBeNonNull) {
            Nullability nullability = IMPOSSIBLE;
            if (nullability == null) {
                Nullability.$$$reportNull$$$0(0);
            }
            return nullability;
        }
        if (!canBeNull && canBeNonNull) {
            Nullability nullability = NOT_NULL;
            if (nullability == null) {
                Nullability.$$$reportNull$$$0(1);
            }
            return nullability;
        }
        if (canBeNull && !canBeNonNull) {
            Nullability nullability = NULL;
            if (nullability == null) {
                Nullability.$$$reportNull$$$0(2);
            }
            return nullability;
        }
        Nullability nullability = UNKNOWN;
        if (nullability == null) {
            Nullability.$$$reportNull$$$0(3);
        }
        return nullability;
    }

    private Nullability(boolean canBeNull, boolean canBeNonNull) {
        this.canBeNull = canBeNull;
        this.canBeNonNull = canBeNonNull;
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public boolean canBeNonNull() {
        return this.canBeNonNull;
    }

    @NotNull
    public Nullability refine(@NotNull Nullability other) {
        if (other == null) {
            Nullability.$$$reportNull$$$0(4);
        }
        switch (this) {
            case UNKNOWN: {
                Nullability nullability = other;
                if (nullability == null) {
                    Nullability.$$$reportNull$$$0(5);
                }
                return nullability;
            }
            case IMPOSSIBLE: {
                Nullability nullability = other;
                if (nullability == null) {
                    Nullability.$$$reportNull$$$0(6);
                }
                return nullability;
            }
            case NULL: {
                switch (other) {
                    case NOT_NULL: {
                        Nullability nullability = NOT_NULL;
                        if (nullability == null) {
                            Nullability.$$$reportNull$$$0(7);
                        }
                        return nullability;
                    }
                }
                Nullability nullability = NULL;
                if (nullability == null) {
                    Nullability.$$$reportNull$$$0(8);
                }
                return nullability;
            }
            case NOT_NULL: {
                switch (other) {
                    case NULL: {
                        Nullability nullability = NOT_NULL;
                        if (nullability == null) {
                            Nullability.$$$reportNull$$$0(9);
                        }
                        return nullability;
                    }
                }
                Nullability nullability = NOT_NULL;
                if (nullability == null) {
                    Nullability.$$$reportNull$$$0(10);
                }
                return nullability;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    public Nullability invert() {
        switch (this) {
            case NULL: {
                Nullability nullability = NOT_NULL;
                if (nullability == null) {
                    Nullability.$$$reportNull$$$0(11);
                }
                return nullability;
            }
            case NOT_NULL: {
                Nullability nullability = UNKNOWN;
                if (nullability == null) {
                    Nullability.$$$reportNull$$$0(12);
                }
                return nullability;
            }
            case UNKNOWN: {
                Nullability nullability = UNKNOWN;
                if (nullability == null) {
                    Nullability.$$$reportNull$$$0(13);
                }
                return nullability;
            }
            case IMPOSSIBLE: {
                Nullability nullability = UNKNOWN;
                if (nullability == null) {
                    Nullability.$$$reportNull$$$0(14);
                }
                return nullability;
            }
        }
        throw new IllegalStateException();
    }

    @NotNull
    public Nullability and(@NotNull Nullability other) {
        if (other == null) {
            Nullability.$$$reportNull$$$0(15);
        }
        return Nullability.fromFlags(this.canBeNull && other.canBeNull, this.canBeNonNull && other.canBeNonNull);
    }

    @NotNull
    public Nullability or(@NotNull Nullability other) {
        if (other == null) {
            Nullability.$$$reportNull$$$0(16);
        }
        return Nullability.fromFlags(this.canBeNull || other.canBeNull, this.canBeNonNull || other.canBeNonNull);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability";
                break;
            }
            case 4: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromFlags";
                break;
            }
            case 4: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/calls/smartcasts/Nullability";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "refine";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "invert";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

