/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.cache.impl.EncodingFunction;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Ids;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;

@Scope(value=Scopes.NONE)
public class EncoderValueMapper<V>
implements EncodingFunction<V> {
    private final DataConversion dataConversion;

    public EncoderValueMapper(DataConversion dataConversion) {
        this.dataConversion = dataConversion;
    }

    @Inject
    public void injectDependencies(ComponentRegistry registry) {
        registry.wireDependencies(this.dataConversion);
    }

    @Override
    public V apply(V v) {
        return (V)this.dataConversion.fromStorage(v);
    }

    public static class Externalizer
    implements AdvancedExternalizer<EncoderValueMapper> {
        public Set<Class<? extends EncoderValueMapper>> getTypeClasses() {
            return Collections.singleton(EncoderValueMapper.class);
        }

        public Integer getId() {
            return Ids.ENCODER_VALUE_MAPPER;
        }

        public void writeObject(ObjectOutput output, EncoderValueMapper object) throws IOException {
            DataConversion.writeTo(output, object.dataConversion);
        }

        public EncoderValueMapper readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new EncoderValueMapper(DataConversion.readFrom(input));
        }
    }
}

