/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.relational.internal;

import java.util.Map;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedName;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.jdbc.env.spi.QualifiedObjectNameFormatter;

public class SqlStringGenerationContextImpl
implements SqlStringGenerationContext {
    private final Dialect dialect;
    private final IdentifierHelper identifierHelper;
    private final QualifiedObjectNameFormatter qualifiedObjectNameFormatter;
    private final Identifier defaultCatalog;
    private final Identifier defaultSchema;
    private final boolean migration;

    public static SqlStringGenerationContext fromConfigurationMap(JdbcEnvironment jdbcEnvironment, Database database, Map<String, Object> configurationMap) {
        String defaultCatalog = (String)configurationMap.get("hibernate.default_catalog");
        String defaultSchema = (String)configurationMap.get("hibernate.default_schema");
        return SqlStringGenerationContextImpl.create(jdbcEnvironment, database, defaultCatalog, defaultSchema, false);
    }

    public static SqlStringGenerationContext fromConfigurationMapForMigration(JdbcEnvironment jdbcEnvironment, Database database, Map<String, Object> configurationMap) {
        String defaultCatalog = (String)configurationMap.get("hibernate.default_catalog");
        String defaultSchema = (String)configurationMap.get("hibernate.default_schema");
        return SqlStringGenerationContextImpl.create(jdbcEnvironment, database, defaultCatalog, defaultSchema, true);
    }

    public static SqlStringGenerationContext fromExplicit(JdbcEnvironment jdbcEnvironment, Database database, String defaultCatalog, String defaultSchema) {
        return SqlStringGenerationContextImpl.create(jdbcEnvironment, database, defaultCatalog, defaultSchema, false);
    }

    private static SqlStringGenerationContext create(JdbcEnvironment jdbcEnvironment, Database database, String defaultCatalog, String defaultSchema, boolean forMigration) {
        Namespace.Name implicitNamespaceName = database.getPhysicalImplicitNamespaceName();
        IdentifierHelper identifierHelper = jdbcEnvironment.getIdentifierHelper();
        NameQualifierSupport nameQualifierSupport = jdbcEnvironment.getNameQualifierSupport();
        Identifier actualDefaultCatalog = null;
        if (nameQualifierSupport.supportsCatalogs() && (actualDefaultCatalog = identifierHelper.toIdentifier(defaultCatalog)) == null) {
            actualDefaultCatalog = implicitNamespaceName.catalog();
        }
        Identifier actualDefaultSchema = null;
        if (nameQualifierSupport.supportsSchemas()) {
            actualDefaultSchema = identifierHelper.toIdentifier(defaultSchema);
            if (defaultSchema == null) {
                actualDefaultSchema = implicitNamespaceName.schema();
            }
        }
        return new SqlStringGenerationContextImpl(jdbcEnvironment, actualDefaultCatalog, actualDefaultSchema, forMigration);
    }

    public static SqlStringGenerationContext forTests(JdbcEnvironment jdbcEnvironment) {
        return SqlStringGenerationContextImpl.forTests(jdbcEnvironment, null, null);
    }

    public static SqlStringGenerationContext forTests(JdbcEnvironment jdbcEnvironment, String defaultCatalog, String defaultSchema) {
        IdentifierHelper identifierHelper = jdbcEnvironment.getIdentifierHelper();
        return new SqlStringGenerationContextImpl(jdbcEnvironment, identifierHelper.toIdentifier(defaultCatalog), identifierHelper.toIdentifier(defaultSchema), false);
    }

    private SqlStringGenerationContextImpl(JdbcEnvironment jdbcEnvironment, Identifier defaultCatalog, Identifier defaultSchema, boolean migration) {
        this.dialect = jdbcEnvironment.getDialect();
        this.identifierHelper = jdbcEnvironment.getIdentifierHelper();
        this.qualifiedObjectNameFormatter = jdbcEnvironment.getQualifiedObjectNameFormatter();
        this.defaultCatalog = defaultCatalog;
        this.defaultSchema = defaultSchema;
        this.migration = migration;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public Identifier toIdentifier(String text) {
        return this.identifierHelper != null ? this.identifierHelper.toIdentifier(text) : Identifier.toIdentifier(text);
    }

    @Override
    public Identifier getDefaultCatalog() {
        return this.defaultCatalog;
    }

    @Override
    public Identifier getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public String format(QualifiedTableName qualifiedName) {
        return this.qualifiedObjectNameFormatter.format(this.withDefaults(qualifiedName), this.dialect);
    }

    @Override
    public String format(QualifiedSequenceName qualifiedName) {
        return this.qualifiedObjectNameFormatter.format(this.withDefaults(qualifiedName), this.dialect);
    }

    @Override
    public String format(QualifiedName qualifiedName) {
        return this.qualifiedObjectNameFormatter.format(this.withDefaults(qualifiedName), this.dialect);
    }

    @Override
    public String formatWithoutCatalog(QualifiedSequenceName qualifiedName) {
        QualifiedSequenceName nameToFormat = qualifiedName.getCatalogName() != null || qualifiedName.getSchemaName() == null && this.defaultSchema != null ? new QualifiedSequenceName(null, this.schemaWithDefault(qualifiedName.getSchemaName()), qualifiedName.getSequenceName()) : qualifiedName;
        return this.qualifiedObjectNameFormatter.format(nameToFormat, this.dialect);
    }

    @Override
    public boolean isMigration() {
        return this.migration;
    }
}

