/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.Locking;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.InArrayPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcOperationQueryInsertImpl;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcOperationQueryInsert;

public class CockroachLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public CockroachLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql("floor");
        }
        super.visitBinaryArithmeticExpression(arithmeticExpression);
    }

    protected JdbcOperationQueryInsert translateInsert(InsertSelectStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcOperationQueryInsertImpl(this.getSql(), this.getParameterBinders(), this.getAffectedTableNames(), null);
    }

    protected void renderTableReferenceIdentificationVariable(TableReference tableReference) {
        String identificationVariable = tableReference.getIdentificationVariable();
        if (identificationVariable != null) {
            Clause currentClause = (Clause)this.getClauseStack().getCurrent();
            if (currentClause == Clause.INSERT) {
                this.appendSql(" as ");
            } else {
                this.append(' ');
            }
            this.append(tableReference.getIdentificationVariable());
        }
    }

    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        Statement currentStatement = (Statement)this.getStatementStack().getCurrent();
        if (!(currentStatement instanceof UpdateStatement) || !CockroachLegacySqlAstTranslator.hasNonTrivialFromClause((FromClause)((UpdateStatement)currentStatement).getFromClause())) {
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        }
    }

    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
        this.renderFromClauseJoiningDmlTargetReference(statement);
    }

    protected void visitConflictClause(ConflictClause conflictClause) {
        this.visitStandardConflictClause(conflictClause);
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        if (booleanExpressionPredicate.isNegated()) {
            super.visitBooleanExpressionPredicate(booleanExpressionPredicate);
        } else {
            boolean isNegated = booleanExpressionPredicate.isNegated();
            if (isNegated) {
                this.appendSql("not (");
            }
            booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
            if (isNegated) {
                this.appendSql(')');
            }
        }
    }

    protected void renderMaterializationHint(CteMaterialization materialization) {
        if (this.getDialect().getVersion().isSameOrAfter(20, 2)) {
            if (materialization == CteMaterialization.NOT_MATERIALIZED) {
                this.appendSql("not ");
            }
            this.appendSql("materialized ");
        }
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, Locking.FollowOn followOnLocking) {
        if (this.getDialect().getVersion().isBefore(20, 1)) {
            return AbstractSqlAstTranslator.LockStrategy.NONE;
        }
        return super.determineLockingStrategy(querySpec, followOnLocking);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderLimitOffsetClause(queryPart);
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitLikePredicate(LikePredicate likePredicate) {
        likePredicate.getMatchExpression().accept((SqlAstWalker)this);
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        if (likePredicate.isCaseSensitive()) {
            this.appendSql(" like ");
        } else {
            this.appendSql(' ');
            this.appendSql(this.getDialect().getCaseInsensitiveLike());
            this.appendSql(' ');
        }
        likePredicate.getPattern().accept((SqlAstWalker)this);
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept((SqlAstWalker)this);
        } else {
            this.appendSql(" escape ''");
        }
    }

    public void visitInArrayPredicate(InArrayPredicate inArrayPredicate) {
        inArrayPredicate.getTestExpression().accept((SqlAstWalker)this);
        this.appendSql(" = any(");
        inArrayPredicate.getArrayParameter().accept((SqlAstWalker)this);
        this.appendSql(')');
    }
}

