/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.metamodel.Attribute;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.hibernate.HibernateException;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.hibernate.UnknownEntityTypeException;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementAsProxyLazinessInterceptor;
import org.hibernate.collection.spi.LazyInitializable;
import org.hibernate.collection.spi.PersistentBag;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.collection.spi.PersistentList;
import org.hibernate.collection.spi.PersistentMap;
import org.hibernate.collection.spi.PersistentSet;
import org.hibernate.collection.spi.PersistentSortedMap;
import org.hibernate.collection.spi.PersistentSortedSet;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.env.internal.NonContextualLobCreator;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public final class Hibernate {
    private static final LobHelper lobHelper = new LobHelperImpl();

    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static void initialize(Object proxy) throws HibernateException {
        if (proxy != null) {
            PersistentAttributeInterceptor persistentAttributeInterceptor;
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
            if (lazyInitializer != null) {
                lazyInitializer.initialize();
            } else if (proxy instanceof LazyInitializable) {
                LazyInitializable lazyInitializable = (LazyInitializable)proxy;
                lazyInitializable.forceInitialization();
            } else if (ManagedTypeHelper.isPersistentAttributeInterceptable(proxy) && (persistentAttributeInterceptor = Hibernate.getAttributeInterceptor(proxy)) instanceof EnhancementAsProxyLazinessInterceptor) {
                EnhancementAsProxyLazinessInterceptor enhancementInterceptor = (EnhancementAsProxyLazinessInterceptor)persistentAttributeInterceptor;
                enhancementInterceptor.forceInitialize(proxy, null);
            }
        }
    }

    public static boolean isInitialized(Object proxy) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
        if (lazyInitializer != null) {
            return !lazyInitializer.isUninitialized();
        }
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(proxy)) {
            EnhancementAsProxyLazinessInterceptor enhancementInterceptor;
            PersistentAttributeInterceptor persistentAttributeInterceptor = Hibernate.getAttributeInterceptor(proxy);
            boolean uninitialized = persistentAttributeInterceptor instanceof EnhancementAsProxyLazinessInterceptor && !(enhancementInterceptor = (EnhancementAsProxyLazinessInterceptor)persistentAttributeInterceptor).isInitialized();
            return !uninitialized;
        }
        if (proxy instanceof LazyInitializable) {
            LazyInitializable lazyInitializable = (LazyInitializable)proxy;
            return lazyInitializable.wasInitialized();
        }
        return true;
    }

    public static int size(Collection<?> collection) {
        int n;
        if (collection instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)((Object)collection);
            n = persistentCollection.getSize();
        } else {
            n = collection.size();
        }
        return n;
    }

    public static boolean isEmpty(Collection<?> collection) {
        PersistentCollection persistentCollection;
        return collection instanceof PersistentCollection ? (persistentCollection = (PersistentCollection)((Object)collection)).getSize() == 0 : collection.isEmpty();
    }

    public static <T> boolean contains(Collection<? super T> collection, T element) {
        boolean bl;
        if (collection instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)((Object)collection);
            bl = persistentCollection.elementExists(element);
        } else {
            bl = collection.contains(element);
        }
        return bl;
    }

    public static <K, V> V get(Map<? super K, V> map, K key) {
        Object object;
        if (map instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)((Object)map);
            object = persistentCollection.elementByIndex(key);
        } else {
            object = map.get(key);
        }
        return object;
    }

    public static <T> T get(List<T> list, int key) {
        Object object;
        if (list instanceof PersistentCollection) {
            PersistentCollection persistentCollection = (PersistentCollection)((Object)list);
            object = persistentCollection.elementByIndex(key);
        } else {
            object = list.get(key);
        }
        return object;
    }

    public static <T> Class<? extends T> getClass(T proxy) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
        Class<?> result = lazyInitializer != null ? lazyInitializer.getImplementation().getClass() : proxy.getClass();
        return result;
    }

    public static <T> Class<? extends T> getClassLazy(T proxy) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
        Class<?> result = lazyInitializer != null ? lazyInitializer.getImplementationClass() : proxy.getClass();
        return result;
    }

    public static boolean isInstance(Object proxy, Class<?> entityClass) {
        return entityClass.isInstance(proxy) || entityClass.isAssignableFrom(Hibernate.getClass(proxy));
    }

    public static <E> boolean isPropertyInitialized(E entity, Attribute<? super E, ?> attribute) {
        return Hibernate.isPropertyInitialized(entity, attribute.getName());
    }

    public static boolean isPropertyInitialized(Object proxy, String attributeName) {
        BytecodeLazyAttributeInterceptor lazyAttributeInterceptor;
        PersistentAttributeInterceptor persistentAttributeInterceptor;
        Object entity;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
        if (lazyInitializer != null) {
            if (lazyInitializer.isUninitialized()) {
                return false;
            }
            entity = lazyInitializer.getImplementation();
        } else {
            entity = proxy;
        }
        boolean attributeUnloaded = ManagedTypeHelper.isPersistentAttributeInterceptable(entity) && (persistentAttributeInterceptor = Hibernate.getAttributeInterceptor(entity)) instanceof BytecodeLazyAttributeInterceptor && !(lazyAttributeInterceptor = (BytecodeLazyAttributeInterceptor)persistentAttributeInterceptor).isAttributeLoaded(attributeName);
        return !attributeUnloaded;
    }

    public static <E> void initializeProperty(E entity, Attribute<? super E, ?> attribute) {
        Hibernate.initializeProperty(entity, attribute.getName());
    }

    public static void initializeProperty(Object proxy, String attributeName) {
        Object entity;
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
        Object object = entity = lazyInitializer != null ? lazyInitializer.getImplementation() : proxy;
        if (ManagedTypeHelper.isPersistentAttributeInterceptable(entity)) {
            Hibernate.getAttributeInterceptor(entity).readObject(entity, attributeName, null);
        }
    }

    public static Object unproxy(Object proxy) {
        LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(proxy);
        return lazyInitializer != null ? lazyInitializer.getImplementation() : proxy;
    }

    public static <T> T unproxy(T proxy, Class<T> entityClass) {
        return entityClass.cast(Hibernate.unproxy(proxy));
    }

    public static <E> E createDetachedProxy(SessionFactory sessionFactory, Class<E> entityClass, Object id) {
        EntityPersister persister = ((SessionFactoryImplementor)sessionFactory.unwrap(SessionFactoryImplementor.class)).getMappingMetamodel().findEntityDescriptor(entityClass);
        if (persister == null) {
            throw new UnknownEntityTypeException(entityClass);
        }
        return (E)persister.createProxy(id, null);
    }

    public static <U> CollectionInterface<Collection<U>> bag() {
        return new CollectionInterface<Collection<U>>(PersistentBag::new, ArrayList::new);
    }

    public static <U> CollectionInterface<Set<U>> set() {
        return new CollectionInterface<Set<U>>(PersistentSet::new, HashSet::new);
    }

    public static <U> CollectionInterface<List<U>> list() {
        return new CollectionInterface<List<U>>(PersistentList::new, ArrayList::new);
    }

    public static <U, V> CollectionInterface<Map<U, V>> map() {
        return new CollectionInterface<Map<U, V>>(PersistentMap::new, HashMap::new);
    }

    public static <U> CollectionInterface<SortedSet<U>> sortedSet() {
        return new CollectionInterface<SortedSet<U>>(PersistentSortedSet::new, TreeSet::new);
    }

    public static <U, V> CollectionInterface<Map<U, V>> sortedMap() {
        return new CollectionInterface<Map<U, V>>(PersistentSortedMap::new, TreeMap::new);
    }

    public static <C> CollectionInterface<C> collection(Class<C> collectionClass) {
        if (collectionClass == List.class) {
            return Hibernate.list();
        }
        if (collectionClass == Set.class) {
            return Hibernate.set();
        }
        if (collectionClass == Map.class) {
            return Hibernate.map();
        }
        if (collectionClass == SortedMap.class) {
            return Hibernate.sortedMap();
        }
        if (collectionClass == SortedSet.class) {
            return Hibernate.sortedSet();
        }
        if (collectionClass == Collection.class) {
            return Hibernate.bag();
        }
        throw new IllegalArgumentException("illegal collection interface type");
    }

    public static LobHelper getLobHelper() {
        return lobHelper;
    }

    private static PersistentAttributeInterceptor getAttributeInterceptor(Object entity) {
        return ManagedTypeHelper.asPersistentAttributeInterceptable(entity).$$_hibernate_getInterceptor();
    }

    public static final class CollectionInterface<C> {
        private final Supplier<C> detached;
        private final Supplier<C> created;

        private CollectionInterface(Supplier<C> detached, Supplier<C> created) {
            this.detached = detached;
            this.created = created;
        }

        public C createDetachedInstance() {
            return this.detached.get();
        }

        public C createNewInstance() {
            return this.created.get();
        }
    }

    private static class LobHelperImpl
    implements LobHelper {
        private LobHelperImpl() {
        }

        @Override
        public Blob createBlob(byte[] bytes) {
            return this.lobCreator().createBlob(bytes);
        }

        private LobCreator lobCreator() {
            return NonContextualLobCreator.INSTANCE;
        }

        @Override
        public Blob createBlob(InputStream stream, long length) {
            return this.lobCreator().createBlob(stream, length);
        }

        @Override
        public Clob createClob(String string) {
            return this.lobCreator().createClob(string);
        }

        @Override
        public Clob createClob(Reader reader, long length) {
            return this.lobCreator().createClob(reader, length);
        }

        @Override
        public NClob createNClob(String string) {
            return this.lobCreator().createNClob(string);
        }

        @Override
        public NClob createNClob(Reader reader, long length) {
            return this.lobCreator().createNClob(reader, length);
        }
    }
}

