/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc;

public class OracleDatabaseException
extends Exception {
    private static final long serialVersionUID = 2L;
    private static boolean DEBUG = false;
    private final int errorPosition;
    private final int oracleErrorNumber;
    private final String sql;
    private final String originalSql;
    private final boolean isSqlRewritten;

    public OracleDatabaseException(int errorPosition, int oracleErrorNumber, String oracleErrorMessage, String sql, String originalSql) {
        this(errorPosition, oracleErrorNumber, oracleErrorMessage, sql, originalSql, false);
    }

    public OracleDatabaseException(int errorPosition, int oracleErrorNumber, String oracleErrorMessage, String sql, String originalSql, boolean isSqlRewritten) {
        super(oracleErrorMessage);
        this.errorPosition = errorPosition;
        this.oracleErrorNumber = oracleErrorNumber;
        this.sql = sql;
        this.originalSql = originalSql;
        this.isSqlRewritten = isSqlRewritten;
    }

    public int getErrorPosition() {
        return this.errorPosition;
    }

    public int getOracleErrorNumber() {
        return this.oracleErrorNumber;
    }

    public String getSql() {
        return this.sql;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public boolean isSqlRewritten() {
        return this.isSqlRewritten;
    }

    @Override
    public String toString() {
        String s = "Error : " + this.oracleErrorNumber + ", Position : " + this.errorPosition + ", SQL = " + this.sql + (this.isSqlRewritten ? " [SQL INCLUDES EXPRESSIONS ADDED BY THE ORACLE JDBC DRIVER]" : "") + ", Original SQL = " + this.originalSql + ", Error Message = " + this.getMessage();
        return s;
    }
}

