"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingADPlugin;
var _constants = require("../../services/utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function alertingADPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.alertingAD = components.clientAction.namespaceFactory();
  const alertingAD = Client.prototype.alertingAD.prototype;
  alertingAD.getDetector = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alertingAD.searchDetectors = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alertingAD.previewDetector = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/<%=detectorId%>/_preview`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alertingAD.searchResults = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/results/_search`
    },
    needBody: true,
    method: 'POST'
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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