/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageFlags;
import software.amazon.awssdk.crt.eventstream.MessageType;
import software.amazon.awssdk.crt.eventstream.ServerConnection;
import software.amazon.awssdk.crt.eventstream.ServerConnectionContinuation;
import software.amazon.awssdk.crt.eventstream.ServerConnectionContinuationHandler;
import software.amazon.awssdk.crt.eventstream.ServerConnectionHandler;

public class OperationRoutingServerConnectionHandler
extends ServerConnectionHandler {
    private final Map<String, Function<ServerConnectionContinuation, ServerConnectionContinuationHandler>> operationMap;

    public OperationRoutingServerConnectionHandler(ServerConnection serverConnection, Map<String, Function<ServerConnectionContinuation, ServerConnectionContinuationHandler>> operationMapping) {
        super(serverConnection);
        this.operationMap = operationMapping;
    }

    @Override
    protected void onProtocolMessage(List<Header> headers, byte[] payload, MessageType messageType, int messageFlags) {
        if (messageType == MessageType.Ping) {
            int responseMessageFlag = 0;
            MessageType responseMessageType = MessageType.PingResponse;
            this.connection.sendProtocolMessage(null, null, responseMessageType, responseMessageFlag);
        } else if (messageType == MessageType.Connect) {
            this.onConnectRequest(headers, payload);
        } else if (messageType != MessageType.PingResponse) {
            int responseMessageFlag = 0;
            MessageType responseMessageType = MessageType.ServerError;
            String responsePayload = "{ \"error\": \"Unrecognized Message Type\" }\"message\": \" message type value: " + messageType.getEnumValue() + " is not recognized as a valid request path.\" }";
            Header contentTypeHeader = Header.createHeader(":content-type", "application/json");
            ArrayList<Header> responseHeaders = new ArrayList<Header>();
            responseHeaders.add(contentTypeHeader);
            CompletableFuture<Void> voidCompletableFuture = this.connection.sendProtocolMessage(responseHeaders, responsePayload.getBytes(StandardCharsets.UTF_8), responseMessageType, responseMessageFlag);
            voidCompletableFuture.thenAccept(result -> {
                this.connection.closeConnection(0);
                this.close();
            });
        }
    }

    protected void onConnectRequest(List<Header> headers, byte[] payload) {
        int responseMessageFlag = MessageFlags.ConnectionAccepted.getByteValue();
        MessageType acceptResponseType = MessageType.ConnectAck;
        this.connection.sendProtocolMessage(null, null, acceptResponseType, responseMessageFlag);
    }

    @Override
    protected final ServerConnectionContinuationHandler onIncomingStream(ServerConnectionContinuation continuation, final String operationName) {
        Function<ServerConnectionContinuation, ServerConnectionContinuationHandler> registeredOperationHandlerFn = this.operationMap.get(operationName);
        if (registeredOperationHandlerFn != null) {
            return registeredOperationHandlerFn.apply(continuation);
        }
        return new ServerConnectionContinuationHandler(continuation){

            @Override
            protected void onContinuationClosed() {
                this.close();
            }

            @Override
            protected void onContinuationMessage(List<Header> headers, byte[] payload, MessageType messageType, int messageFlags) {
                int responseMessageFlag = MessageFlags.TerminateStream.getByteValue();
                MessageType responseMessageType = MessageType.ApplicationError;
                String responsePayload = "{ \"error\": \"Unsupported Operation\", \"message\": \"" + operationName + " is an unsupported operation.\" }";
                Header contentTypeHeader = Header.createHeader(":content-type", "application/json");
                ArrayList<Header> responseHeaders = new ArrayList<Header>();
                responseHeaders.add(contentTypeHeader);
                this.continuation.sendMessage(responseHeaders, responsePayload.getBytes(StandardCharsets.UTF_8), responseMessageType, responseMessageFlag);
            }
        };
    }
}

