/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.IdentityFilter;

public class CryptFilter
implements Filter {
    @Override
    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        COSName encryptionName = (COSName)options.getDictionaryObject(COSName.NAME);
        if (encryptionName != null && !encryptionName.equals(COSName.IDENTITY)) {
            throw new IOException("Unsupported crypt filter " + encryptionName.getName());
        }
        IdentityFilter identityFilter = new IdentityFilter();
        identityFilter.decode(compressedData, result, options, filterIndex);
    }

    @Override
    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        COSName encryptionName = (COSName)options.getDictionaryObject(COSName.NAME);
        if (encryptionName != null && !encryptionName.equals(COSName.IDENTITY)) {
            throw new IOException("Unsupported crypt filter " + encryptionName.getName());
        }
        IdentityFilter identityFilter = new IdentityFilter();
        identityFilter.encode(rawData, result, options, filterIndex);
    }
}

