/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.time.Duration;
import org.apache.tomcat.dbcp.pool2.impl.PoolImplUtils;

public class EvictionConfig {
    private static final Duration MAX_DURATION = Duration.ofMillis(Long.MAX_VALUE);
    private final Duration idleEvictDuration;
    private final Duration idleSoftEvictDuration;
    private final int minIdle;

    public EvictionConfig(Duration duration, Duration duration2, int n) {
        this.idleEvictDuration = PoolImplUtils.isPositive(duration) ? duration : MAX_DURATION;
        this.idleSoftEvictDuration = PoolImplUtils.isPositive(duration2) ? duration2 : MAX_DURATION;
        this.minIdle = n;
    }

    @Deprecated
    public EvictionConfig(long l, long l2, int n) {
        this(Duration.ofMillis(l), Duration.ofMillis(l2), n);
    }

    public Duration getIdleEvictDuration() {
        return this.idleEvictDuration;
    }

    @Deprecated
    public long getIdleEvictTime() {
        return this.idleEvictDuration.toMillis();
    }

    @Deprecated
    public Duration getIdleEvictTimeDuration() {
        return this.idleEvictDuration;
    }

    public Duration getIdleSoftEvictDuration() {
        return this.idleSoftEvictDuration;
    }

    @Deprecated
    public long getIdleSoftEvictTime() {
        return this.idleSoftEvictDuration.toMillis();
    }

    @Deprecated
    public Duration getIdleSoftEvictTimeDuration() {
        return this.idleSoftEvictDuration;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("EvictionConfig [idleEvictDuration=");
        stringBuilder.append(this.idleEvictDuration);
        stringBuilder.append(", idleSoftEvictDuration=");
        stringBuilder.append(this.idleSoftEvictDuration);
        stringBuilder.append(", minIdle=");
        stringBuilder.append(this.minIdle);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

