/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.gp.data;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public interface BitField<T extends Enum<T>> {
    public static boolean has(Def f, byte[] bytes, boolean lax) {
        if (f instanceof Def.Bits) {
            Def.Bits bits = (Def.Bits)f;
            int yes = 0;
            for (Byte bit : bits.bits()) {
                if (!BitField.get_bit(bit, bytes)) continue;
                ++yes;
            }
            return yes == bits.bits().size();
        }
        if (f instanceof Def.ByteMask) {
            Def.ByteMask byteMask = (Def.ByteMask)f;
            if (byteMask.n() >= bytes.length) {
                if (lax) {
                    return false;
                }
                throw new IllegalArgumentException("Need byte at index " + byteMask.n() + " but only " + bytes.length + " bytes provided");
            }
            return (bytes[byteMask.n()] & byteMask.mask()) == byteMask.mask();
        }
        if (f instanceof Def.RFU) {
            Def.RFU rfu = (Def.RFU)f;
            return BitField.has(rfu.def(), bytes, true);
        }
        return false;
    }

    public static <T extends Enum<T>> Set<T> parse(Class<T> base, byte[] bytes) {
        EnumSet<T> result = EnumSet.noneOf(base);
        for (Enum e : (Enum[])base.getEnumConstants()) {
            if (!BitField.has(((BitField)((Object)e)).def(), bytes, true)) continue;
            result.add(e);
            if (!e.name().equals("RFU")) continue;
        }
        return result;
    }

    public static <T extends Enum<T>> byte[] toBytes(EnumSet<T> fields, int length) {
        byte[] result = new byte[length];
        for (Enum field : fields) {
            Def def = ((BitField)((Object)field)).def();
            if (def instanceof Def.Bits) {
                Def.Bits bits = (Def.Bits)def;
                for (Byte bit : bits.bits()) {
                    int byteIdx = bit >> 3;
                    if (byteIdx >= length) continue;
                    BitField.set_bit(bit, result);
                }
                continue;
            }
            if (def instanceof Def.ByteMask) {
                Def.ByteMask byteMask = (Def.ByteMask)def;
                if (byteMask.n() >= length) continue;
                byte by = byteMask.n();
                result[by] = (byte)(result[by] | byteMask.mask());
                continue;
            }
            if (!(def instanceof Def.RFU)) continue;
            Def.RFU rfu = (Def.RFU)def;
            throw new IllegalArgumentException("RFU bits should never be serialized: " + String.valueOf(rfu));
        }
        return result;
    }

    public static <T extends Enum<T>> byte[] toBytes(EnumSet<T> fields) {
        int length;
        byte[] result = BitField.toBytes(fields, 16);
        for (length = 16; length > 0 && result[length - 1] == 0; --length) {
        }
        byte[] trimmed = new byte[length];
        System.arraycopy(result, 0, trimmed, 0, length);
        return trimmed;
    }

    public static boolean set_bit(byte bit, byte[] bytes) {
        return BitField.set_bit(bytes, (short)0, bit);
    }

    public static boolean get_bit(byte bit, byte[] bytes) {
        return BitField.set_bit(bytes, (short)0, bit);
    }

    public static boolean set_bit(byte[] buffer, short offset, byte bit) {
        short byteIdx = (short)(offset + (bit >> 3));
        byte bitInByte = (byte)(7 - (bit & 7));
        boolean previous = (byte)(buffer[byteIdx] >> bitInByte & 1) == 1;
        buffer[byteIdx] = (byte)(buffer[byteIdx] | (byte)(1 << bitInByte));
        return previous;
    }

    public static boolean get_bit(byte[] buffer, short offset, byte bit) {
        short byteIdx = (short)(offset + (bit >> 3));
        byte bitInByte = (byte)(7 - (bit & 7));
        return (byte)(buffer[byteIdx] >> bitInByte & 1) == 1;
    }

    public static Def.Bits bit(int n) {
        return BitField.bits((byte)n);
    }

    public static Def.Bits bits(int ... bits) {
        return new Def.Bits(Arrays.stream(bits).mapToObj(i -> (byte)i).toList());
    }

    public static Def.Bits byte_bit(int nthByte, int bit) {
        return BitField.bits((byte)(nthByte * 8 + bit));
    }

    public static Def.Bits byte_bit_rl(byte nthByte, int bit) {
        return BitField.bits((byte)((nthByte - 1) * 8 + (8 - bit)));
    }

    public static Def byte_mask(int n, int mask) {
        return new Def.ByteMask((byte)n, (byte)(mask & 0xFF));
    }

    public Def def();

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Def {

        public record RFU(Def def) implements Def
        {
        }

        public record ByteMask(byte n, byte mask) implements Def
        {
        }

        public record Bits(List<Byte> bits) implements Def
        {
            public Bits {
                bits = List.copyOf(bits);
            }
        }
    }
}

