/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.pci.ids.model;

import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.glavo.pci.ids.internal.ArgumentValidator;
import org.glavo.pci.ids.model.Subsystem;

public final class Device
implements Comparable<Device> {
    private final int id;
    private final String name;
    private final String comment;
    private final SortedSet<Subsystem> subsystems;

    public Device(int id, String name, String comment) {
        ArgumentValidator.requireUnsignedShort(id, "Device ID");
        ArgumentValidator.requireNonBlank(name, "Device name");
        this.id = id;
        this.name = name;
        this.comment = comment;
        this.subsystems = new TreeSet<Subsystem>();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public void addSubsystem(Subsystem subsys) {
        ArgumentValidator.requireNonNull(subsys, "Device subsystem");
        this.subsystems.add(subsys);
    }

    public SortedSet<Subsystem> getSubsystems() {
        return Collections.unmodifiableSortedSet(this.subsystems);
    }

    @Override
    public int compareTo(Device t) {
        return Integer.compare(this.id, t.id);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Device)) {
            return false;
        }
        Device device = (Device)o;
        return Objects.equals(this.id, device.id) && Objects.equals(this.name, device.name);
    }

    public String toString() {
        return String.format("Device[id=%04x, name='%s']", this.id, this.name);
    }
}

