/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleGroup;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.versions.GameListItemSkin;
import org.jackhuang.hmcl.ui.versions.Versions;

public class GameListItem
extends Control {
    private final Profile profile;
    private final String version;
    private final boolean isModpack;
    private final ToggleGroup toggleGroup;
    private final BooleanProperty selected = new SimpleBooleanProperty();

    public GameListItem(ToggleGroup toggleGroup, Profile profile, String id) {
        this.profile = profile;
        this.version = id;
        this.toggleGroup = toggleGroup;
        this.isModpack = profile.getRepository().isModpack(id);
        this.selected.set(id.equals(profile.getSelectedVersion()));
    }

    protected Skin<?> createDefaultSkin() {
        return new GameListItemSkin(this);
    }

    public ToggleGroup getToggleGroup() {
        return this.toggleGroup;
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getVersion() {
        return this.version;
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    public void checkSelection() {
        this.selected.set(this.version.equals(this.profile.getSelectedVersion()));
    }

    public void rename() {
        Versions.renameVersion(this.profile, this.version);
    }

    public void duplicate() {
        Versions.duplicateVersion(this.profile, this.version);
    }

    public void remove() {
        Versions.deleteVersion(this.profile, this.version);
    }

    public void export() {
        Versions.exportVersion(this.profile, this.version);
    }

    public void browse() {
        Versions.openFolder(this.profile, this.version);
    }

    public void launch() {
        Versions.testGame(this.profile, this.version);
    }

    public void modifyGameSettings() {
        Versions.modifyGameSettings(this.profile, this.version);
    }

    public void generateLaunchScript() {
        Versions.generateLaunchScript(this.profile, this.version);
    }

    public boolean canUpdate() {
        return this.isModpack;
    }

    public void update() {
        Versions.updateVersion(this.profile, this.version);
    }
}

