/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform.hardware;

import java.util.Locale;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class HardwareVendor {
    public static final HardwareVendor INTEL = new HardwareVendor("Intel");
    public static final HardwareVendor NVIDIA = new HardwareVendor("NVIDIA");
    public static final HardwareVendor AMD = new HardwareVendor("AMD");
    public static final HardwareVendor APPLE = new HardwareVendor("Apple");
    public static final HardwareVendor ARM = new HardwareVendor("ARM");
    public static final HardwareVendor QUALCOMM = new HardwareVendor("Qualcomm");
    public static final HardwareVendor MTK = new HardwareVendor("MTK");
    public static final HardwareVendor VMWARE = new HardwareVendor("VMware");
    public static final HardwareVendor PARALLEL = new HardwareVendor("Parallel");
    public static final HardwareVendor MICROSOFT = new HardwareVendor("Microsoft");
    public static final HardwareVendor MOORE_THREADS = new HardwareVendor("Moore Threads");
    public static final HardwareVendor BROADCOM = new HardwareVendor("Broadcom");
    public static final HardwareVendor IMG = new HardwareVendor("Imagination");
    public static final HardwareVendor LOONGSON = new HardwareVendor("Loongson");
    public static final HardwareVendor JINGJIA_MICRO = new HardwareVendor("Jingjia Micro");
    public static final HardwareVendor HUAWEI = new HardwareVendor("Huawei");
    public static final HardwareVendor ZHAOXIN = new HardwareVendor("Zhaoxin");
    public static final HardwareVendor SAMSUNG = new HardwareVendor("Samsung");
    public static final HardwareVendor MARVELL = new HardwareVendor("Marvell");
    public static final HardwareVendor AMPERE = new HardwareVendor("Ampere");
    public static final HardwareVendor ROCKCHIP = new HardwareVendor("Rockchip");
    public static final HardwareVendor THEAD = new HardwareVendor("T-Head");
    public static final HardwareVendor STARFIVE = new HardwareVendor("StarFive");
    public static final HardwareVendor ESWIN = new HardwareVendor("ESWIN");
    public static final HardwareVendor SPACEMIT = new HardwareVendor("SpacemiT");
    private final String name;

    @Nullable
    public static HardwareVendor getKnown(String name) {
        if (name == null) {
            return null;
        }
        String lower = name.toLowerCase(Locale.ROOT);
        if (lower.startsWith("intel") || lower.startsWith("genuineintel")) {
            return INTEL;
        }
        if (lower.startsWith("nvidia")) {
            return NVIDIA;
        }
        if (lower.startsWith("advanced micro devices") || lower.startsWith("authenticamd") || lower.startsWith("amd") && (lower.length() <= 3 || !Character.isAlphabetic(lower.charAt(3)))) {
            return AMD;
        }
        if (lower.equals("brcm") || lower.startsWith("broadcom")) {
            return BROADCOM;
        }
        if (lower.startsWith("mediatek")) {
            return MTK;
        }
        if (lower.equals("qcom") || lower.startsWith("qualcomm")) {
            return QUALCOMM;
        }
        if (lower.startsWith("apple")) {
            return APPLE;
        }
        if (lower.startsWith("microsoft")) {
            return MICROSOFT;
        }
        if (lower.startsWith("imagination") || lower.equals("img")) {
            return IMG;
        }
        if (lower.startsWith("loongson")) {
            return LOONGSON;
        }
        if (lower.startsWith("moore threads")) {
            return MOORE_THREADS;
        }
        if (lower.startsWith("jingjia")) {
            return JINGJIA_MICRO;
        }
        if (lower.startsWith("huawei") || lower.startsWith("hisilicon")) {
            return HUAWEI;
        }
        if (lower.startsWith("zhaoxin")) {
            return ZHAOXIN;
        }
        if (lower.startsWith("marvell")) {
            return MARVELL;
        }
        if (lower.startsWith("samsung")) {
            return SAMSUNG;
        }
        if (lower.startsWith("ampere")) {
            return AMPERE;
        }
        if (lower.startsWith("rockchip")) {
            return ROCKCHIP;
        }
        if (lower.startsWith("thead") || lower.startsWith("t-head")) {
            return THEAD;
        }
        if (lower.startsWith("starfive")) {
            return STARFIVE;
        }
        if (lower.startsWith("eswin")) {
            return ESWIN;
        }
        if (lower.startsWith("spacemit")) {
            return SPACEMIT;
        }
        return null;
    }

    @Contract(value="null -> null; !null -> !null")
    public static HardwareVendor of(String name) {
        if (name == null) {
            return null;
        }
        HardwareVendor known = HardwareVendor.getKnown(name);
        return known != null ? known : new HardwareVendor(name);
    }

    @Nullable
    public static HardwareVendor ofPciVendorId(int vendorId) {
        switch (vendorId) {
            case 4203: {
                return APPLE;
            }
            case 4098: 
            case 4130: 
            case 6436: 
            case 7640: {
                return AMD;
            }
            case 999: 
            case 32902: 
            case 32903: {
                return INTEL;
            }
            case 2389: 
            case 4318: 
            case 4818: {
                return NVIDIA;
            }
            case 7893: {
                return MOORE_THREADS;
            }
            case 5772: 
            case 20803: {
                return QUALCOMM;
            }
            case 5315: {
                return MTK;
            }
            case 5549: {
                return VMWARE;
            }
            case 6840: {
                return PARALLEL;
            }
            case 5140: {
                return MICROSOFT;
            }
            case 5348: 
            case 6191: {
                return BROADCOM;
            }
            case 20: {
                return LOONGSON;
            }
            case 1841: {
                return JINGJIA_MICRO;
            }
            case 6629: {
                return HUAWEI;
            }
            case 7447: {
                return ZHAOXIN;
            }
        }
        return null;
    }

    @Nullable
    public static HardwareVendor ofArmImplementerId(int implementerId) {
        switch (implementerId) {
            case 65: {
                return ARM;
            }
            case 66: {
                return BROADCOM;
            }
            case 72: {
                return HUAWEI;
            }
            case 78: {
                return NVIDIA;
            }
            case 81: {
                return QUALCOMM;
            }
            case 83: {
                return SAMSUNG;
            }
            case 86: {
                return MARVELL;
            }
            case 97: {
                return APPLE;
            }
            case 105: {
                return INTEL;
            }
            case 109: {
                return MICROSOFT;
            }
            case 192: {
                return AMPERE;
            }
        }
        return null;
    }

    public HardwareVendor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        return o instanceof HardwareVendor && this.name.equals(((HardwareVendor)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

