/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.authlibinjector;

import java.util.Optional;
import java.util.function.Consumer;
import javafx.event.EventHandler;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class AuthlibInjectorDnD {
    private static final String SCHEME = "authlib-injector";
    private static final String PATH_YGGDRASIL_SERVER = "yggdrasil-server";

    private AuthlibInjectorDnD() {
    }

    public static Optional<String> parseUrlFromDragboard(Dragboard dragboard) {
        String uri = dragboard.getString();
        if (uri == null) {
            return Optional.empty();
        }
        String[] uriElements = uri.split(":");
        if (uriElements.length == 3 && SCHEME.equals(uriElements[0]) && PATH_YGGDRASIL_SERVER.equals(uriElements[1])) {
            return Optional.of(NetworkUtils.decodeURL(uriElements[2]));
        }
        return Optional.empty();
    }

    public static EventHandler<DragEvent> dragOverHandler() {
        return event -> AuthlibInjectorDnD.parseUrlFromDragboard(event.getDragboard()).ifPresent(url -> {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            event.consume();
        });
    }

    public static EventHandler<DragEvent> dragDroppedHandler(Consumer<String> onUrlTransfered) {
        return event -> AuthlibInjectorDnD.parseUrlFromDragboard(event.getDragboard()).ifPresent(url -> {
            event.setDropCompleted(true);
            event.consume();
            onUrlTransfered.accept((String)url);
        });
    }
}

