/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.profile;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.RequiredFieldValidator;
import com.jfoenix.validation.base.ValidatorBase;
import java.nio.file.Path;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.FileItem;
import org.jackhuang.hmcl.ui.construct.OptionToggleButton;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class ProfilePage
extends BorderPane
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper();
    private final StringProperty location;
    private final Profile profile;
    private final JFXTextField txtProfileName;
    private final FileItem gameDir;
    private final OptionToggleButton toggleUseRelativePath;

    public ProfilePage(Profile profile) {
        this.getStyleClass().add((Object)"gray-background");
        this.profile = profile;
        String profileDisplayName = Optional.ofNullable(profile).map(Profiles::getProfileDisplayName).orElse("");
        this.state.set((Object)DecoratorPage.State.fromTitle((String)(profile == null ? I18n.i18n("profile.new") : I18n.i18n("profile") + " - " + profileDisplayName)));
        this.location = new SimpleStringProperty((Object)this, "location", Optional.ofNullable(profile).map(Profile::getGameDir).map(FileUtils::getAbsolutePath).orElse(".minecraft"));
        ScrollPane scroll = new ScrollPane();
        this.setCenter((Node)scroll);
        scroll.setFitToHeight(true);
        scroll.setFitToWidth(true);
        VBox rootPane = new VBox();
        rootPane.setStyle("-fx-padding: 20;");
        ComponentList componentList = new ComponentList();
        componentList.setDepth(1);
        BorderPane profileNamePane = new BorderPane();
        Label label = new Label(I18n.i18n("profile.name"));
        profileNamePane.setLeft((Node)label);
        BorderPane.setAlignment((Node)label, (Pos)Pos.CENTER_LEFT);
        this.txtProfileName = new JFXTextField();
        profileNamePane.setRight((Node)this.txtProfileName);
        RequiredFieldValidator validator = new RequiredFieldValidator();
        validator.setMessage(I18n.i18n("input.not_empty"));
        this.txtProfileName.getValidators().add((Object)validator);
        BorderPane.setMargin((Node)this.txtProfileName, (Insets)new Insets(8.0, 0.0, 8.0, 0.0));
        this.txtProfileName.setText(profileDisplayName);
        this.txtProfileName.getValidators().add((Object)new ValidatorBase(){
            {
                this.setMessage(I18n.i18n("profile.already_exists"));
            }

            @Override
            protected void eval() {
                JFXTextField control = (JFXTextField)this.getSrcControl();
                this.hasErrors.set(Profiles.getProfiles().stream().anyMatch(profile -> profile.getName().equals(control.getText())));
            }
        });
        this.gameDir = new FileItem();
        this.gameDir.setName(I18n.i18n("profile.instance_directory"));
        this.gameDir.setTitle(I18n.i18n("profile.instance_directory.choose"));
        this.gameDir.pathProperty().bindBidirectional((Property)this.location);
        this.toggleUseRelativePath = new OptionToggleButton();
        this.toggleUseRelativePath.setTitle(I18n.i18n("profile.use_relative_path"));
        this.gameDir.convertToRelativePathProperty().bind((ObservableValue)this.toggleUseRelativePath.selectedProperty());
        if (profile != null) {
            this.toggleUseRelativePath.setSelected(profile.isUseRelativePath());
        }
        componentList.getContent().setAll((Object[])new Node[]{profileNamePane, this.gameDir, this.toggleUseRelativePath});
        rootPane.getChildren().setAll((Object[])new Node[]{componentList});
        scroll.setContent((Node)rootPane);
        BorderPane savePane = new BorderPane();
        this.setBottom((Node)savePane);
        savePane.setPickOnBounds(false);
        savePane.setStyle("-fx-padding: 20;");
        StackPane.setAlignment((Node)savePane, (Pos)Pos.BOTTOM_RIGHT);
        JFXButton saveButton = FXUtils.newRaisedButton(I18n.i18n("button.save"));
        savePane.setRight((Node)saveButton);
        BorderPane.setAlignment((Node)savePane, (Pos)Pos.BOTTOM_RIGHT);
        StackPane.setAlignment((Node)saveButton, (Pos)Pos.BOTTOM_RIGHT);
        saveButton.setPrefSize(100.0, 40.0);
        saveButton.setOnAction(e -> this.onSave());
        saveButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.txtProfileName.validate() || StringUtils.isBlank(this.getLocation()), (Observable[])new Observable[]{this.txtProfileName.textProperty(), this.location}));
    }

    private void onSave() {
        if (this.profile != null) {
            this.profile.setName(this.txtProfileName.getText());
            this.profile.setUseRelativePath(this.toggleUseRelativePath.isSelected());
            if (StringUtils.isNotBlank(this.getLocation())) {
                this.profile.setGameDir(Path.of(this.getLocation(), new String[0]));
            }
        } else {
            if (StringUtils.isBlank(this.getLocation())) {
                this.gameDir.onExplore();
            }
            Profile newProfile = new Profile(this.txtProfileName.getText(), Path.of(this.getLocation(), new String[0]));
            newProfile.setUseRelativePath(this.toggleUseRelativePath.isSelected());
            Profiles.getProfiles().add((Object)newProfile);
        }
        this.fireEvent(new PageCloseEvent());
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    public String getLocation() {
        return (String)this.location.get();
    }

    public StringProperty locationProperty() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location.set((Object)location);
    }
}

