/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.SerializedName;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ListProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SetProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import org.jackhuang.hmcl.util.TypeUtils;
import org.jackhuang.hmcl.util.gson.RawPreservingProperty;
import org.jackhuang.hmcl.util.javafx.DirtyTracker;
import org.jackhuang.hmcl.util.javafx.ObservableHelper;
import org.jetbrains.annotations.NotNull;

public abstract class ObservableSetting
implements Observable {
    private static final ClassValue<List<? extends ObservableField<?>>> FIELDS = new ClassValue<List<? extends ObservableField<?>>>(){

        @Override
        protected List<? extends ObservableField<?>> computeValue(@NotNull Class<?> type) {
            if (!ObservableSetting.class.isAssignableFrom(type)) {
                throw new AssertionError((Object)("Type: " + String.valueOf(type)));
            }
            try {
                ArrayList allFields = new ArrayList();
                for (Class<?> current = type; current != ObservableSetting.class; current = current.getSuperclass()) {
                    Field[] fields;
                    MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(current, MethodHandles.lookup());
                    for (Field field : fields = current.getDeclaredFields()) {
                        int modifiers = field.getModifiers();
                        if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers)) continue;
                        allFields.add(ObservableField.of(lookup, field));
                    }
                }
                return allFields;
            }
            catch (IllegalAccessException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    };
    protected final transient ObservableHelper helper = new ObservableHelper(this);
    protected final transient Map<String, JsonElement> unknownFields = new HashMap<String, JsonElement>();
    protected final transient DirtyTracker tracker = new DirtyTracker();
    private boolean registered = false;

    protected final void register() {
        if (this.registered) {
            return;
        }
        this.registered = true;
        List<ObservableField<?>> fields = FIELDS.get(this.getClass());
        for (ObservableField<?> field : fields) {
            Observable observable = field.get(this);
            this.tracker.track(observable);
            observable.addListener((InvalidationListener)this.helper);
        }
    }

    public void addListener(InvalidationListener listener) {
        this.helper.addListener(listener);
    }

    public void removeListener(InvalidationListener listener) {
        this.helper.removeListener(listener);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class ObservableField<T> {
        protected final String serializedName;
        protected final List<String> alternateNames;
        protected final VarHandle varHandle;

        public static <T> ObservableField<T> of(MethodHandles.Lookup lookup, Field field) {
            VarHandle varHandle;
            List<String> alternateNames;
            String name;
            SerializedName serializedName = field.getAnnotation(SerializedName.class);
            if (serializedName == null) {
                name = field.getName();
                alternateNames = List.of();
            } else {
                name = serializedName.value();
                alternateNames = List.of(serializedName.alternate());
            }
            try {
                varHandle = lookup.unreflectVarHandle(field);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            if (ObservableList.class.isAssignableFrom(field.getType())) {
                Type listType = TypeUtils.getSupertype(field.getGenericType(), field.getType(), List.class);
                if (!(listType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Cannot resolve the list type of " + field.getName());
                }
                return new CollectionField(name, alternateNames, varHandle, listType, listType);
            }
            if (ObservableSet.class.isAssignableFrom(field.getType())) {
                Type setType = TypeUtils.getSupertype(field.getGenericType(), field.getType(), Set.class);
                if (!(setType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Cannot resolve the set type of " + field.getName());
                }
                ParameterizedType listType = TypeUtils.newParameterizedTypeWithOwner(null, List.class, ((ParameterizedType)setType).getActualTypeArguments()[0]);
                return new CollectionField(name, alternateNames, varHandle, setType, listType);
            }
            if (ObservableMap.class.isAssignableFrom(field.getType())) {
                Type mapType = TypeUtils.getSupertype(field.getGenericType(), field.getType(), Map.class);
                if (!(mapType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Cannot resolve the map type of " + field.getName());
                }
                return new MapField(name, alternateNames, varHandle, mapType);
            }
            if (Property.class.isAssignableFrom(field.getType())) {
                Type propertyType = TypeUtils.getSupertype(field.getGenericType(), field.getType(), Property.class);
                if (!(propertyType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Cannot resolve the element type of " + field.getName());
                }
                Type elementType = ((ParameterizedType)propertyType).getActualTypeArguments()[0];
                return new PropertyField(name, alternateNames, varHandle, elementType);
            }
            throw new IllegalArgumentException("Field " + field.getName() + " is not a property or observable collection");
        }

        private ObservableField(String serializedName, List<String> alternateNames, VarHandle varHandle) {
            this.serializedName = serializedName;
            this.alternateNames = alternateNames;
            this.varHandle = varHandle;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        public List<String> getAlternateNames() {
            return this.alternateNames;
        }

        public Observable get(T value) {
            return this.varHandle.get(value);
        }

        public abstract void serialize(JsonObject var1, T var2, JsonSerializationContext var3);

        public abstract void deserialize(T var1, JsonElement var2, JsonDeserializationContext var3);

        private static final class CollectionField<T>
        extends ObservableField<T> {
            private final Type collectionType;
            private final Type listType;

            CollectionField(String serializedName, List<String> alternate, VarHandle varHandle, Type collectionType, Type listType) {
                super(serializedName, alternate, varHandle);
                this.collectionType = collectionType;
                this.listType = listType;
            }

            @Override
            public void serialize(JsonObject result, T value, JsonSerializationContext context) {
                result.add(this.getSerializedName(), context.serialize(this.get(value), this.collectionType));
            }

            @Override
            public void deserialize(T value, JsonElement element, JsonDeserializationContext context) {
                List deserialized = (List)context.deserialize(element, this.listType);
                Observable fieldValue = this.get(value);
                if (fieldValue instanceof ListProperty) {
                    ((ListProperty)fieldValue).set((Object)FXCollections.observableList((List)deserialized));
                } else if (fieldValue instanceof ObservableList) {
                    ((ObservableList)fieldValue).setAll((Collection)deserialized);
                } else if (fieldValue instanceof SetProperty) {
                    ((SetProperty)fieldValue).set((Object)FXCollections.observableSet(new HashSet(deserialized)));
                } else if (fieldValue instanceof ObservableSet) {
                    ObservableSet set = (ObservableSet)fieldValue;
                    set.clear();
                    set.addAll((Collection)deserialized);
                } else {
                    throw new JsonParseException("Unsupported field type: " + String.valueOf(fieldValue.getClass()));
                }
            }
        }

        private static final class MapField<T>
        extends ObservableField<T> {
            private final Type mapType;

            MapField(String serializedName, List<String> alternate, VarHandle varHandle, Type mapType) {
                super(serializedName, alternate, varHandle);
                this.mapType = mapType;
            }

            @Override
            public void serialize(JsonObject result, T value, JsonSerializationContext context) {
                result.add(this.getSerializedName(), context.serialize(this.get(value), this.mapType));
            }

            @Override
            public void deserialize(T config, JsonElement element, JsonDeserializationContext context) {
                Map deserialized = (Map)context.deserialize(element, this.mapType);
                ObservableMap map = this.varHandle.get(config);
                if (map instanceof MapProperty) {
                    ((MapProperty)map).set((Object)FXCollections.observableMap((Map)deserialized));
                } else {
                    map.clear();
                    map.putAll(deserialized);
                }
            }
        }

        private static final class PropertyField<T>
        extends ObservableField<T> {
            private final Type elementType;

            PropertyField(String serializedName, List<String> alternate, VarHandle varHandle, Type elementType) {
                super(serializedName, alternate, varHandle);
                this.elementType = elementType;
            }

            @Override
            public void serialize(JsonObject result, T value, JsonSerializationContext context) {
                RawPreservingProperty rawPreserving;
                JsonElement rawJson;
                Property property = (Property)this.get(value);
                if (property instanceof RawPreservingProperty && (rawJson = (rawPreserving = (RawPreservingProperty)property).getRawJson()) != null) {
                    result.add(this.getSerializedName(), rawJson);
                    return;
                }
                JsonElement serialized = context.serialize(property.getValue(), this.elementType);
                if (serialized != null && !serialized.isJsonNull()) {
                    result.add(this.getSerializedName(), serialized);
                }
            }

            @Override
            public void deserialize(T value, JsonElement element, JsonDeserializationContext context) {
                Property property = (Property)this.get(value);
                try {
                    property.setValue(context.deserialize(element, this.elementType));
                }
                catch (Throwable e) {
                    if (property instanceof RawPreservingProperty) {
                        ((RawPreservingProperty)property).setRawJson(element);
                    }
                    throw e;
                }
            }
        }
    }

    public static abstract class Adapter<T extends ObservableSetting>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        protected abstract T createInstance();

        @Override
        public JsonElement serialize(T setting, Type typeOfSrc, JsonSerializationContext context) {
            if (setting == null) {
                return JsonNull.INSTANCE;
            }
            List<ObservableField<?>> fields = FIELDS.get(setting.getClass());
            JsonObject result = new JsonObject();
            for (ObservableField<?> field : fields) {
                Observable observable = field.get(setting);
                if (!((ObservableSetting)setting).tracker.isDirty(observable)) continue;
                field.serialize(result, setting, context);
            }
            ((ObservableSetting)setting).unknownFields.forEach(result::add);
            return result;
        }

        @Override
        public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json == null || json.isJsonNull()) {
                return null;
            }
            if (!json.isJsonObject()) {
                throw new JsonParseException("Config is not an object: " + String.valueOf(json));
            }
            T setting = this.createInstance();
            List<ObservableField<?>> fields = FIELDS.get(setting.getClass());
            LinkedHashMap<String, JsonElement> values = new LinkedHashMap<String, JsonElement>(json.getAsJsonObject().asMap());
            for (ObservableField<?> field : fields) {
                JsonElement value = (JsonElement)values.remove(field.getSerializedName());
                if (value == null) {
                    String alternateName;
                    Iterator<String> iterator = field.getAlternateNames().iterator();
                    while (iterator.hasNext() && (value = (JsonElement)values.remove(alternateName = iterator.next())) == null) {
                    }
                }
                if (value == null) continue;
                ((ObservableSetting)setting).tracker.markDirty(field.get(setting));
                field.deserialize(setting, value, context);
            }
            ((ObservableSetting)setting).unknownFields.putAll(values);
            return setting;
        }
    }
}

