# This file is generated by `generate_builtins.jl`. Do not edit by hand.

function getargs(interp::Interpreter, args::Vector{Any}, frame::Frame)
    nargs = length(args)-1  # skip f
    callargs = resize!(frame.framedata.callargs, nargs)
    for i = 1:nargs
        callargs[i] = lookup(interp, frame, args[i+1])
    end
    return callargs
end

const kwinvoke = Core.kwfunc(Core.invoke)

function maybe_recurse_expanded_builtin(interp::Interpreter, frame::Frame, new_expr::Expr)
    f = new_expr.args[1]
    if isa(f, Core.Builtin) || isa(f, Core.IntrinsicFunction)
        return maybe_evaluate_builtin(interp, frame, new_expr, true)
    else
        return new_expr
    end
end

"""
    ret = maybe_evaluate_builtin(interp::Interpreter, frame::Frame, call_expr::Expr, expand::Bool)

If `call_expr` is to a builtin function, evaluate it, returning the result inside a `Some` wrapper.
Otherwise, return `call_expr`.

If `expand` is true, `Core._apply_iterate` calls will be resolved as a call to the applied function.
"""
function maybe_evaluate_builtin(interp::Interpreter, frame::Frame, call_expr::Expr, expand::Bool)
    args = call_expr.args
    nargs = length(args) - 1
    fex = args[1]
    if isa(fex, QuoteNode)
        f = fex.value
    else
        f = lookup(interp, frame, fex)
    end

    if f isa Core.OpaqueClosure
        if expand
            if !Base.uncompressed_ir(f.source).inferred
                return Expr(:call, f, args[2:end]...)
            else
                @debug "not interpreting opaque closure $f since it contains inferred code"
            end
        end
        return Some{Any}(f(args...))
    end
    if !(isa(f, Core.Builtin) || isa(f, Core.IntrinsicFunction))
        return call_expr
    end
    # By having each call appearing statically in the "switch" block below,
    # each gets call-site optimized.
    if f === <:
        if nargs == 2
            return Some{Any}(<:(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        else
            return Some{Any}(<:(getargs(interp, args, frame)...))
        end
    elseif f === ===
        if nargs == 2
            return Some{Any}(===(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        else
            return Some{Any}(===(getargs(interp, args, frame)...))
        end
    elseif f === Core._abstracttype
        return Some{Any}(Core._abstracttype(getargs(interp, args, frame)...))
    elseif f === Core._apply_iterate
        argswrapped = getargs(interp, args, frame)
        if !expand
            return Some{Any}(Core._apply_iterate(argswrapped...))
        end
        aw1 = argswrapped[1]::Function
        @assert aw1 === Core.iterate || aw1 === Core.Compiler.iterate || aw1 === Base.iterate "cannot handle `_apply_iterate` with non iterate as first argument, got $(aw1), $(typeof(aw1))"
        new_expr = Expr(:call, argswrapped[2])
        popfirst!(argswrapped) # pop the iterate
        popfirst!(argswrapped) # pop the function
        argsflat = append_any(argswrapped...)
        for x in argsflat
            push!(new_expr.args, QuoteNode(x))
        end
        return maybe_recurse_expanded_builtin(interp, frame, new_expr)
    elseif f === Core._call_in_world_total
        return Some{Any}(Core._call_in_world_total(getargs(interp, args, frame)...))
    elseif f === Core._compute_sparams
        return Some{Any}(Core._compute_sparams(getargs(interp, args, frame)...))
    elseif @static isdefinedglobal(Core, :_defaultctors) && f === Core._defaultctors
        return Some{Any}(Core._defaultctors(getargs(interp, args, frame)...))
    elseif f === Core._equiv_typedef
        return Some{Any}(Core._equiv_typedef(getargs(interp, args, frame)...))
    elseif f === Core._expr
        return Some{Any}(Core._expr(getargs(interp, args, frame)...))
    elseif @static isdefinedglobal(Core, :_import) && f === Core._import
        return Some{Any}(Core._import(getargs(interp, args, frame)...))
    elseif f === Core._primitivetype
        return Some{Any}(Core._primitivetype(getargs(interp, args, frame)...))
    elseif f === Core._setsuper!
        return Some{Any}(Core._setsuper!(getargs(interp, args, frame)...))
    elseif f === Core._structtype
        return Some{Any}(Core._structtype(getargs(interp, args, frame)...))
    elseif f === Core._svec_ref
        if nargs == 2
            return Some{Any}(Core._svec_ref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        else
            return Some{Any}(Core._svec_ref(getargs(interp, args, frame)...))
        end
    elseif f === Core._typebody!
        return Some{Any}(Core._typebody!(getargs(interp, args, frame)...))
    elseif f === Core._typevar
        if nargs == 3
            return Some{Any}(Core._typevar(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        else
            return Some{Any}(Core._typevar(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :_using) && f === Core._using
        return Some{Any}(Core._using(getargs(interp, args, frame)...))
    elseif f === Core.apply_type
        return Some{Any}(Core.apply_type(getargs(interp, args, frame)...))
    elseif f === Core.compilerbarrier
        if nargs == 2
            return Some{Any}(Core.compilerbarrier(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        else
            return Some{Any}(Core.compilerbarrier(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :current_scope) && f === Core.current_scope
        if nargs == 0
            currscope = Core.current_scope()
            for scope in frame.framedata.current_scopes
                currscope = Scope(currscope, scope.values...)
            end
            return Some{Any}(currscope)
        else
            return Some{Any}(Core.current_scope(getargs(interp, args, frame)...))
        end
    elseif f === Core.donotdelete
        return Some{Any}(Core.donotdelete(getargs(interp, args, frame)...))
    elseif f === Core.finalizer
        if nargs == 2
            return Some{Any}(Core.finalizer(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(Core.finalizer(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Core.finalizer(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        else
            return Some{Any}(Core.finalizer(getargs(interp, args, frame)...))
        end
    elseif f === Core.get_binding_type
        if nargs == 2
            return Some{Any}(Base.invoke_in_world(frame.world, Core.get_binding_type, lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        else
            return Some{Any}(Base.invoke_in_world(frame.world, Core.get_binding_type, getargs(interp, args, frame)...))
        end
    elseif f === Core.ifelse
        if nargs == 3
            return Some{Any}(Core.ifelse(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        else
            return Some{Any}(Core.ifelse(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :invoke_in_world) && f === Core.invoke_in_world
        return Some{Any}(Core.invoke_in_world(getargs(interp, args, frame)...))
    elseif @static isdefinedglobal(Core, :memorynew) && f === Core.memorynew
        if nargs == 2
            return Some{Any}(Core.memorynew(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        else
            return Some{Any}(Core.memorynew(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :memoryref_isassigned) && f === Core.memoryref_isassigned
        if nargs == 3
            return Some{Any}(Core.memoryref_isassigned(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        else
            return Some{Any}(Core.memoryref_isassigned(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :memoryrefget) && f === Core.memoryrefget
        if nargs == 3
            return Some{Any}(Core.memoryrefget(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        else
            return Some{Any}(Core.memoryrefget(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :memoryrefmodify!) && f === Core.memoryrefmodify!
        if nargs == 5
            return Some{Any}(Core.memoryrefmodify!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(Core.memoryrefmodify!(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :memoryrefnew) && f === Core.memoryrefnew
        if nargs == 1
            return Some{Any}(Core.memoryrefnew(lookup(interp, frame, args[2])))
        elseif nargs == 2
            return Some{Any}(Core.memoryrefnew(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(Core.memoryrefnew(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Core.memoryrefnew(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(Core.memoryrefnew(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(Core.memoryrefnew(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :memoryrefoffset) && f === Core.memoryrefoffset
        if nargs == 1
            return Some{Any}(Core.memoryrefoffset(lookup(interp, frame, args[2])))
        else
            return Some{Any}(Core.memoryrefoffset(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :memoryrefreplace!) && f === Core.memoryrefreplace!
        if nargs == 6
            return Some{Any}(Core.memoryrefreplace!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6]), lookup(interp, frame, args[7])))
        else
            return Some{Any}(Core.memoryrefreplace!(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :memoryrefset!) && f === Core.memoryrefset!
        if nargs == 4
            return Some{Any}(Core.memoryrefset!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        else
            return Some{Any}(Core.memoryrefset!(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :memoryrefsetonce!) && f === Core.memoryrefsetonce!
        if nargs == 5
            return Some{Any}(Core.memoryrefsetonce!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(Core.memoryrefsetonce!(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :memoryrefswap!) && f === Core.memoryrefswap!
        if nargs == 4
            return Some{Any}(Core.memoryrefswap!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        else
            return Some{Any}(Core.memoryrefswap!(getargs(interp, args, frame)...))
        end
    elseif f === Core.sizeof
        if nargs == 1
            return Some{Any}(Core.sizeof(lookup(interp, frame, args[2])))
        else
            return Some{Any}(Core.sizeof(getargs(interp, args, frame)...))
        end
    elseif f === Core.svec
        return Some{Any}(Core.svec(getargs(interp, args, frame)...))
    elseif @static isdefinedglobal(Core, :throw_methoderror) && f === Core.throw_methoderror
        return Some{Any}(Core.throw_methoderror(getargs(interp, args, frame)...))
    elseif f === applicable
        return Some{Any}(applicable(getargs(interp, args, frame)...))
    elseif f === fieldtype
        if nargs == 2
            return Some{Any}(fieldtype(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]))::Type)
        elseif nargs == 3
            return Some{Any}(fieldtype(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]))::Type)
        else
            return Some{Any}(fieldtype(getargs(interp, args, frame)...)::Type)
        end
    elseif f === getfield
        if nargs == 2
            return Some{Any}(getfield(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(getfield(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(getfield(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        else
            return Some{Any}(getfield(getargs(interp, args, frame)...))
        end
    elseif f === getglobal
        if nargs == 2
            return Some{Any}(getglobal(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(getglobal(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        else
            return Some{Any}(getglobal(getargs(interp, args, frame)...))
        end
    elseif f === invoke
        if !expand
            argswrapped = getargs(interp, args, frame)
            return Some{Any}(invoke(argswrapped...))
        end
        # This uses the original arguments to avoid looking them up twice
        # See #442
        return Expr(:call, invoke, args[2:end]...)
    elseif @static isdefinedglobal(Core, :invokelatest) && f === Core.invokelatest
        args = getargs(interp, args, frame)
        if !expand
            return Some{Any}(Core.invokelatest(args...))
        end
        new_expr = Expr(:call, args[1])
        popfirst!(args)
        for x in args
            push!(new_expr.args, QuoteNode(x))
        end
        return maybe_recurse_expanded_builtin(interp, frame, new_expr)

    elseif f === isa
        if nargs == 2
            return Some{Any}(isa(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        else
            return Some{Any}(isa(getargs(interp, args, frame)...))
        end
    elseif f === isdefined
        if nargs == 2
            return Some{Any}(isdefined(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(isdefined(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        else
            return Some{Any}(isdefined(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :isdefinedglobal) && f === isdefinedglobal
        return Some{Any}(isdefinedglobal(getargs(interp, args, frame)...))
    elseif f === modifyfield!
        if nargs == 4
            return Some{Any}(modifyfield!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(modifyfield!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(modifyfield!(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :modifyglobal!) && f === modifyglobal!
        if nargs == 4
            return Some{Any}(Base.invoke_in_world(frame.world, modifyglobal!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(Base.invoke_in_world(frame.world, modifyglobal!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(Base.invoke_in_world(frame.world, modifyglobal!, getargs(interp, args, frame)...))
        end
    elseif f === nfields
        if nargs == 1
            return Some{Any}(nfields(lookup(interp, frame, args[2])))
        else
            return Some{Any}(nfields(getargs(interp, args, frame)...))
        end
    elseif f === replacefield!
        if nargs == 4
            return Some{Any}(replacefield!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(replacefield!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        elseif nargs == 6
            return Some{Any}(replacefield!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6]), lookup(interp, frame, args[7])))
        else
            return Some{Any}(replacefield!(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :replaceglobal!) && f === replaceglobal!
        if nargs == 4
            return Some{Any}(Base.invoke_in_world(frame.world, replaceglobal!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(Base.invoke_in_world(frame.world, replaceglobal!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        elseif nargs == 6
            return Some{Any}(Base.invoke_in_world(frame.world, replaceglobal!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6]), lookup(interp, frame, args[7])))
        else
            return Some{Any}(Base.invoke_in_world(frame.world, replaceglobal!, getargs(interp, args, frame)...))
        end
    elseif f === setfield!
        if nargs == 3
            return Some{Any}(setfield!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(setfield!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        else
            return Some{Any}(setfield!(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :setfieldonce!) && f === setfieldonce!
        if nargs == 3
            return Some{Any}(setfieldonce!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(setfieldonce!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(setfieldonce!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(setfieldonce!(getargs(interp, args, frame)...))
        end
    elseif f === setglobal!
        if nargs == 3
            return Some{Any}(Base.invoke_in_world(frame.world, setglobal!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Base.invoke_in_world(frame.world, setglobal!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        else
            return Some{Any}(Base.invoke_in_world(frame.world, setglobal!, getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :setglobalonce!) && f === setglobalonce!
        if nargs == 3
            return Some{Any}(Base.invoke_in_world(frame.world, setglobalonce!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Base.invoke_in_world(frame.world, setglobalonce!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(Base.invoke_in_world(frame.world, setglobalonce!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(Base.invoke_in_world(frame.world, setglobalonce!, getargs(interp, args, frame)...))
        end
    elseif f === swapfield!
        if nargs == 3
            return Some{Any}(swapfield!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(swapfield!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        else
            return Some{Any}(swapfield!(getargs(interp, args, frame)...))
        end
    elseif @static isdefinedglobal(Core, :swapglobal!) && f === swapglobal!
        if nargs == 3
            return Some{Any}(Base.invoke_in_world(frame.world, swapglobal!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Base.invoke_in_world(frame.world, swapglobal!, lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        else
            return Some{Any}(Base.invoke_in_world(frame.world, swapglobal!, getargs(interp, args, frame)...))
        end
    elseif f === throw
        if nargs == 1
            return Some{Any}(throw(lookup(interp, frame, args[2])))
        else
            return Some{Any}(throw(getargs(interp, args, frame)...))
        end
    elseif f === tuple
        return Some{Any}(ntupleany(i::Int->lookup(interp, frame, args[i+1]), length(args)-1))
    elseif f === typeassert
        if nargs == 2
            return Some{Any}(typeassert(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        else
            return Some{Any}(typeassert(getargs(interp, args, frame)...))
        end
    elseif f === typeof
        if nargs == 1
            return Some{Any}(typeof(lookup(interp, frame, args[2])))
        else
            return Some{Any}(typeof(getargs(interp, args, frame)...))
        end
    # Intrinsics
    elseif f === Base.cglobal
        if nargs == 1
            call_expr = copy(call_expr)
            args2 = args[2]
            call_expr.args[2] = isa(args2, QuoteNode) ? args2 : lookup(interp, frame, args2)
            return Some{Any}(Core.eval(moduleof(frame), call_expr))
        elseif nargs == 2
            call_expr = copy(call_expr)
            args2 = args[2]
            call_expr.args[2] = isa(args2, QuoteNode) ? args2 : lookup(interp, frame, args2)
            call_expr.args[3] = lookup(interp, frame, args[3])
            return Some{Any}(Core.eval(moduleof(frame), call_expr))
        end
    elseif @static (isdefinedglobal(Core, :arrayref) && Core.arrayref isa Core.Builtin) && f === Core.arrayref
        if nargs == 1
            return Some{Any}(Core.arrayref(lookup(interp, frame, args[2])))
        elseif nargs == 2
            return Some{Any}(Core.arrayref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(Core.arrayref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Core.arrayref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(Core.arrayref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(Core.arrayref(getargs(interp, args, frame)...))
        end
    elseif @static (isdefinedglobal(Core, :arrayset) && Core.arrayset isa Core.Builtin) && f === Core.arrayset
        if nargs == 1
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2])))
        elseif nargs == 2
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        elseif nargs == 6
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6]), lookup(interp, frame, args[7])))
        else
            return Some{Any}(Core.arrayset(getargs(interp, args, frame)...))
        end
    elseif @static (isdefinedglobal(Core, :arrayset) && Core.arrayset isa Core.Builtin) && f === Core.arrayset
        if nargs == 1
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2])))
        elseif nargs == 2
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        elseif nargs == 6
            return Some{Any}(Core.arrayset(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6]), lookup(interp, frame, args[7])))
        else
            return Some{Any}(Core.arrayset(getargs(interp, args, frame)...))
        end
    elseif @static (isdefinedglobal(Core, :const_arrayref) && Core.const_arrayref isa Core.Builtin) && f === Core.const_arrayref
        if nargs == 1
            return Some{Any}(Core.const_arrayref(lookup(interp, frame, args[2])))
        elseif nargs == 2
            return Some{Any}(Core.const_arrayref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(Core.const_arrayref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Core.const_arrayref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(Core.const_arrayref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(Core.const_arrayref(getargs(interp, args, frame)...))
        end
    elseif @static (isdefinedglobal(Core, :memoryref) && Core.memoryref isa Core.Builtin) && f === Core.memoryref
        if nargs == 1
            return Some{Any}(Core.memoryref(lookup(interp, frame, args[2])))
        elseif nargs == 2
            return Some{Any}(Core.memoryref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(Core.memoryref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        elseif nargs == 4
            return Some{Any}(Core.memoryref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5])))
        elseif nargs == 5
            return Some{Any}(Core.memoryref(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4]), lookup(interp, frame, args[5]), lookup(interp, frame, args[6])))
        else
            return Some{Any}(Core.memoryref(getargs(interp, args, frame)...))
        end
    elseif @static (isdefinedglobal(Core, :set_binding_type!) && Core.set_binding_type! isa Core.Builtin) && f === Core.set_binding_type!
        if nargs == 2
            return Some{Any}(Core.set_binding_type!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3])))
        elseif nargs == 3
            return Some{Any}(Core.set_binding_type!(lookup(interp, frame, args[2]), lookup(interp, frame, args[3]), lookup(interp, frame, args[4])))
        else
            return Some{Any}(Core.set_binding_type!(getargs(interp, args, frame)...))
        end
    elseif @static (isdefinedglobal(Core, :_apply_pure) && Core._apply_pure isa Core.Builtin) && f === Core._apply_pure
        return Some{Any}(Core._apply_pure(getargs(interp, args, frame)...))
    elseif @static (isdefinedglobal(Core, :_call_in_world) && Core._call_in_world isa Core.Builtin) && f === Core._call_in_world
        return Some{Any}(Core._call_in_world(getargs(interp, args, frame)...))
    elseif @static (isdefinedglobal(Core, :_call_latest) && Core._call_latest isa Core.Builtin) && f === Core._call_latest
        args = getargs(interp, args, frame)
        if !expand
            return Some{Any}(Core._call_latest(args...))
        end
        new_expr = Expr(:call, args[1])
        popfirst!(args)
        for x in args
            push!(new_expr.args, QuoteNode(x))
        end
        return maybe_recurse_expanded_builtin(interp, frame, new_expr)

    elseif f === Core.Intrinsics.llvmcall
        return Some{Any}(Core.Intrinsics.llvmcall(getargs(interp, args, frame)...))
    end
    if isa(f, Core.IntrinsicFunction)
        cargs = getargs(interp, args, frame)
        if f === Core.Intrinsics.have_fma && length(cargs) == 1
            cargs1 = cargs[1]
            if cargs1 == Float64
                return Some{Any}(FMA_FLOAT64[])
            elseif cargs1 == Float32
                return Some{Any}(FMA_FLOAT32[])
            elseif cargs1 == Float16
                return Some{Any}(FMA_FLOAT16[])
            end
        end
        if f === Core.Intrinsics.muladd_float && length(cargs) == 3
            a, b, c = cargs
            Ta, Tb, Tc = typeof(a), typeof(b), typeof(c)
            if !(Ta == Tb == Tc)
                error("muladd_float: types of a, b, and c must match")
            end
            if Ta == Float64 && FMA_FLOAT64[]
                f = Core.Intrinsics.fma_float
            elseif Ta == Float32 && FMA_FLOAT32[]
                f = Core.Intrinsics.fma_float
            elseif Ta == Float16 && FMA_FLOAT16[]
                f = Core.Intrinsics.fma_float
            end
        end
        return Some{Any}(ccall(:jl_f_intrinsic_call, Any, (Any, Ptr{Any}, UInt32), f, cargs, length(cargs)))
    end
    if isa(f, typeof(kwinvoke))
        return Some{Any}(kwinvoke(getargs(interp, args, frame)...))
    end
    return call_expr
end
