import { Inferno } from 'inferno';
import { ILinkProps } from './Link';
import type { Location } from 'history';
interface NavLinkProps extends Omit<ILinkProps, 'className'> {
    to: string | Location;
    exact?: boolean;
    strict?: boolean;
    location?: any;
    activeClassName?: string;
    className?: string | ((isActive: boolean) => string);
    activeStyle?: any;
    style?: object | ((isActive: boolean) => string);
    isActive?: (match: any, location: any) => boolean;
    ariaCurrent?: string;
}
/**
 * A <Link> wrapper that knows if it's "active" or not.
 */
export declare function NavLink({ to, exact, strict, onClick, location: linkLocation, activeClassName, className: classNameProp, activeStyle, style: styleProp, isActive: getIsActive, ariaCurrent, ...rest }: NavLinkProps & Omit<Inferno.LinkHTMLAttributes<HTMLLinkElement>, 'className' | 'style'>): any;
export {};
