/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import com.maxmind.db.Buffer;
import com.maxmind.db.MultiBuffer;
import com.maxmind.db.Reader;
import com.maxmind.db.SingleBuffer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

final class BufferHolder {
    private final Buffer buffer;
    private static final int IO_BUFFER_SIZE = 16384;

    BufferHolder(File database, Reader.FileMode mode) throws IOException {
        this(database, mode, 0x7FFFFFF7);
    }

    BufferHolder(File database, Reader.FileMode mode, int chunkSize) throws IOException {
        try (RandomAccessFile file = new RandomAccessFile(database, "r");
             FileChannel channel = file.getChannel();){
            long size = channel.size();
            if (mode == Reader.FileMode.MEMORY) {
                if (size <= (long)chunkSize) {
                    ByteBuffer buffer = ByteBuffer.allocate((int)size);
                    if ((long)channel.read(buffer) != size) {
                        throw new IOException("Unable to read " + database.getName() + " into memory. Unexpected end of stream.");
                    }
                    buffer.flip();
                    this.buffer = new SingleBuffer(buffer);
                } else {
                    ByteBuffer buffer;
                    int read;
                    int fullChunks = (int)(size / (long)chunkSize);
                    int remainder = (int)(size % (long)chunkSize);
                    int totalChunks = fullChunks + (remainder > 0 ? 1 : 0);
                    ByteBuffer[] buffers = new ByteBuffer[totalChunks];
                    for (int i = 0; i < fullChunks; ++i) {
                        buffers[i] = ByteBuffer.allocate(chunkSize);
                    }
                    if (remainder > 0) {
                        buffers[totalChunks - 1] = ByteBuffer.allocate(remainder);
                    }
                    long totalRead = 0L;
                    ByteBuffer[] byteBufferArray = buffers;
                    int n = byteBufferArray.length;
                    for (int i = 0; i < n && (read = channel.read(buffer = byteBufferArray[i])) != -1; ++i) {
                        totalRead += (long)read;
                        buffer.flip();
                    }
                    if (totalRead != size) {
                        throw new IOException("Unable to read " + database.getName() + " into memory. Unexpected end of stream.");
                    }
                    this.buffer = new MultiBuffer(buffers, chunkSize);
                }
            } else {
                this.buffer = size <= (long)chunkSize ? SingleBuffer.mapFromChannel(channel) : MultiBuffer.mapFromChannel(channel);
            }
        }
    }

    BufferHolder(InputStream stream, int chunkSize) throws IOException {
        int read;
        if (null == stream) {
            throw new NullPointerException("Unable to use a NULL InputStream");
        }
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        ByteArrayOutputStream currentChunkStream = new ByteArrayOutputStream();
        byte[] tmp = new byte[16384];
        while (-1 != (read = stream.read(tmp))) {
            int toWrite;
            for (int offset = 0; offset < read; offset += toWrite) {
                int spaceInCurrentChunk = chunkSize - currentChunkStream.size();
                toWrite = Math.min(spaceInCurrentChunk, read - offset);
                currentChunkStream.write(tmp, offset, toWrite);
                if (currentChunkStream.size() != chunkSize) continue;
                chunks.add(currentChunkStream.toByteArray());
                currentChunkStream = new ByteArrayOutputStream();
            }
        }
        if (currentChunkStream.size() > 0) {
            chunks.add(currentChunkStream.toByteArray());
        }
        if (chunks.size() == 1) {
            this.buffer = SingleBuffer.wrap((byte[])chunks.get(0));
        } else {
            ByteBuffer[] buffers = new ByteBuffer[chunks.size()];
            for (int i = 0; i < chunks.size(); ++i) {
                buffers[i] = ByteBuffer.wrap((byte[])chunks.get(i));
            }
            this.buffer = new MultiBuffer(buffers, chunkSize);
        }
    }

    Buffer get() {
        return this.buffer.duplicate();
    }
}

