/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.InstanceFilter;

public class ExceptionTypeFilter
extends InstanceFilter<Class<? extends Throwable>> {
    public ExceptionTypeFilter(@Nullable Collection<Class<? extends Throwable>> includes, @Nullable Collection<Class<? extends Throwable>> excludes) {
        super(includes, excludes);
    }

    public ExceptionTypeFilter(@Nullable Collection<? extends Class<? extends Throwable>> includes, @Nullable Collection<? extends Class<? extends Throwable>> excludes, boolean matchIfEmpty) {
        super(includes, excludes, matchIfEmpty);
    }

    @Override
    public boolean match(Throwable exception) {
        return this.match(exception, false);
    }

    @Override
    public boolean match(Throwable exception, boolean traverseCauses) {
        return traverseCauses ? this.matchTraversingCauses(exception) : this.match(exception.getClass());
    }

    private boolean matchTraversingCauses(Throwable exception) {
        Assert.notNull((Object)exception, "Throwable to match must not be null");
        boolean emptyIncludes = this.includes.isEmpty();
        boolean emptyExcludes = this.excludes.isEmpty();
        if (emptyIncludes && emptyExcludes) {
            return this.matchIfEmpty;
        }
        if (!emptyExcludes && this.matchTraversingCauses(exception, this.excludes)) {
            return false;
        }
        return emptyIncludes || this.matchTraversingCauses(exception, this.includes);
    }

    private boolean matchTraversingCauses(Throwable exception, Collection<? extends Class<? extends Throwable>> candidateTypes) {
        for (Class<? extends Throwable> clazz : candidateTypes) {
            for (Throwable current = exception; current != null; current = current.getCause()) {
                if (!this.match(current.getClass(), clazz)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean match(Class<? extends Throwable> instance, Class<? extends Throwable> candidate) {
        return candidate.isAssignableFrom(instance);
    }
}

