/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.TargetSource;

public abstract class AbstractLazyCreationTargetSource
implements TargetSource {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private @Nullable Object lazyTarget;

    public synchronized boolean isInitialized() {
        return this.lazyTarget != null;
    }

    @Override
    public synchronized @Nullable Class<?> getTargetClass() {
        return this.lazyTarget != null ? this.lazyTarget.getClass() : null;
    }

    @Override
    public synchronized Object getTarget() throws Exception {
        if (this.lazyTarget == null) {
            this.logger.debug((Object)"Initializing lazy target object");
            this.lazyTarget = this.createObject();
        }
        return this.lazyTarget;
    }

    protected abstract Object createObject() throws Exception;
}

