/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.method;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.jspecify.annotations.Nullable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ParameterValidationResult {
    private final MethodParameter methodParameter;
    private final @Nullable Object argument;
    private final List<MessageSourceResolvable> resolvableErrors;
    private final @Nullable Object container;
    private final @Nullable Integer containerIndex;
    private final @Nullable Object containerKey;
    private final BiFunction<MessageSourceResolvable, Class<?>, Object> sourceLookup;

    public ParameterValidationResult(MethodParameter param, @Nullable Object arg, Collection<? extends MessageSourceResolvable> errors, @Nullable Object container, @Nullable Integer index, @Nullable Object key, BiFunction<MessageSourceResolvable, Class<?>, Object> sourceLookup) {
        Assert.notNull((Object)param, (String)"MethodParameter is required");
        Assert.notEmpty(errors, (String)"`resolvableErrors` must not be empty");
        this.methodParameter = param;
        this.argument = arg;
        this.resolvableErrors = List.copyOf(errors);
        this.container = container;
        this.containerIndex = index;
        this.containerKey = key;
        this.sourceLookup = sourceLookup;
    }

    public MethodParameter getMethodParameter() {
        return this.methodParameter;
    }

    public @Nullable Object getArgument() {
        return this.argument;
    }

    public List<MessageSourceResolvable> getResolvableErrors() {
        return this.resolvableErrors;
    }

    public @Nullable Object getContainer() {
        return this.container;
    }

    public @Nullable Integer getContainerIndex() {
        return this.containerIndex;
    }

    public @Nullable Object getContainerKey() {
        return this.containerKey;
    }

    public <T> T unwrap(MessageSourceResolvable error, Class<T> sourceType) {
        return (T)this.sourceLookup.apply(error, sourceType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof ParameterValidationResult)) return false;
        ParameterValidationResult otherResult = (ParameterValidationResult)other;
        if (!this.getMethodParameter().equals((Object)otherResult.getMethodParameter())) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.getArgument(), (Object)otherResult.getArgument())) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.getContainerIndex(), (Object)otherResult.getContainerIndex())) return false;
        if (!ObjectUtils.nullSafeEquals((Object)this.getContainerKey(), (Object)otherResult.getContainerKey())) return false;
        return true;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 29 * hashCode + this.getMethodParameter().hashCode();
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getArgument());
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getContainerIndex());
        hashCode = 29 * hashCode + ObjectUtils.nullSafeHashCode((Object)this.getContainerKey());
        return hashCode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " for " + String.valueOf(this.methodParameter) + ", argument value '" + ObjectUtils.nullSafeConciseToString((Object)this.argument) + "'," + (String)(this.containerIndex != null ? "containerIndex[" + this.containerIndex + "]," : "") + (String)(this.containerKey != null ? "containerKey['" + String.valueOf(this.containerKey) + "']," : "") + " errors: " + String.valueOf(this.getResolvableErrors());
    }
}

