/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.automation.unit;

import com.unciv.UncivGame;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.automation.Automation;
import com.unciv.logic.automation.unit.AirUnitAutomation;
import com.unciv.logic.automation.unit.BattleHelper;
import com.unciv.logic.automation.unit.CivilianUnitAutomation;
import com.unciv.logic.automation.unit.HeadTowardsEnemyCityAutomation;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.BattleDamage;
import com.unciv.logic.battle.CityCombatant;
import com.unciv.logic.battle.ICombatant;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.MapUnitAction;
import com.unciv.logic.civilization.Notification;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticStatus;
import com.unciv.logic.civilization.managers.ThreatManager;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitUpgradeManager;
import com.unciv.logic.map.mapunit.movement.PathsToTilesWithinTurn;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.UnitAction;
import com.unciv.models.UpgradeUnitAction;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.unit.AutoPlay;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsPillage;
import com.unciv.ui.screens.worldscreen.unit.actions.UnitActionsUpgrade;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0003J\u0015\u0010\u0011\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0012J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J(\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\r2\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0019J\u0015\u0010\u001a\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u001bJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010#\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00052\b\b\u0002\u0010%\u001a\u00020\u0005H\u0003J \u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u000f0'j\b\u0012\u0004\u0012\u00020\u000f`(2\u0006\u0010\n\u001a\u00020\u000bH\u0003J\u0018\u0010)\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010*\u001a\u00020\rJ\u0010\u0010+\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010,\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010-\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010.\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010/\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u00100\u001a\u00020\r2\u0006\u00101\u001a\u000202J\u0012\u00103\u001a\u0004\u0018\u0001042\u0006\u00101\u001a\u000202H\u0003J\u0010\u00105\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u00106\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u00107\u001a\u00020\r2\u0006\u00101\u001a\u000202H\u0003J\u000e\u00108\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/unciv/logic/automation/unit/UnitAutomation;", "", "<init>", "()V", "CLOSE_ENEMY_TILES_AWAY_LIMIT", "", "CLOSE_ENEMY_TURNS_AWAY_LIMIT", "", "automateUnitMoves", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "isGoodTileToExplore", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "unitVisibilityRange", "tryExplore", "tryExplore$core", "tryGoToRuin", "tryFogBust", "isGoodTileForFogBusting", "wander", "stayInTerritory", "tilesToAvoid", "", "tryUpgradeUnit", "tryUpgradeUnit$core", "getUnitsToUpgradeTo", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/unit/BaseUnit;", "tryAttacking", "tryHeadTowardsEncampment", "tryRetreat", "tryHealUnit", "canUnitHealInTurnsOnCurrentTile", "turns", "noEnemyDistance", "getDangerousTiles", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "tryPillageImprovement", "onlyPillageToHeal", "tryAdvanceTowardsCloseEnemy", "tryPrepare", "tryAccompanySettlerOrGreatPerson", "tryHeadTowardsOurSiegedCity", "tryEnterOwnClosestCity", "tryBombardEnemy", "city", "Lcom/unciv/logic/city/City;", "chooseBombardTarget", "Lcom/unciv/logic/battle/ICombatant;", "tryTakeBackCapturedCity", "tryGarrisoningLandUnit", "isCityThatNeedsDefendingInWartime", "automatedExplore", "core"})
@SourceDebugExtension(value={"SMAP\nUnitAutomation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnitAutomation.kt\ncom/unciv/logic/automation/unit/UnitAutomation\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,673:1\n1#2:674\n1255#3,2:675\n1255#3,2:677\n1276#3,3:687\n1232#3,2:700\n1232#3,2:705\n1255#3,2:707\n1891#3,14:709\n183#3,2:726\n608#3:728\n183#3,2:729\n608#3:745\n622#3:746\n608#3:767\n183#3,2:768\n608#3:848\n183#3,2:849\n183#3,2:851\n1255#3,2:853\n608#3:855\n183#3,2:856\n608#3:858\n183#3,2:859\n1463#3,14:861\n608#3:875\n183#3,2:876\n608#3:881\n183#3,2:882\n1255#3,2:897\n774#4:679\n865#4,2:680\n1969#4,5:682\n1975#4,8:690\n295#4,2:698\n774#4:702\n865#4,2:703\n1761#4,3:723\n2423#4,14:731\n774#4:747\n865#4,2:748\n1491#4:750\n1516#4,3:751\n1519#4,3:761\n1740#4,3:764\n774#4:770\n865#4,2:771\n2423#4,14:773\n1999#4,14:787\n774#4:808\n865#4,2:809\n1999#4,14:811\n827#4:825\n855#4,2:826\n774#4:828\n865#4,2:829\n774#4:831\n865#4,2:832\n2423#4,14:834\n774#4:878\n865#4,2:879\n774#4:884\n865#4,2:885\n1563#4:887\n1634#4,3:888\n1374#4:891\n1460#4,5:892\n382#5,7:754\n536#5:801\n521#5,6:802\n*S KotlinDebug\n*F\n+ 1 UnitAutomation.kt\ncom/unciv/logic/automation/unit/UnitAutomation\n*L\n124#1:675,2\n125#1:677,2\n140#1:687,3\n175#1:700,2\n199#1:705,2\n201#1:707,2\n227#1:709,14\n236#1:726,2\n281#1:728\n282#1:729,2\n302#1:745\n307#1:746\n374#1:767\n375#1:768,2\n515#1:848\n521#1:849,2\n531#1:851,2\n550#1:853,2\n555#1:855\n556#1:856,2\n569#1:858\n570#1:859,2\n591#1:861,14\n610#1:875\n611#1:876,2\n645#1:881\n646#1:882,2\n254#1:897,2\n137#1:679\n137#1:680,2\n140#1:682,5\n140#1:690,8\n161#1:698,2\n180#1:702\n180#1:703,2\n229#1:723,3\n297#1:731,14\n367#1:747\n367#1:748,2\n368#1:750\n368#1:751,3\n368#1:761,3\n370#1:764,3\n387#1:770\n387#1:771,2\n388#1:773,14\n399#1:787,14\n450#1:808\n450#1:809,2\n455#1:811,14\n478#1:825\n478#1:826,2\n479#1:828\n479#1:829,2\n480#1:831\n480#1:832,2\n483#1:834,14\n626#1:878\n626#1:879,2\n655#1:884\n655#1:885,2\n656#1:887\n656#1:888,3\n656#1:891\n656#1:892,5\n368#1:754,7\n449#1:801\n449#1:802,6\n*E\n"})
public final class UnitAutomation {
    @NotNull
    public static final UnitAutomation INSTANCE = new UnitAutomation();
    private static final int CLOSE_ENEMY_TILES_AWAY_LIMIT = 5;
    private static final float CLOSE_ENEMY_TURNS_AWAY_LIMIT = 3.0f;

    private UnitAutomation() {
    }

    public final void automateUnitMoves(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (!(!unit.getCiv().isBarbarian())) {
            boolean bl = false;
            String string = "Barbarians is not allowed here.";
            throw new IllegalStateException(string.toString());
        }
        if (MapUnit.getDamageFromTerrain$default(unit, null, 1, null) > 0 && this.tryHealUnit(unit)) {
            return;
        }
        if (unit.isCivilian()) {
            CivilianUnitAutomation.INSTANCE.automateCivilianUnit(unit, this.getDangerousTiles(unit));
            return;
        }
        if (unit.getCiv().isHuman() && this.tryUpgradeUnit$core(unit)) {
            return;
        }
        if ((MapUnit.hasUnique$default(unit, UniqueType.BuildImprovements, null, false, 6, null) || MapUnit.hasUnique$default(unit, UniqueType.FoundCity, null, false, 6, null) || MapUnit.hasUnique$default(unit, UniqueType.FoundPuppetCity, null, false, 6, null) || MapUnit.hasUnique$default(unit, UniqueType.ReligiousUnit, null, false, 6, null) || MapUnit.hasUnique$default(unit, UniqueType.CreateWaterImprovements, null, false, 6, null)) && !unit.getCiv().isAtWar()) {
            CivilianUnitAutomation.INSTANCE.automateCivilianUnit(unit, this.getDangerousTiles(unit));
            return;
        }
        if (unit.isNuclearWeapon()) {
            AirUnitAutomation.INSTANCE.automateNukes(unit);
            return;
        }
        if (unit.getBaseUnit().isAirUnit()) {
            if (unit.canIntercept()) {
                AirUnitAutomation.INSTANCE.automateFighter(unit);
                return;
            }
            if (MapUnit.hasUnique$default(unit, UniqueType.SelfDestructs, null, false, 6, null)) {
                AirUnitAutomation.INSTANCE.automateMissile(unit);
                return;
            }
            AirUnitAutomation.INSTANCE.automateBomber(unit);
            return;
        }
        if (this.tryAccompanySettlerOrGreatPerson(unit)) {
            return;
        }
        if (this.tryGoToRuin(unit) && !unit.hasMovement()) {
            return;
        }
        if (unit.getHealth() < 50 && (this.tryRetreat(unit) || this.tryHealUnit(unit))) {
            return;
        }
        if (unit.getHealth() < 100 && this.canUnitHealInTurnsOnCurrentTile(unit, 2, 3)) {
            return;
        }
        if (this.tryHeadTowardsOurSiegedCity(unit)) {
            return;
        }
        if (BattleHelper.INSTANCE.tryDisembarkUnitToAttackPosition(unit)) {
            return;
        }
        if (this.tryAttacking(unit)) {
            return;
        }
        if (this.tryTakeBackCapturedCity(unit)) {
            return;
        }
        if (HeadTowardsEnemyCityAutomation.INSTANCE.tryHeadTowardsEnemyCity(unit)) {
            return;
        }
        if (this.tryHeadTowardsEncampment(unit)) {
            return;
        }
        if (this.tryGarrisoningLandUnit(unit)) {
            return;
        }
        if (unit.getHealth() < 80 && this.tryHealUnit(unit)) {
            return;
        }
        if (this.tryAdvanceTowardsCloseEnemy(unit)) {
            return;
        }
        if (unit.getHealth() < 100 && this.tryHealUnit(unit)) {
            return;
        }
        if (this.tryPrepare(unit)) {
            return;
        }
        if (this.tryExplore$core(unit)) {
            return;
        }
        if (this.tryFogBust(unit)) {
            return;
        }
        if (unit.getCiv().isCityState()) {
            UnitAutomation.wander$default(this, unit, true, null, 4, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean isGoodTileToExplore(MapUnit unit, Tile tile, int unitVisibilityRange) {
        Tile element$iv;
        Tile it;
        if (tile.getOwner() != null) {
            Civilization civilization = tile.getOwner();
            Intrinsics.checkNotNull(civilization);
            if (civilization.isCityState()) return false;
        }
        Sequence<Tile> $this$any$iv = tile.getTilesInDistance(unitVisibilityRange);
        boolean $i$f$any = false;
        Iterator<Tile> iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            it = element$iv = iterator2.next();
            boolean bl = false;
        } while (!(!unit.getCiv().hasExplored(it)));
        boolean bl = true;
        if (!bl) return false;
        if (unit.getCiv().isCityState()) {
            $this$any$iv = tile.getNeighbors();
            $i$f$any = false;
            iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                it = element$iv = iterator2.next();
                boolean bl2 = false;
            } while (!Intrinsics.areEqual(it.getOwner(), unit.getCiv()));
            boolean bl3 = true;
            if (!bl3) return false;
        }
        if (unit.getDamageFromTerrain(tile) > 0) return false;
        if (ThreatManager.getDistanceToClosestEnemyUnit$default(unit.getCiv().getThreatManager(), tile, 3, false, 4, null) <= 3) return false;
        if (!UnitMovement.canMoveTo$default(unit.getMovement(), tile, false, false, false, 14, null)) return false;
        if (!unit.getMovement().canReach(tile)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryExplore$core(@NotNull MapUnit unit) {
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (this.tryGoToRuin(unit) && (!unit.hasMovement() || unit.isDestroyed())) {
            return true;
        }
        int unitVisibilityRange = unit.getVisibilityRange();
        Set<Tile> set = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null).keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(it);
            if (!INSTANCE.isGoodTileToExplore(unit, it, unitVisibilityRange)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List explorableTilesThisTurn = (List)destination$iv$iv;
        if (CollectionsKt.any(explorableTilesThisTurn)) {
            Object t;
            void $this$maxBy$iv;
            $this$filterTo$iv$iv = explorableTilesThisTurn;
            boolean $i$f$maxByOrThrow = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = maxElem$iv;
            } else {
                void $this$count$iv;
                Tile it = (Tile)maxElem$iv;
                boolean bl = false;
                Sequence<Tile> bl2 = it.getTilesAtDistance(unit.getVisibilityRange());
                int n = it.getTileHeight();
                boolean $i$f$count2 = false;
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    Tile tile = (Tile)element$iv;
                    boolean bl3 = false;
                    if (!(!tile.isExplored(unit.getCiv())) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                int n2 = count$iv;
                int maxValue$iv = n + n2;
                do {
                    void $this$count$iv2;
                    Object e$iv = iterator$iv.next();
                    Tile it2 = (Tile)e$iv;
                    $i$a$-maxByOrThrow-UnitAutomation$tryExplore$bestTile$1 = false;
                    Sequence<Tile> $i$f$count2 = it2.getTilesAtDistance(unit.getVisibilityRange());
                    int n3 = it2.getTileHeight();
                    boolean $i$f$count3 = false;
                    int count$iv2 = 0;
                    for (Object element$iv : $this$count$iv2) {
                        Tile tile = (Tile)element$iv;
                        boolean bl4 = false;
                        if (!(!tile.isExplored(unit.getCiv())) || ++count$iv2 >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    int n4 = count$iv2;
                    int v$iv = n3 + n4;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = maxElem$iv;
            }
            Intrinsics.checkNotNullExpressionValue(t, "maxBy(...)");
            Tile bestTile = (Tile)t;
            unit.getMovement().headTowards(bestTile);
            return true;
        }
        Iterator<Tile> iterator2 = unit.getCurrentTile().getTilesInDistance(5).iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            if (!this.isGoodTileToExplore(unit, tile, unitVisibilityRange)) continue;
            unit.getMovement().headTowards(tile);
            return true;
        }
        return false;
    }

    private final boolean tryGoToRuin(MapUnit unit) {
        Object v2;
        block3: {
            if (!unit.getCiv().isMajorCiv()) {
                return false;
            }
            Iterable $this$firstOrNull$iv = unit.getViewableTiles();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                TileImprovement tileImprovement = it.getTileImprovement();
                boolean bl2 = tileImprovement != null ? tileImprovement.isAncientRuinsEquivalent(unit.getCache().getState()) : false;
                if (!(bl2 && UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null) && unit.getMovement().canReach(it))) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        Tile tile = v2;
        if (tile == null) {
            return false;
        }
        Tile tileWithRuin = tile;
        unit.getMovement().headTowards(tileWithRuin);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryFogBust(MapUnit unit) {
        void $this$filterTo$iv$iv;
        boolean bl;
        Object element$iv;
        block6: {
            if (!Automation.INSTANCE.afraidOfBarbarians(unit.getCiv())) {
                return false;
            }
            Sequence<Tile> $this$all$iv = unit.getCurrentTile().getTilesInDistance(5);
            boolean $i$f$all = false;
            Iterator<Tile> iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                Tile it = element$iv;
                boolean bl2 = false;
                if (it.isVisible(unit.getCiv())) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (bl) {
            return false;
        }
        Set<Tile> set = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null).keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        element$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Tile it = (Tile)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull(it);
            if (!INSTANCE.isGoodTileForFogBusting(unit, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List reachableTilesThisTurn = (List)destination$iv$iv;
        if (CollectionsKt.any(reachableTilesThisTurn)) {
            UnitMovement unitMovement = unit.getMovement();
            Object t = CollectionsKt.random(reachableTilesThisTurn, Random.Default);
            Intrinsics.checkNotNullExpressionValue(t, "random(...)");
            unitMovement.headTowards((Tile)t);
            return true;
        }
        Iterator<Tile> iterator3 = unit.getCurrentTile().getTilesInDistance(5).iterator();
        while (iterator3.hasNext()) {
            Tile tile = iterator3.next();
            if (!this.isGoodTileForFogBusting(unit, tile)) continue;
            unit.getMovement().headTowards(tile);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Readonly
    private final boolean isGoodTileForFogBusting(MapUnit unit, Tile tile) {
        Tile it;
        Tile element$iv;
        if (!UnitMovement.canMoveTo$default(unit.getMovement(), tile, false, false, false, 14, null)) return false;
        if (tile.getOwner() != null) return false;
        Sequence<Tile> $this$all$iv = tile.getNeighbors();
        boolean $i$f$all = false;
        Iterator<Tile> iterator2 = $this$all$iv.iterator();
        while (iterator2.hasNext()) {
            it = element$iv = iterator2.next();
            boolean bl = false;
            if (it.getOwner() != null) return false;
            boolean bl2 = true;
            if (bl2) continue;
            return false;
        }
        boolean bl = true;
        if (!bl) return false;
        if (!unit.getCiv().hasExplored(tile)) return false;
        Sequence<Tile> $this$any$iv = tile.getTilesInDistance(2);
        boolean $i$f$any = false;
        iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            it = element$iv = iterator2.next();
            boolean bl3 = false;
        } while (!Intrinsics.areEqual(it.getOwner(), unit.getCiv()));
        boolean bl4 = true;
        if (!bl4) return false;
        if (unit.getDamageFromTerrain(tile) > 0) return false;
        if (!unit.getMovement().canReach(tile)) return false;
        return true;
    }

    public final void wander(@NotNull MapUnit unit, boolean stayInTerritory, @NotNull Set<Tile> tilesToAvoid) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(tilesToAvoid, "tilesToAvoid");
        Sequence<Tile> unitDistanceToTiles = unit.getCurrentTile().getTilesAtDistance(1);
        Sequence<Tile> reachableTiles = SequencesKt.filter(unitDistanceToTiles, arg_0 -> UnitAutomation.wander$lambda$0(tilesToAvoid, unit, stayInTerritory, arg_0));
        if (SequencesKt.any(reachableTiles)) {
            UnitMovement.moveToTile$default(unit.getMovement(), (Tile)CollectionsKt.random((Collection)SequencesKt.toList(reachableTiles), Random.Default), false, 2, null);
        }
    }

    public static /* synthetic */ void wander$default(UnitAutomation unitAutomation, MapUnit mapUnit, boolean bl, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        unitAutomation.wander(mapUnit, bl, set);
    }

    public final boolean tryUpgradeUnit$core(@NotNull MapUnit unit) {
        Object object;
        UnitAction unitAction;
        block14: {
            Sequence<UnitAction> upgradeActions;
            boolean bl;
            BaseUnit upgradedUnit;
            block13: {
                BaseUnit baseUnit;
                Sequence<BaseUnit> upgradeUnits;
                Intrinsics.checkNotNullParameter(unit, "unit");
                if (unit.getCiv().isHuman() && !UncivGame.Companion.getCurrent().getSettings().getAutomatedUnitsCanUpgrade()) {
                    Object object2 = UncivGame.Companion.getCurrent().getWorldScreen();
                    boolean bl2 = object2 != null && (object2 = ((WorldScreen)object2).getAutoPlay()) != null ? !((AutoPlay)object2).isAutoPlayingAndFullAutoPlayAI() : false;
                    if (bl2) {
                        return false;
                    }
                }
                if (SequencesKt.none(upgradeUnits = this.getUnitsToUpgradeTo(unit))) {
                    return false;
                }
                Sequence<BaseUnit> $this$minBy$iv = upgradeUnits;
                boolean $i$f$minByOrThrow = false;
                Iterator<BaseUnit> iterator$iv = $this$minBy$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new NoSuchElementException();
                }
                BaseUnit minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    baseUnit = minElem$iv;
                } else {
                    BaseUnit it = minElem$iv;
                    boolean bl3 = false;
                    int minValue$iv = it.getCost();
                    do {
                        BaseUnit e$iv;
                        BaseUnit it2 = e$iv = iterator$iv.next();
                        $i$a$-minByOrThrow-UnitAutomation$tryUpgradeUnit$upgradedUnit$1 = false;
                        int v$iv = it2.getCost();
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    baseUnit = minElem$iv;
                }
                upgradedUnit = baseUnit;
                Set<String> set = upgradedUnit.getResourceRequirementsPerTurn(unit.getCache().getState()).keySet();
                Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
                Iterable $this$any$iv = set;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (BaseUnit element$iv : $this$any$iv) {
                        String it = (String)((Object)element$iv);
                        boolean bl4 = false;
                        Intrinsics.checkNotNull(it);
                        if (!(!unit.requiresResource(it))) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl && !Automation.allowSpendingResource$default(Automation.INSTANCE, unit.getCiv(), upgradedUnit, null, 4, null)) {
                return false;
            }
            Sequence<UnitAction> $this$firstOrNull$iv = upgradeActions = UnitActionsUpgrade.INSTANCE.getUpgradeActions(unit);
            boolean $i$f$firstOrNull = false;
            Iterator<UnitAction> iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                UnitAction element$iv;
                UnitAction it = element$iv = iterator2.next();
                boolean bl5 = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type com.unciv.models.UpgradeUnitAction");
                if (!Intrinsics.areEqual(((UpgradeUnitAction)it).getUnitToUpgradeTo(), upgradedUnit)) continue;
                unitAction = element$iv;
                break block14;
            }
            unitAction = null;
        }
        if ((object = (UnitAction)unitAction) == null || (object = ((UnitAction)object).getAction()) == null) {
            return false;
        }
        object.invoke();
        return unit.isDestroyed();
    }

    @Readonly
    private final Sequence<BaseUnit> getUnitsToUpgradeTo(MapUnit unit) {
        return SequencesKt.filter(SequencesKt.map(unit.getBaseUnit().getRulesetUpgradeUnits(unit.getCache().getState()), arg_0 -> UnitAutomation.getUnitsToUpgradeTo$lambda$1(unit, arg_0)), arg_0 -> UnitAutomation.getUnitsToUpgradeTo$lambda$2(unit, arg_0));
    }

    private final boolean tryAttacking(MapUnit unit) {
        int n = unit.maxAttacksPerTurn() - unit.getAttacksThisTurn();
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            if (BattleHelper.tryAttackNearbyEnemy$default(BattleHelper.INSTANCE, unit, false, 2, null)) {
                return true;
            }
            if (unit.getHealth() >= 50 || !INSTANCE.tryRetreat(unit)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryHeadTowardsEncampment(MapUnit unit) {
        Object v0;
        block3: {
            void $this$sortedBy$iv;
            Sequence encampmentsCloseToCities;
            Sequence<Tile> knownEncampments;
            if (MapUnit.hasUnique$default(unit, UniqueType.SelfDestructs, null, false, 6, null)) {
                return false;
            }
            List<City> cities = unit.getCiv().getCities();
            Sequence<Tile> sequence = knownEncampments = SequencesKt.distinct(SequencesKt.filter(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)cities), UnitAutomation::tryHeadTowardsEncampment$lambda$0), arg_0 -> UnitAutomation.tryHeadTowardsEncampment$lambda$1(unit, arg_0)));
            boolean $i$f$sortedBy = false;
            Sequence $this$firstOrNull$iv = encampmentsCloseToCities = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Tile tile = v0;
        if (tile == null) {
            return false;
        }
        Tile encampmentToHeadTowards = tile;
        unit.getMovement().headTowards(encampmentToHeadTowards);
        return true;
    }

    private final boolean tryRetreat(MapUnit unit) {
        Sequence<Tile> sequence;
        Object closestCity;
        Object object;
        Object v0;
        if (unit.isCivilian()) {
            return false;
        }
        if (unit.getBaseUnit().isAirUnit()) {
            return false;
        }
        if (unit.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(unit.getTile(), 4, true) > 3) {
            return false;
        }
        PathsToTilesWithinTurn unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
        Object $this$minByOrNull$iv = unit.getCiv().getCities();
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                City it = (City)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getCenterTile().aerialDistanceTo(unit.getTile());
                do {
                    Object e$iv = iterator$iv.next();
                    City it2 = (City)e$iv;
                    $i$a$-minByOrNull-UnitAutomation$tryRetreat$closestCity$1 = false;
                    int v$iv = it2.getCenterTile().aerialDistanceTo(unit.getTile());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        City city = v0;
        if (city != null) {
            Object it = $this$minByOrNull$iv = city;
            boolean bl = false;
            object = ((City)it).getCenterTile().aerialDistanceTo(unit.getTile()) < 20 ? $this$minByOrNull$iv : null;
        } else {
            object = closestCity = null;
        }
        if (closestCity != null) {
            Sequence<Tile> $this$sortedBy$iv = SequencesKt.map(MapsKt.asSequence(unitDistanceToTiles), UnitAutomation::tryRetreat$lambda$2);
            boolean $i$f$sortedBy = false;
            sequence = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator((City)closestCity){
                final /* synthetic */ City $closestCity$inlined;
                {
                    this.$closestCity$inlined = city;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$closestCity$inlined.getCenterTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$closestCity$inlined.getCenterTile()));
                }
            });
        } else {
            Sequence<Tile> $this$sortedByDescending$iv = SequencesKt.map(MapsKt.asSequence(unitDistanceToTiles), UnitAutomation::tryRetreat$lambda$4);
            boolean $i$f$sortedByDescending = false;
            sequence = SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(this.$unit$inlined.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(it, 3, false));
                    it = (Tile)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, this.$unit$inlined.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(it, 3, false));
                }
            });
        }
        Sequence<Tile> sortedTilesToRetreatTo = sequence;
        int ourDistanceToClosestEnemy = unit.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(unit.getTile(), 4, false);
        Iterator<Tile> iterator2 = sortedTilesToRetreatTo.iterator();
        while (iterator2.hasNext()) {
            int range;
            Tile retreatTile = iterator2.next();
            int tileDistanceToClosestEnemy = unit.getCiv().getThreatManager().getDistanceToClosestEnemyUnit(retreatTile, 4, false);
            if (ourDistanceToClosestEnemy >= tileDistanceToClosestEnemy) continue;
            MapUnit otherUnit = retreatTile.getMilitaryUnit();
            if (otherUnit == null) {
                if (!UnitMovement.canMoveTo$default(unit.getMovement(), retreatTile, false, false, false, 14, null)) continue;
                UnitMovement.moveToTile$default(unit.getMovement(), retreatTile, false, 2, null);
                return true;
            }
            if (!Intrinsics.areEqual(otherUnit.getCiv(), unit.getCiv()) || otherUnit.getHealth() <= 80 || otherUnit.getBaseUnit().isRanged() && ourDistanceToClosestEnemy < (range = otherUnit.getBaseUnit().getRange()) || !unit.getMovement().canUnitSwapTo(retreatTile)) continue;
            unit.getMovement().headTowards(retreatTile);
            if (SequencesKt.contains(unit.getCurrentTile().getNeighbors(), otherUnit.getCurrentTile()) && unit.getMovement().canUnitSwapTo(retreatTile)) {
                UnitMovement.swapMoveToTile$default(unit.getMovement(), retreatTile, false, 2, null);
            }
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean tryHealUnit(MapUnit unit) {
        block41: {
            if (unit.getBaseUnit().isRanged() && MapUnit.hasUnique$default(unit, UniqueType.HealsEvenAfterAction, null, false, 6, null)) {
                return false;
            }
            while (this.tryPillageImprovement(unit, false)) {
                if (unit.hasMovement() && unit.getHealth() != 100) continue;
                return unit.hasMovement() == false;
            }
            unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
            if (unitDistanceToTiles.isEmpty()) {
                return true;
            }
            dangerousTiles = unit.getCiv().getThreatManager().getDangerousTiles(unit, 3);
            if (!dangerousTiles.contains(unit.getCurrentTile()) && UnitAutomation.canUnitHealInTurnsOnCurrentTile$default(this, unit, 3, 0, 4, null)) {
                return true;
            }
            currentUnitTile = unit.getTile();
            v0 = unitDistanceToTiles.keySet();
            Intrinsics.checkNotNullExpressionValue(v0, "<get-keys>(...)");
            var6_5 = v0;
            $i$f$filter = false;
            var8_8 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-UnitAutomation$tryHealUnit$viableTilesForHealing$1 = false;
                if (dangerousTiles.contains(it)) ** GOTO lbl-1000
                v1 = unit.getMovement();
                Intrinsics.checkNotNull(it);
                if (UnitMovement.canMoveTo$default(v1, it, false, false, false, 14, null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            viableTilesForHealing = (List)destination$iv$iv;
            $this$groupBy$iv = viableTilesForHealing;
            $i$f$groupBy = false;
            destination$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$groupByTo = false;
            element$iv$iv = $this$groupByTo$iv$iv.iterator();
            while (element$iv$iv.hasNext()) {
                element$iv$iv = element$iv$iv.next();
                it = (Tile)element$iv$iv;
                $i$a$-groupBy-UnitAutomation$tryHealUnit$tilesByHealingRate$1 = false;
                Intrinsics.checkNotNull(it);
                key$iv$iv = unit.rankTileForHealing(it);
                var17_55 = destination$iv$iv;
                key$iv$iv$iv = key$iv$iv;
                $i$f$getOrPut = false;
                value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                    answer$iv$iv$iv = new ArrayList<E>();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    v3 /* !! */  = answer$iv$iv$iv;
                } else {
                    v3 /* !! */  = value$iv$iv$iv;
                }
                list$iv$iv = (List)v3 /* !! */ ;
                list$iv$iv.add(element$iv$iv);
            }
            tilesByHealingRate = destination$iv$iv;
            $this$all$iv = tilesByHealingRate.keySet();
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v4 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = ((Number)element$iv).intValue();
                    $i$a$-all-UnitAutomation$tryHealUnit$1 = false;
                    if (it == 0) continue;
                    v4 = false;
                    break block41;
                }
                v4 = true;
            }
        }
        if (v4) {
            if (!unit.getBaseUnit().getMovesLikeAirUnits()) {
                block42: {
                    $i$f$all = SequencesKt.map(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), (Function1<City, Tile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, tryHealUnit$lambda$3(com.unciv.logic.city.City ), (Lcom/unciv/logic/city/City;)Lcom/unciv/logic/map/tile/Tile;)());
                    $i$f$sortedBy = false;
                    $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                        final /* synthetic */ MapUnit $unit$inlined;
                        {
                            this.$unit$inlined = mapUnit;
                        }

                        public final int compare(T a, T b) {
                            Tile it = (Tile)a;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                            it = (Tile)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                        }
                    });
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = (Tile)element$iv;
                        $i$a$-firstOrNull-UnitAutomation$tryHealUnit$reachableCityTile$3 = false;
                        if (!unit.getMovement().canReach(it)) continue;
                        v5 = element$iv;
                        break block42;
                    }
                    v5 = null;
                }
                reachableCityTile = v5;
                if (reachableCityTile != null) {
                    unit.getMovement().headTowards(reachableCityTile);
                } else {
                    UnitAutomation.wander$default(this, unit, false, null, 6, null);
                }
                return true;
            }
            emptyCities = SequencesKt.filter(SequencesKt.map(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), (Function1<City, Tile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, tryHealUnit$lambda$6(com.unciv.logic.city.City ), (Lcom/unciv/logic/city/City;)Lcom/unciv/logic/map/tile/Tile;)()), (Function1<Tile, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, tryHealUnit$lambda$7(com.unciv.logic.map.mapunit.MapUnit com.unciv.logic.map.tile.Tile ), (Lcom/unciv/logic/map/tile/Tile;)Ljava/lang/Boolean;)((MapUnit)unit));
            if (SequencesKt.none(emptyCities)) {
                return false;
            }
            v6 = unitDistanceToTiles.keySet();
            Intrinsics.checkNotNullExpressionValue(v6, "<get-keys>(...)");
            element$iv = v6;
            $i$f$filter = false;
            it = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-UnitAutomation$tryHealUnit$nextTileToMove$1 = false;
                v7 = unit.getMovement();
                Intrinsics.checkNotNull(it);
                if (!UnitMovement.canMoveTo$default(v7, it, false, false, false, 14, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$minByOrNull = false;
            iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v8 = null;
            } else {
                minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v8 = minElem$iv;
                } else {
                    tile = (Tile)minElem$iv;
                    $i$a$-minByOrNull-UnitAutomation$tryHealUnit$nextTileToMove$2 = false;
                    element$iv$iv = emptyCities.iterator();
                    if (!element$iv$iv.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    city = (Tile)element$iv$iv.next();
                    $i$a$-minOf-UnitAutomation$tryHealUnit$nextTileToMove$2$1 = false;
                    Intrinsics.checkNotNull(tile);
                    city = city.aerialDistanceTo(tile);
                    while (element$iv$iv.hasNext()) {
                        city = (Tile)element$iv$iv.next();
                        $i$a$-minOf-UnitAutomation$tryHealUnit$nextTileToMove$2$1 = false;
                        var18_59 = city.aerialDistanceTo(tile);
                        if (city <= var18_59) continue;
                        city = var18_59;
                    }
                    minValue$iv = city;
                    do {
                        e$iv = iterator$iv.next();
                        tile = (Tile)e$iv;
                        $i$a$-minByOrNull-UnitAutomation$tryHealUnit$nextTileToMove$2 = false;
                        var18_61 = emptyCities.iterator();
                        if (!var18_61.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        city = var18_61.next();
                        $i$a$-minOf-UnitAutomation$tryHealUnit$nextTileToMove$2$1 = false;
                        Intrinsics.checkNotNull(tile);
                        var19_62 = city.aerialDistanceTo(tile);
                        while (var18_61.hasNext()) {
                            city = var18_61.next();
                            $i$a$-minOf-UnitAutomation$tryHealUnit$nextTileToMove$2$1 = false;
                            var20_65 = city.aerialDistanceTo(tile);
                            if (var19_62 <= var20_65) continue;
                            var19_62 = var20_65;
                        }
                        v$iv = var19_62;
                        if (minValue$iv <= v$iv) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v8 = minElem$iv;
                }
            }
            v9 = v8;
            if (v9 == null) {
                return false;
            }
            nextTileToMove = v9;
            UnitMovement.moveToTile$default(unit.getMovement(), nextTileToMove, false, 2, null);
            return true;
        }
        $i$f$firstOrNull = tilesByHealingRate.entrySet();
        $this$minByOrNull$iv = $i$f$firstOrNull.iterator();
        if (!$this$minByOrNull$iv.hasNext()) {
            v10 = null;
        } else {
            $i$f$minByOrNull = $this$minByOrNull$iv.next();
            if (!$this$minByOrNull$iv.hasNext()) {
                v10 = $i$f$minByOrNull;
            } else {
                it = (Map.Entry)$i$f$minByOrNull;
                $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1 = false;
                it = ((Number)it.getKey()).intValue();
                do {
                    $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1 = $this$minByOrNull$iv.next();
                    it = (Map.Entry)$i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1;
                    $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1 = false;
                    it = ((Number)it.getKey()).intValue();
                    if (it >= it) continue;
                    $i$f$minByOrNull = $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTilesForHealing$1;
                    it = it;
                } while ($this$minByOrNull$iv.hasNext());
                v10 = $i$f$minByOrNull;
            }
        }
        v11 = v10;
        Intrinsics.checkNotNull(v11);
        bestTilesForHealing = (List)v11.getValue();
        $this$maxByOrNull$iv = bestTilesForHealing;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v12 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v12 = maxElem$iv;
            } else {
                it = (Tile)maxElem$iv;
                $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTileForHealing$1 = false;
                maxValue$iv = Tile.getDefensiveBonus$default(it, false, unit, 1, null);
                do {
                    e$iv = iterator$iv.next();
                    it = (Tile)e$iv;
                    $i$a$-maxByOrNull-UnitAutomation$tryHealUnit$bestTileForHealing$1 = false;
                    v$iv = Tile.getDefensiveBonus$default(it, false, unit, 1, null);
                    if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v12 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v12);
        bestTileForHealing = v12;
        bestTileForHealingRank = unit.rankTileForHealing(bestTileForHealing);
        if (!Intrinsics.areEqual(currentUnitTile, bestTileForHealing) && bestTileForHealingRank > unit.rankTileForHealing(currentUnitTile) - MapUnit.getDamageFromTerrain$default(unit, null, 1, null)) {
            UnitMovement.moveToTile$default(unit.getMovement(), bestTileForHealing, false, 2, null);
        }
        unit.fortifyIfCan();
        return true;
    }

    @Readonly
    private final boolean canUnitHealInTurnsOnCurrentTile(MapUnit unit, int turns, int noEnemyDistance) {
        int healthRequiredPerTurn;
        block6: {
            block5: {
                if (MapUnit.hasUnique$default(unit, UniqueType.HealsEvenAfterAction, null, false, 6, null)) {
                    return false;
                }
                if (!unit.getTile().isCityCenter()) break block5;
                City city = unit.getTile().getCity();
                Intrinsics.checkNotNull(city);
                if (city.getHealth() > 50) break block6;
            }
            if (ThreatManager.getDistanceToClosestEnemyUnit$default(unit.getCiv().getThreatManager(), unit.getTile(), noEnemyDistance, false, 4, null) <= noEnemyDistance) {
                return false;
            }
        }
        return (healthRequiredPerTurn = (100 - unit.getHealth()) / turns) <= unit.rankTileForHealing(unit.getTile());
    }

    static /* synthetic */ boolean canUnitHealInTurnsOnCurrentTile$default(UnitAutomation unitAutomation, MapUnit mapUnit, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 3;
        }
        return unitAutomation.canUnitHealInTurnsOnCurrentTile(mapUnit, n, n2);
    }

    @Readonly
    private final HashSet<Tile> getDangerousTiles(MapUnit unit) {
        Sequence nearbyEnemyUnits = SequencesKt.flatMap(unit.getCurrentTile().getTilesInDistance(3), arg_0 -> UnitAutomation.getDangerousTiles$lambda$0(unit, arg_0));
        Sequence tilesInRangeOfAttack = SequencesKt.flatMap(nearbyEnemyUnits, UnitAutomation::getDangerousTiles$lambda$1);
        Sequence tilesWithinBombardmentRange = SequencesKt.flatMap(SequencesKt.filter(unit.getCurrentTile().getTilesInDistance(3), arg_0 -> UnitAutomation.getDangerousTiles$lambda$2(unit, arg_0)), UnitAutomation::getDangerousTiles$lambda$3);
        Sequence<Tile> tilesWithTerrainDamage = SequencesKt.filter(unit.getCurrentTile().getTilesInDistance(3), arg_0 -> UnitAutomation.getDangerousTiles$lambda$4(unit, arg_0));
        return SequencesKt.toHashSet(SequencesKt.plus(SequencesKt.plus(tilesInRangeOfAttack, tilesWithinBombardmentRange), tilesWithTerrainDamage));
    }

    /*
     * Unable to fully structure code
     */
    public final boolean tryPillageImprovement(@NotNull MapUnit unit, boolean onlyPillageToHeal) {
        block14: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            if (unit.isCivilian()) {
                return false;
            }
            unitDistanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
            var5_4 = unitDistanceToTiles;
            $i$f$filter = false;
            var7_7 = $this$filter$iv;
            destination$iv$iv = new LinkedHashMap<K, V>();
            $i$f$filterTo = false;
            for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                it = element$iv$iv;
                $i$a$-filter-UnitAutomation$tryPillageImprovement$tilesThatCanWalkToAndThenPillage$1 = false;
                if (!(((UnitMovement.ParentTileAndTotalMovement)it.getValue()).getTotalMovement() < unit.getCurrentMovement())) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv.keySet();
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (Map.Entry<K, V> element$iv$iv : $this$filterTo$iv$iv) {
                it = (Tile)element$iv$iv;
                $i$a$-filter-UnitAutomation$tryPillageImprovement$tilesThatCanWalkToAndThenPillage$2 = false;
                if (!UnitMovement.canMoveTo$default(unit.getMovement(), (Tile)it, false, false, false, 14, null) || !UnitActionsPillage.INSTANCE.canPillage(unit, (Tile)it)) ** GOTO lbl-1000
                if (it.canPillageTileImprovement()) ** GOTO lbl-1000
                if (!onlyPillageToHeal && it.canPillageRoad() && it.getRoadOwner() != null) {
                    v0 = unit.getCiv();
                    v1 = it.getRoadOwner();
                    Intrinsics.checkNotNull(v1);
                    ** if (!v0.isAtWarWith((Civilization)v1)) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v2 = true;
                    ** GOTO lbl38
                }
lbl-1000:
                // 3 sources

                {
                    v2 = false;
                }
lbl38:
                // 2 sources

                if (!v2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            tilesThatCanWalkToAndThenPillage = (List)destination$iv$iv;
            if (tilesThatCanWalkToAndThenPillage.isEmpty()) {
                return false;
            }
            $this$maxByOrNull$iv = tilesThatCanWalkToAndThenPillage;
            $i$f$maxByOrNull = false;
            iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v3 = null;
            } else {
                maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v3 = maxElem$iv;
                } else {
                    it = (Tile)maxElem$iv;
                    $i$a$-maxByOrNull-UnitAutomation$tryPillageImprovement$tileToPillage$1 = false;
                    maxValue$iv = it.getDefensiveBonus(false, unit);
                    do {
                        e$iv = iterator$iv.next();
                        it = (Tile)e$iv;
                        $i$a$-maxByOrNull-UnitAutomation$tryPillageImprovement$tileToPillage$1 = false;
                        v$iv = it.getDefensiveBonus(false, unit);
                        if (Float.compare(maxValue$iv, v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v3 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v3);
            tileToPillage = v3;
            if (!Intrinsics.areEqual(unit.getTile(), tileToPillage)) {
                UnitMovement.moveToTile$default(unit.getMovement(), tileToPillage, false, 2, null);
            }
            if (!Intrinsics.areEqual(unit.getCurrentTile(), tileToPillage)) {
                return false;
            }
            v4 = UnitActionsPillage.INSTANCE.getPillageAction$core(unit, unit.getCurrentTile());
            if (v4 == null || (v4 = v4.getAction()) == null) break block14;
            v4.invoke();
        }
        return true;
    }

    public static /* synthetic */ boolean tryPillageImprovement$default(UnitAutomation unitAutomation, MapUnit mapUnit, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return unitAutomation.tryPillageImprovement(mapUnit, bl);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean tryAdvanceTowardsCloseEnemy(MapUnit unit) {
        unitDistanceToTiles = UnitMovement.getMovementToTilesAtPosition$default(unit.getMovement(), unit.getTile().getPosition(), (float)MapUnit.getMaxMovement$default(unit, false, 1, null) * 3.0f, false, null, null, null, false, 124, null);
        var4_3 = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, unitDistanceToTiles, SequencesKt.toList(unit.getTile().getTilesInDistance(5)), false, 8, null);
        $i$f$filterNot = false;
        var6_5 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (AttackableTile)element$iv$iv;
            $i$a$-filterNot-UnitAutomation$tryAdvanceTowardsCloseEnemy$closeEnemy$1 = false;
            if (!unit.getBaseUnit().isRanged() || !it.getTileToAttack().isCityCenter()) ** GOTO lbl-1000
            v0 = it.getTileToAttack().getCity();
            Intrinsics.checkNotNull(v0);
            if (v0.getHealth() == 1) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            if (v1) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterNotTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (AttackableTile)element$iv$iv;
            $i$a$-filter-UnitAutomation$tryAdvanceTowardsCloseEnemy$closeEnemy$2 = false;
            if (!(unit.getDamageFromTerrain(it.getTileToAttackFrom()) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (AttackableTile)element$iv$iv;
            $i$a$-filter-UnitAutomation$tryAdvanceTowardsCloseEnemy$closeEnemy$3 = false;
            v2 = new MapUnitCombatant(unit);
            v3 = Battle.INSTANCE.getMapCombatantOfTile(it.getTileToAttack());
            Intrinsics.checkNotNull(v3);
            if (!(BattleDamage.calculateDamageToAttacker$default(BattleDamage.INSTANCE, v2, v3, null, 0.0f, 12, null) < unit.getHealth())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$minByOrNull = false;
        iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v4 = null;
        } else {
            minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v4 = minElem$iv;
            } else {
                it = (AttackableTile)minElem$iv;
                $i$a$-minByOrNull-UnitAutomation$tryAdvanceTowardsCloseEnemy$closeEnemy$4 = false;
                minValue$iv = it.getTileToAttack().aerialDistanceTo(unit.getTile());
                do {
                    e$iv = iterator$iv.next();
                    it = (AttackableTile)e$iv;
                    $i$a$-minByOrNull-UnitAutomation$tryAdvanceTowardsCloseEnemy$closeEnemy$4 = false;
                    v$iv = it.getTileToAttack().aerialDistanceTo(unit.getTile());
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v4 = minElem$iv;
            }
        }
        closeEnemy = v4;
        if (closeEnemy != null) {
            unit.getMovement().headTowards(closeEnemy.getTileToAttackFrom());
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryPrepare(MapUnit unit) {
        void $this$sortedBy$iv;
        Object object;
        Civilization civInfo = unit.getCiv();
        Set<Civilization> hostileCivs = SequencesKt.toSet(SequencesKt.filter(civInfo.getKnownCivs(), arg_0 -> UnitAutomation.tryPrepare$lambda$0(civInfo, arg_0)));
        Sequence<Pair> closeCities = SequencesKt.filter(civInfo.getThreatManager().getNeighboringCitiesOfOtherCivs(), arg_0 -> UnitAutomation.tryPrepare$lambda$1(hostileCivs, arg_0));
        Iterator<Pair> iterator2 = closeCities.iterator();
        if (!iterator2.hasNext()) {
            object = null;
        } else {
            Object it = iterator2.next();
            boolean bl = false;
            it = ((City)((Pair)it).getFirst()).getCenterTile().aerialDistanceTo(((City)((Pair)it).getSecond()).getCenterTile());
            while (iterator2.hasNext()) {
                Pair it2 = iterator2.next();
                sequence = false;
                Comparable comparable = Integer.valueOf(((City)it2.getFirst()).getCenterTile().aerialDistanceTo(((City)it2.getSecond()).getCenterTile()));
                if (it.compareTo(comparable) <= 0) continue;
                it = comparable;
            }
            object = it;
        }
        Integer n = (Integer)object;
        if (n == null) {
            return false;
        }
        int closestDistance = n;
        Object object2 = SequencesKt.distinct(SequencesKt.map(SequencesKt.filter(closeCities, arg_0 -> UnitAutomation.tryPrepare$lambda$3(closestDistance, arg_0)), UnitAutomation::tryPrepare$lambda$4));
        boolean $i$f$sortedBy = false;
        Sequence citiesToDefend = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
            final /* synthetic */ MapUnit $unit$inlined;
            {
                this.$unit$inlined = mapUnit;
            }

            public final int compare(T a, T b) {
                City it = (City)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(this.$unit$inlined.getTile().aerialDistanceTo(it.getCenterTile()));
                it = (City)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, this.$unit$inlined.getTile().aerialDistanceTo(it.getCenterTile()));
            }
        });
        object2 = citiesToDefend.iterator();
        while (object2.hasNext()) {
            Object v2;
            block7: {
                void $this$firstOrNull$iv;
                City city = (City)object2.next();
                if (unit.getTile().aerialDistanceTo(city.getCenterTile()) <= 2) {
                    return true;
                }
                Sequence<Tile> sequence = city.getCenterTile().getTilesInDistance(2);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Tile it = (Tile)element$iv;
                    boolean bl = false;
                    if (!(UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null) && unit.getMovement().canReach(it))) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            Tile tile = v2;
            if (tile == null) continue;
            Tile tileToMoveTo = tile;
            unit.getMovement().headTowards(tileToMoveTo);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryAccompanySettlerOrGreatPerson(MapUnit unit) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            PathsToTilesWithinTurn distanceToTiles = UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null);
            Sequence<MapUnit> sequence = unit.getCiv().getUnits().getCivUnits();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                MapUnit it = (MapUnit)element$iv;
                boolean bl = false;
                Tile tile = it.getCurrentTile();
                if (!(it.isCivilian() && (MapUnit.hasUnique$default(it, UniqueType.FoundCity, null, false, 6, null) || unit.isGreatPerson()) && !MapUnit.hasUnique$default(it, UniqueType.StrengthBonusInRadius, null, false, 6, null) && (Intrinsics.areEqual(tile, unit.getCurrentTile()) || tile.getMilitaryUnit() == null && UnitMovement.canMoveTo$default(unit.getMovement(), tile, false, false, false, 14, null)) && distanceToTiles.containsKey((Object)tile))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        MapUnit mapUnit = v0;
        if (mapUnit == null) {
            return false;
        }
        MapUnit settlerOrGreatPersonToAccompany = mapUnit;
        unit.getMovement().headTowards(settlerOrGreatPersonToAccompany.getCurrentTile());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryHeadTowardsOurSiegedCity(MapUnit unit) {
        Object v1;
        block5: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            boolean bl;
            Sequence<City> siegedCities;
            block4: {
                Sequence<City> $this$any$iv = siegedCities = SequencesKt.filter(CollectionsKt.asSequence((Iterable)unit.getCiv().getCities()), arg_0 -> UnitAutomation.tryHeadTowardsOurSiegedCity$lambda$0(unit, arg_0));
                boolean $i$f$any = false;
                Iterator<City> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    City element$iv;
                    City it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(it.getCenterTile().aerialDistanceTo(unit.getTile()) <= 2)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            Sequence $i$f$any = SequencesKt.flatMap(siegedCities, UnitAutomation::tryHeadTowardsOurSiegedCity$lambda$2);
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl3 = false;
                if (!(UnitMovement.canMoveTo$default(unit.getMovement(), it, false, false, false, 14, null) && unit.getMovement().canReach(it) && unit.getDamageFromTerrain(it) <= 0)) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        Tile reachableTileNearSiegedCity = v1;
        if (reachableTileNearSiegedCity != null) {
            unit.getMovement().headTowards(reachableTileNearSiegedCity);
        }
        return !unit.hasMovement();
    }

    public final boolean tryEnterOwnClosestCity(@NotNull MapUnit unit) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Sequence $this$sortedBy$iv = CollectionsKt.asSequence((Iterable)unit.getCiv().getCities());
            boolean $i$f$sortedBy = false;
            Sequence $this$firstOrNull$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    City it = (City)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCenterTile().aerialDistanceTo(this.$unit$inlined.getTile()));
                    it = (City)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getCenterTile().aerialDistanceTo(this.$unit$inlined.getTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            Iterator iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                City it = (City)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it.getCenterTile())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        City city = v0;
        if (city == null) {
            return false;
        }
        City closestCity = city;
        unit.getMovement().headTowards(closestCity.getCenterTile());
        return true;
    }

    public final boolean tryBombardEnemy(@NotNull City city) {
        Intrinsics.checkNotNullParameter(city, "city");
        if (!city.canBombard()) {
            return false;
        }
        ICombatant iCombatant = this.chooseBombardTarget(city);
        if (iCombatant == null) {
            return false;
        }
        ICombatant enemy = iCombatant;
        Battle.INSTANCE.attack(new CityCombatant(city), enemy);
        return true;
    }

    @Readonly
    private final ICombatant chooseBombardTarget(City city) {
        ICombatant iCombatant;
        Sequence<ICombatant> targets = SequencesKt.filterNot(SequencesKt.map(TargetHelper.INSTANCE.getBombardableTiles(city), UnitAutomation::chooseBombardTarget$lambda$0), UnitAutomation::chooseBombardTarget$lambda$1);
        if (SequencesKt.none(targets)) {
            return null;
        }
        Sequence<ICombatant> $this$maxByOrNull$iv = targets;
        boolean $i$f$maxByOrNull = false;
        Iterator<ICombatant> iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            iCombatant = null;
        } else {
            ICombatant maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                iCombatant = maxElem$iv;
            } else {
                ICombatant it = maxElem$iv;
                boolean bl = false;
                int maxValue$iv = BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, new CityCombatant(city), it, null, 0.0f, 12, null);
                do {
                    ICombatant e$iv;
                    ICombatant it2 = e$iv = iterator$iv.next();
                    $i$a$-maxByOrNull-UnitAutomation$chooseBombardTarget$1 = false;
                    int v$iv = BattleDamage.calculateDamageToDefender$default(BattleDamage.INSTANCE, new CityCombatant(city), it2, null, 0.0f, 12, null);
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                iCombatant = maxElem$iv;
            }
        }
        return iCombatant;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryTakeBackCapturedCity(MapUnit unit) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            Sequence<City> capturedCities = SequencesKt.filter(SequencesKt.flatMap(unit.getCiv().getKnownCivs(), UnitAutomation::tryTakeBackCapturedCity$lambda$0), arg_0 -> UnitAutomation.tryTakeBackCapturedCity$lambda$1(unit, arg_0));
            if (unit.getBaseUnit().isRanged()) {
                capturedCities = SequencesKt.filterNot(capturedCities, UnitAutomation::tryTakeBackCapturedCity$lambda$2);
            }
            Sequence<Tile> sequence = SequencesKt.map(capturedCities, UnitAutomation::tryTakeBackCapturedCity$lambda$3);
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    Tile it = (Tile)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.aerialDistanceTo(this.$unit$inlined.getTile()));
                    it = (Tile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.aerialDistanceTo(this.$unit$inlined.getTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Tile it = (Tile)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Tile closestReachableCapturedCity = v0;
        if (closestReachableCapturedCity != null) {
            return HeadTowardsEnemyCityAutomation.INSTANCE.headTowardsEnemyCity(unit, closestReachableCapturedCity, UnitMovement.getShortestPath$default(unit.getMovement(), closestReachableCapturedCity, false, 2, null));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryGarrisoningLandUnit(MapUnit unit) {
        Object v2;
        block9: {
            void $this$firstOrNull$iv;
            Sequence $this$sortedBy$iv;
            Sequence<Object> sequence;
            City it;
            void $this$filterTo$iv$iv;
            if (unit.getBaseUnit().isWaterUnit()) {
                return false;
            }
            Iterable $this$filter$iv = unit.getCiv().getCities();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (City)element$iv$iv;
                boolean bl = false;
                Tile centerTile = it.getCenterTile();
                if (!(centerTile.getMilitaryUnit() == null && UnitMovement.canMoveTo$default(unit.getMovement(), centerTile, false, false, false, 14, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List citiesWithoutGarrison = (List)destination$iv$iv;
            if (!unit.getCiv().isAtWar()) {
                if (unit.getTile().isCityCenter()) {
                    return true;
                }
                sequence = CollectionsKt.asSequence(citiesWithoutGarrison);
            } else {
                Sequence<City> citiesWithoutGarrisonThatNeedDefending;
                if (unit.getTile().isCityCenter()) {
                    City city = unit.getTile().getCity();
                    Intrinsics.checkNotNull(city);
                    if (this.isCityThatNeedsDefendingInWartime(city)) {
                        return true;
                    }
                }
                sequence = SequencesKt.any(citiesWithoutGarrisonThatNeedDefending = SequencesKt.filter(CollectionsKt.asSequence(citiesWithoutGarrison), UnitAutomation::tryGarrisoningLandUnit$lambda$1)) ? citiesWithoutGarrisonThatNeedDefending : CollectionsKt.asSequence(citiesWithoutGarrison);
            }
            Sequence citiesToTry = sequence;
            destination$iv$iv = citiesToTry;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith($this$sortedBy$iv, new Comparator(unit){
                final /* synthetic */ MapUnit $unit$inlined;
                {
                    this.$unit$inlined = mapUnit;
                }

                public final int compare(T a, T b) {
                    City it = (City)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getCenterTile().aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                    it = (City)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, it.getCenterTile().aerialDistanceTo(this.$unit$inlined.getCurrentTile()));
                }
            });
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (City)element$iv;
                boolean bl = false;
                if (!unit.getMovement().canReach(it.getCenterTile())) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        City city = v2;
        if (city == null) {
            return false;
        }
        City closestReachableCityNeedsDefending = city;
        unit.getMovement().headTowards(closestReachableCityNeedsDefending.getCenterTile());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Readonly
    private final boolean isCityThatNeedsDefendingInWartime(City city) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        IsPartOfGameInfoSerialization it;
        Iterable $this$filterTo$iv$iv;
        if (city.getHealth() < city.getMaxHealth$core()) {
            return true;
        }
        Collection<DiplomacyManager> collection = city.getCiv().getDiplomacy().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DiplomacyManager)element$iv$iv;
            boolean bl = false;
            if (!(((DiplomacyManager)it).getDiplomaticStatus() == DiplomaticStatus.War)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DiplomacyManager)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((DiplomacyManager)it).getOtherCiv());
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Civilization)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ((Civilization)it).getCities();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        for (City enemyCivCity : (List)destination$iv$iv) {
            if (city.getCenterTile().aerialDistanceTo(enemyCivCity.getCenterTile()) > 5) continue;
            return true;
        }
        return false;
    }

    public final void automatedExplore(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        if (this.tryGoToRuin(unit) && (!unit.hasMovement() || unit.isDestroyed())) {
            return;
        }
        if (unit.getHealth() < 80 && this.tryHealUnit(unit)) {
            return;
        }
        if (this.tryExplore$core(unit)) {
            return;
        }
        String[] stringArray = new String[]{unit.getName(), "OtherIcons/Sleep"};
        unit.getCiv().addNotification(unit.shortDisplayName() + " finished exploring.", new MapUnitAction(unit), Notification.NotificationCategory.Units, stringArray);
        unit.setAction(null);
    }

    private static final boolean wander$lambda$0(Set $tilesToAvoid, MapUnit $unit, boolean $stayInTerritory, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !$tilesToAvoid.contains(it) && UnitMovement.canMoveTo$default($unit.getMovement(), it, false, false, false, 14, null) && $unit.getMovement().canReach(it) && $unit.getDamageFromTerrain(it) <= 0 && (!$stayInTerritory || Intrinsics.areEqual(it.getOwner(), $unit.getCiv()) || !Intrinsics.areEqual($unit.getCurrentTile().getOwner(), $unit.getCiv()));
    }

    @Readonly
    private static final boolean getUnitsToUpgradeTo$isInvalidUpgradeDestination(MapUnit $unit, BaseUnit baseUnit) {
        boolean bl;
        block3: {
            if (!$unit.getCiv().getTech().isResearched(baseUnit)) {
                return true;
            }
            if ($unit.getCiv().isBarbarian() && IHasUniques.hasUnique$default(baseUnit, UniqueType.CannotBeBarbarian, null, 2, null)) {
                return true;
            }
            Sequence<Unique> $this$any$iv = baseUnit.getMatchingUniques(UniqueType.OnlyAvailable, GameContext.Companion.getIgnoreConditionals());
            boolean $i$f$any = false;
            Iterator<Unique> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Unique element$iv;
                Unique it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!(!it.conditionalsApply($unit.getCache().getState()))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    private static final BaseUnit getUnitsToUpgradeTo$lambda$1(MapUnit $unit, BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $unit.getCiv().getEquivalentUnit(it);
    }

    private static final boolean getUnitsToUpgradeTo$lambda$2(MapUnit $unit, BaseUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !UnitAutomation.getUnitsToUpgradeTo$isInvalidUpgradeDestination($unit, it) && UnitUpgradeManager.canUpgrade$default($unit.getUpgrade(), it, false, false, 6, null);
    }

    private static final Sequence tryHeadTowardsEncampment$lambda$0(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile().getTilesInDistance(6);
    }

    private static final boolean tryHeadTowardsEncampment$lambda$1(MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getImprovement(), "Barbarian encampment") && $unit.getCiv().hasExplored(it);
    }

    private static final Tile tryRetreat$lambda$2(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Tile)it.getKey();
    }

    private static final Tile tryRetreat$lambda$4(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (Tile)it.getKey();
    }

    private static final Tile tryHealUnit$lambda$3(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile();
    }

    private static final Tile tryHealUnit$lambda$6(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile();
    }

    private static final boolean tryHealUnit$lambda$7(MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return UnitMovement.canMoveTo$default($unit.getMovement(), it, false, false, false, 14, null);
    }

    private static final Sequence getDangerousTiles$lambda$0(MapUnit $unit, Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        return SequencesKt.filter(tile.getUnits(), arg_0 -> UnitAutomation.getDangerousTiles$lambda$0$0($unit, arg_0));
    }

    private static final boolean getDangerousTiles$lambda$0$0(MapUnit $unit, MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $unit.getCiv().isAtWarWith(it.getCiv());
    }

    private static final Sequence getDangerousTiles$lambda$1(MapUnit it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTile().getTilesInDistance(MapUnit.getMaxMovement$default(it, false, 1, null) - 1 + it.getRange());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getDangerousTiles$lambda$2(MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (!it.isCityCenter()) return false;
        City city = it.getCity();
        Intrinsics.checkNotNull(city);
        if (!city.getCiv().isAtWarWith($unit.getCiv())) return false;
        return true;
    }

    private static final Sequence getDangerousTiles$lambda$3(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        City city = it.getCity();
        Intrinsics.checkNotNull(city);
        return it.getTilesInDistance(city.getBombardRange());
    }

    private static final boolean getDangerousTiles$lambda$4(MapUnit $unit, Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $unit.getDamageFromTerrain(it) > 0;
    }

    @Readonly
    private static final boolean tryPrepare$hasPreparationFlag(Civilization civInfo, Civilization targetCiv) {
        DiplomacyManager diplomacyManager = civInfo.getDiplomacyManager(targetCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diploManager = diplomacyManager;
        if (diploManager.hasFlag(DiplomacyFlags.Denunciation) || diploManager.otherCivDiplomacy().hasFlag(DiplomacyFlags.Denunciation)) {
            return true;
        }
        return diploManager.hasFlag(DiplomacyFlags.WaryOf) && diploManager.getFlag(DiplomacyFlags.WaryOf) < 0;
    }

    private static final boolean tryPrepare$lambda$0(Civilization $civInfo, Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isAtWarWith($civInfo) || UnitAutomation.tryPrepare$hasPreparationFlag($civInfo, it);
    }

    private static final boolean tryPrepare$lambda$1(Set $hostileCivs, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $hostileCivs.contains(((City)it.getSecond()).getCiv());
    }

    private static final boolean tryPrepare$lambda$3(int $closestDistance, Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((City)it.getFirst()).getCenterTile().aerialDistanceTo(((City)it.getSecond()).getCenterTile()) <= $closestDistance + 2;
    }

    private static final City tryPrepare$lambda$4(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (City)it.getFirst();
    }

    private static final boolean tryHeadTowardsOurSiegedCity$lambda$0(MapUnit $unit, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual($unit.getCiv(), it.getCiv()) && it.getHealth() < it.getMaxHealth$core();
    }

    private static final Sequence tryHeadTowardsOurSiegedCity$lambda$2(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile().getTilesAtDistance(2);
    }

    private static final ICombatant chooseBombardTarget$lambda$0(Tile it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ICombatant iCombatant = Battle.INSTANCE.getMapCombatantOfTile(it);
        Intrinsics.checkNotNull(iCombatant);
        return iCombatant;
    }

    private static final boolean chooseBombardTarget$lambda$1(ICombatant it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof MapUnitCombatant && it.isCivilian();
    }

    private static final Sequence tryTakeBackCapturedCity$lambda$0(Civilization it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return CollectionsKt.asSequence((Iterable)it.getCities());
    }

    private static final boolean tryTakeBackCapturedCity$lambda$1(MapUnit $unit, City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $unit.getCiv().isAtWarWith(it.getCiv()) && Intrinsics.areEqual($unit.getCiv(), it.getFoundingCivObject()) && it.isInResistance() && it.getHealth() < it.getMaxHealth$core();
    }

    private static final boolean tryTakeBackCapturedCity$lambda$2(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getHealth() == 1;
    }

    private static final Tile tryTakeBackCapturedCity$lambda$3(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getCenterTile();
    }

    private static final boolean tryGarrisoningLandUnit$lambda$1(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return INSTANCE.isCityThatNeedsDefendingInWartime(it);
    }
}

