/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.mapeditorscreen;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import com.unciv.UncivGame;
import com.unciv.logic.files.MapSaver;
import com.unciv.logic.map.MapParameters;
import com.unciv.logic.map.MapSize;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.metadata.GameSetupInfo;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import com.unciv.ui.components.input.KeyShortcutDispatcherVeto;
import com.unciv.ui.components.input.KeyboardPanningListener;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayerOverlay;
import com.unciv.ui.components.widgets.TabbedPager;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.ImageWithCustomSize;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.basescreen.RecreateOnResize;
import com.unciv.ui.screens.mapeditorscreen.EditorMapHolder;
import com.unciv.ui.screens.mapeditorscreen.MapEditorMainTabs;
import com.unciv.ui.screens.mapeditorscreen.MapEditorToolsDrawer;
import com.unciv.ui.screens.mapeditorscreen.tabs.MapEditorOptionsTab;
import com.unciv.ui.screens.worldscreen.ZoomButtonPair;
import com.unciv.utils.Concurrency;
import com.unciv.utils.Dispatcher;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0097\u00012\u00020\u00012\u00020\u0002:\u0002\u0097\u0001B\u0013\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010J\u001a\u000209H\u0002J\b\u0010K\u001a\u00020\u0015H\u0016J\u0006\u0010L\u001a\u00020MJ\u000e\u0010N\u001a\u0002092\u0006\u0010O\u001a\u00020\fJ\u0010\u0010P\u001a\u0002092\u0006\u0010O\u001a\u00020\fH\u0002J\u0018\u0010Q\u001a\u0002092\u000e\b\u0002\u0010R\u001a\b\u0012\u0004\u0012\u0002090SH\u0002J\b\u0010T\u001a\u00020*H\u0002J!\u0010U\u001a\u0002092\n\b\u0002\u0010V\u001a\u0004\u0018\u00010*2\u0006\u0010W\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bXJ)\u0010Y\u001a#\u0012\u0015\u0012\u0013\u0018\u00010Z\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b([\u0012\u0004\u0012\u00020\\04j\u0002`]H\u0016J$\u0010^\u001a\u0002092\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010_\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010`\u001a\u00020aJ\u0006\u0010b\u001a\u00020\u0004J.\u0010c\u001a\u0002092\u0006\u0010_\u001a\u00020\u00152\u0006\u0010d\u001a\u00020e2\u0016\u0010f\u001a\u0012\u0012\u0004\u0012\u00020e0gj\b\u0012\u0004\u0012\u00020e`hJ\r\u0010i\u001a\u000209H\u0000\u00a2\u0006\u0002\bjJ0\u0010k\u001a\u0002092\u0006\u0010l\u001a\u00020e2\u0006\u0010m\u001a\u00020e2\b\b\u0002\u0010n\u001a\u00020\f2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002090SH\u0002J\u0014\u0010p\u001a\u0002092\f\u0010o\u001a\b\u0012\u0004\u0012\u0002090SJ\u0006\u0010q\u001a\u000209J\u0018\u0010r\u001a\u0002092\u0006\u00108\u001a\u0002052\b\b\u0002\u0010s\u001a\u00020tJ\u000e\u0010u\u001a\u0002092\u0006\u00108\u001a\u000205J\u0018\u0010v\u001a\u0002092\u0006\u00108\u001a\u0002052\b\b\u0002\u0010s\u001a\u00020tJ\b\u0010w\u001a\u00020\u0001H\u0016J\b\u0010x\u001a\u000209H\u0016JH\u0010y\u001a\u0002092\u0006\u00107\u001a\u00020e2\b\b\u0002\u0010z\u001a\u00020\f2(\u0010{\u001a$\b\u0001\u0012\u0004\u0012\u00020}\u0012\n\u0012\b\u0012\u0004\u0012\u0002090~\u0012\u0006\u0012\u0004\u0018\u00010\u007f0|\u00a2\u0006\u0003\b\u0080\u0001\u00a2\u0006\u0003\u0010\u0081\u0001J\t\u0010\u0082\u0001\u001a\u000209H\u0002J\t\u0010\u0091\u0001\u001a\u000209H\u0002J\u0015\u0010\u0092\u0001\u001a\u0002092\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001H\u0002J\u0012\u0010\u0093\u0001\u001a\u0002092\u0007\u0010\u0085\u0001\u001a\u00020MH\u0002J\u0013\u0010\u0094\u0001\u001a\u0002092\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0002R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u000fR\u001a\u0010\u001d\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\r\"\u0004\b\u001f\u0010\u000fR\u001a\u0010 \u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\r\"\u0004\b\"\u0010\u000fR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R7\u00103\u001a\u001f\u0012\u0013\u0012\u001105\u00a2\u0006\f\b6\u0012\b\b7\u0012\u0004\b\b(8\u0012\u0004\u0012\u000209\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020F0EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010G\u001a\b\u0012\u0004\u0012\u00020I0HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0083\u0001\u001a\u0005\u0018\u00010\u0084\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0086\u00012\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001@@X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001\"\u0006\b\u008a\u0001\u0010\u008b\u0001R*\u0010\u008c\u0001\u001a\u00020M2\u0007\u0010\u0085\u0001\u001a\u00020M@@X\u0080\u000e\u00a2\u0006\u0012\n\u0000\u001a\u0006\b\u008d\u0001\u0010\u008e\u0001\"\u0006\b\u008f\u0001\u0010\u0090\u0001\u00a8\u0006\u0098\u0001"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen;", "Lcom/unciv/ui/screens/basescreen/BaseScreen;", "Lcom/unciv/ui/screens/basescreen/RecreateOnResize;", "map", "Lcom/unciv/logic/map/TileMap;", "<init>", "(Lcom/unciv/logic/map/TileMap;)V", "tileMap", "getTileMap", "()Lcom/unciv/logic/map/TileMap;", "setTileMap", "isDirty", "", "()Z", "setDirty", "(Z)V", "newMapParameters", "Lcom/unciv/logic/map/MapParameters;", "getNewMapParameters", "()Lcom/unciv/logic/map/MapParameters;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getRuleset", "()Lcom/unciv/models/ruleset/Ruleset;", "setRuleset", "(Lcom/unciv/models/ruleset/Ruleset;)V", "modsTabNeedsRefresh", "getModsTabNeedsRefresh", "setModsTabNeedsRefresh", "editTabsNeedRefresh", "getEditTabsNeedRefresh", "setEditTabsNeedRefresh", "naturalWondersNeedRefresh", "getNaturalWondersNeedRefresh", "setNaturalWondersNeedRefresh", "tileMatchFuzziness", "Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;", "getTileMatchFuzziness", "()Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;", "setTileMatchFuzziness", "(Lcom/unciv/ui/screens/mapeditorscreen/tabs/MapEditorOptionsTab$TileMatchFuzziness;)V", "mapHolder", "Lcom/unciv/ui/screens/mapeditorscreen/EditorMapHolder;", "getMapHolder", "()Lcom/unciv/ui/screens/mapeditorscreen/EditorMapHolder;", "setMapHolder", "(Lcom/unciv/ui/screens/mapeditorscreen/EditorMapHolder;)V", "tabs", "Lcom/unciv/ui/screens/mapeditorscreen/MapEditorMainTabs;", "getTabs", "()Lcom/unciv/ui/screens/mapeditorscreen/MapEditorMainTabs;", "tileClickHandler", "Lkotlin/Function1;", "Lcom/unciv/logic/map/tile/Tile;", "Lkotlin/ParameterName;", "name", "tile", "", "getTileClickHandler", "()Lkotlin/jvm/functions/Function1;", "setTileClickHandler", "(Lkotlin/jvm/functions/Function1;)V", "zoomController", "Lcom/unciv/ui/screens/worldscreen/ZoomButtonPair;", "descriptionTextField", "Lcom/unciv/ui/components/widgets/UncivTextField;", "getDescriptionTextField", "()Lcom/unciv/ui/components/widgets/UncivTextField;", "highlightedTileGroups", "", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "jobs", "Lkotlin/collections/ArrayDeque;", "Lkotlinx/coroutines/Job;", "startMapAutosaveLoop", "getCivilopediaRuleset", "getToolsWidth", "", "setWorldWrap", "newValue", "setWorldWrapFixOddWidth", "recreateMapHolder", "actionWhileRemoved", "Lkotlin/Function0;", "newMapHolder", "enableKeyboardPanningListener", "holder", "enable", "enableKeyboardPanningListener$core", "getShortcutDispatcherVetoer", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "associatedActor", "Lcom/unciv/ui/components/input/KeyShortcutDispatcherVeto$DispatcherVetoResult;", "Lcom/unciv/ui/components/input/DispatcherVetoer;", "loadMap", "newRuleset", "selectPage", "", "getMapCloneForSave", "applyRuleset", "newBaseRuleset", "", "mods", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "closeEditor", "closeEditor$core", "askIfDirty", "question", "confirmText", "isConfirmPositive", "action", "askIfDirtyForLoad", "hideSelection", "highlightTile", "color", "Lcom/badlogic/gdx/graphics/Color;", "updateTile", "updateAndHighlight", "recreate", "dispose", "startBackgroundJob", "isDaemon", "block", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function2;)V", "cancelJobs", "imageOverlay", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "value", "Lcom/badlogic/gdx/files/FileHandle;", "overlayFile", "getOverlayFile$core", "()Lcom/badlogic/gdx/files/FileHandle;", "setOverlayFile$core", "(Lcom/badlogic/gdx/files/FileHandle;)V", "overlayAlpha", "getOverlayAlpha$core", "()F", "setOverlayAlpha$core", "(F)V", "clearOverlayImages", "overlayFileChanged", "overlayAlphaChanged", "addOverlayToMapHolder", "newHolderContent", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMapEditorScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapEditorScreen.kt\ncom/unciv/ui/screens/mapeditorscreen/MapEditorScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,414:1\n808#2,11:415\n1#3:426\n*S KotlinDebug\n*F\n+ 1 MapEditorScreen.kt\ncom/unciv/ui/screens/mapeditorscreen/MapEditorScreen\n*L\n240#1:415,11\n*E\n"})
public final class MapEditorScreen
extends BaseScreen
implements RecreateOnResize {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private TileMap tileMap;
    private boolean isDirty;
    @NotNull
    private final MapParameters newMapParameters;
    @NotNull
    private Ruleset ruleset;
    private boolean modsTabNeedsRefresh;
    private boolean editTabsNeedRefresh;
    private boolean naturalWondersNeedRefresh;
    @NotNull
    private MapEditorOptionsTab.TileMatchFuzziness tileMatchFuzziness;
    @NotNull
    private EditorMapHolder mapHolder;
    @NotNull
    private final MapEditorMainTabs tabs;
    @Nullable
    private Function1<? super Tile, Unit> tileClickHandler;
    @Nullable
    private ZoomButtonPair zoomController;
    @NotNull
    private final UncivTextField descriptionTextField;
    @NotNull
    private final List<TileGroup> highlightedTileGroups;
    @NotNull
    private final ArrayDeque<Job> jobs;
    @Nullable
    private Image imageOverlay;
    @Nullable
    private FileHandle overlayFile;
    private float overlayAlpha;

    /*
     * WARNING - void declaration
     */
    public MapEditorScreen(@Nullable TileMap map2) {
        this.newMapParameters = MapEditorScreen.Companion.getDefaultParameters();
        this.tileMatchFuzziness = MapEditorOptionsTab.TileMatchFuzziness.CompleteMatch;
        this.descriptionTextField = new UncivTextField("Enter a description for the users of this map", null, null, 6, null);
        this.highlightedTileGroups = new ArrayList();
        this.jobs = new ArrayDeque(3);
        if (map2 == null) {
            void $this$_init__u24lambda_u240;
            TileMap tileMap;
            Object object = RulesetCache.INSTANCE.get((Object)BaseRuleset.Civ_V_GnK.getFullName());
            Intrinsics.checkNotNull(object);
            this.ruleset = (Ruleset)object;
            TileMap tileMap2 = tileMap = new TileMap(MapSize.Companion.getTiny().getRadius(), this.ruleset, false);
            MapEditorScreen mapEditorScreen = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.getMapParameters().setMapSize(MapSize.Companion.getTiny());
            mapEditorScreen.tileMap = tileMap;
        } else {
            Ruleset ruleset = map2.getRuleset();
            if (ruleset == null) {
                ruleset = RulesetCache.INSTANCE.getComplexRuleset(map2.getMapParameters());
            }
            this.ruleset = ruleset;
            this.tileMap = map2;
            this.descriptionTextField.setText(map2.getDescription());
        }
        this.mapHolder = this.newMapHolder();
        this.isDirty = false;
        ActivationExtensionsKt.onChange(this.descriptionTextField, arg_0 -> MapEditorScreen._init_$lambda$1(this, arg_0));
        this.tabs = new MapEditorMainTabs(this);
        new MapEditorToolsDrawer(this.tabs, this.getStage(), this.mapHolder);
        this.getGlobalShortcuts().add(KeyCharAndCode.Companion.ctrl('n'), () -> MapEditorScreen._init_$lambda$3(this));
        this.getGlobalShortcuts().add(KeyCharAndCode.Companion.ctrl('g'), () -> MapEditorScreen._init_$lambda$4(this));
        this.getGlobalShortcuts().add(KeyCharAndCode.Companion.getBACK(), () -> MapEditorScreen._init_$lambda$5(this));
        this.startMapAutosaveLoop();
        this.overlayAlpha = 0.33f;
    }

    public /* synthetic */ MapEditorScreen(TileMap tileMap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            tileMap = null;
        }
        this(tileMap);
    }

    @NotNull
    public final TileMap getTileMap() {
        return this.tileMap;
    }

    public final void setTileMap(@NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(tileMap, "<set-?>");
        this.tileMap = tileMap;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    @NotNull
    public final MapParameters getNewMapParameters() {
        return this.newMapParameters;
    }

    @NotNull
    public final Ruleset getRuleset() {
        return this.ruleset;
    }

    public final void setRuleset(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "<set-?>");
        this.ruleset = ruleset;
    }

    public final boolean getModsTabNeedsRefresh() {
        return this.modsTabNeedsRefresh;
    }

    public final void setModsTabNeedsRefresh(boolean bl) {
        this.modsTabNeedsRefresh = bl;
    }

    public final boolean getEditTabsNeedRefresh() {
        return this.editTabsNeedRefresh;
    }

    public final void setEditTabsNeedRefresh(boolean bl) {
        this.editTabsNeedRefresh = bl;
    }

    public final boolean getNaturalWondersNeedRefresh() {
        return this.naturalWondersNeedRefresh;
    }

    public final void setNaturalWondersNeedRefresh(boolean bl) {
        this.naturalWondersNeedRefresh = bl;
    }

    @NotNull
    public final MapEditorOptionsTab.TileMatchFuzziness getTileMatchFuzziness() {
        return this.tileMatchFuzziness;
    }

    public final void setTileMatchFuzziness(@NotNull MapEditorOptionsTab.TileMatchFuzziness tileMatchFuzziness) {
        Intrinsics.checkNotNullParameter((Object)tileMatchFuzziness, "<set-?>");
        this.tileMatchFuzziness = tileMatchFuzziness;
    }

    @NotNull
    public final EditorMapHolder getMapHolder() {
        return this.mapHolder;
    }

    public final void setMapHolder(@NotNull EditorMapHolder editorMapHolder) {
        Intrinsics.checkNotNullParameter(editorMapHolder, "<set-?>");
        this.mapHolder = editorMapHolder;
    }

    @NotNull
    public final MapEditorMainTabs getTabs() {
        return this.tabs;
    }

    @Nullable
    public final Function1<Tile, Unit> getTileClickHandler() {
        return this.tileClickHandler;
    }

    public final void setTileClickHandler(@Nullable Function1<? super Tile, Unit> function1) {
        this.tileClickHandler = function1;
    }

    @NotNull
    public final UncivTextField getDescriptionTextField() {
        return this.descriptionTextField;
    }

    private final void startMapAutosaveLoop() {
        this.startBackgroundJob("MapEditorAutosaveLoop", true, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapEditorScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
lbl7:
                        // 3 sources

                        while (true) {
                            this.L$0 = $this$startBackgroundJob;
                            this.label = 1;
                            v0 = DelayKt.delay(10000L, this);
                            if (v0 == var4_3) {
                                return var4_3;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (!CoroutineScopeKt.isActive((CoroutineScope)$this$startBackgroundJob)) {
                            return Unit.INSTANCE;
                        }
                        if (!this.this$0.isDirty()) ** GOTO lbl7
                        try {
                            mapToSave = this.this$0.getMapCloneForSave();
                            if (!CoroutineScopeKt.isActive((CoroutineScope)$this$startBackgroundJob)) {
                                return Unit.INSTANCE;
                            }
                            mapToSave.assignContinents(TileMap.AssignContinentsMode.Reassign);
                            if (!CoroutineScopeKt.isActive((CoroutineScope)$this$startBackgroundJob)) {
                                return Unit.INSTANCE;
                            }
                            MapSaver.INSTANCE.saveMap("Autosave", mapToSave);
                            this.this$0.setDirty(false);
                        }
                        catch (Exception ex) {
                            Log.INSTANCE.error("Failed to autosave map", ex);
                        }
                        ** continue;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public Ruleset getCivilopediaRuleset() {
        return this.ruleset;
    }

    public final float getToolsWidth() {
        return this.getStage().getWidth() * 0.4f;
    }

    public final void setWorldWrap(boolean newValue) {
        if (newValue == this.tileMap.getMapParameters().getWorldWrap()) {
            return;
        }
        this.setWorldWrapFixOddWidth(newValue);
        if (newValue && this.overlayFile != null) {
            this.setOverlayFile$core(null);
            new ToastPopup("An overlay image is incompatible with world wrap and was deactivated.", this.getStage(), 4000L);
            this.tabs.getOptions().update();
        }
        MapEditorScreen.recreateMapHolder$default(this, null, 1, null);
    }

    private final void setWorldWrapFixOddWidth(boolean newValue) {
        MapParameters $this$setWorldWrapFixOddWidth_u24lambda_u240 = this.tileMap.getMapParameters();
        boolean bl = false;
        if ($this$setWorldWrapFixOddWidth_u24lambda_u240.getWorldWrap() && $this$setWorldWrapFixOddWidth_u24lambda_u240.getMapSize().getWidth() % 2 != 0 && Intrinsics.areEqual($this$setWorldWrapFixOddWidth_u24lambda_u240.getShape(), "Rectangular")) {
            MapSize mapSize = $this$setWorldWrapFixOddWidth_u24lambda_u240.getMapSize();
            int n = mapSize.getWidth();
            mapSize.setWidth(n + -1);
        }
        $this$setWorldWrapFixOddWidth_u24lambda_u240.setWorldWrap(newValue);
    }

    private final void recreateMapHolder(Function0<Unit> actionWhileRemoved) {
        float savedScale = this.mapHolder.getScaleX();
        this.clearOverlayImages();
        this.mapHolder.remove();
        actionWhileRemoved.invoke();
        this.mapHolder = this.newMapHolder();
        this.mapHolder.zoom(savedScale);
    }

    static /* synthetic */ void recreateMapHolder$default(MapEditorScreen mapEditorScreen, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            function0 = MapEditorScreen::recreateMapHolder$lambda$0;
        }
        mapEditorScreen.recreateMapHolder(function0);
    }

    private final EditorMapHolder newMapHolder() {
        ImageGetter.setNewRuleset$default(ImageGetter.INSTANCE, this.ruleset, false, 2, null);
        BaseScreen.Companion.setSkin();
        this.tileMap.setTransients(this.ruleset, false);
        this.tileMap.setStartingLocationsTransients();
        UncivGame.Companion.getCurrent().getTranslations().setTranslationActiveMods(this.ruleset.getMods());
        EditorMapHolder newHolder = new EditorMapHolder(this, this.tileMap, arg_0 -> MapEditorScreen.newMapHolder$lambda$0(this, arg_0));
        newHolder.setMapPanningSpeed(UncivGame.Companion.getCurrent().getSettings().getMapPanningSpeed());
        this.enableKeyboardPanningListener$core(newHolder, true);
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            newHolder.setAutoScrollEnabled(UncivGame.Companion.getCurrent().getSettings().getMapAutoScroll());
        }
        Actor actor = newHolder.getActor();
        Intrinsics.checkNotNull(actor, "null cannot be cast to non-null type com.badlogic.gdx.scenes.scene2d.Group");
        this.addOverlayToMapHolder((Group)actor);
        this.getStage().getRoot().addActorAt(0, newHolder);
        this.getStage().setScrollFocus(newHolder);
        this.isDirty = true;
        this.modsTabNeedsRefresh = true;
        this.editTabsNeedRefresh = true;
        this.naturalWondersNeedRefresh = true;
        if (UncivGame.Companion.getCurrent().getSettings().getShowZoomButtons()) {
            ZoomButtonPair zoomButtonPair = this.zoomController = new ZoomButtonPair(newHolder);
            Intrinsics.checkNotNull(zoomButtonPair);
            zoomButtonPair.setPosition(10.0f, 10.0f);
            this.getStage().addActor(this.zoomController);
        }
        return newHolder;
    }

    /*
     * WARNING - void declaration
     */
    public final void enableKeyboardPanningListener$core(@Nullable EditorMapHolder holder, boolean enable) {
        void $this$filterIsInstanceTo$iv$iv;
        DelayedRemovalArray<EventListener> delayedRemovalArray = this.getStage().getRoot().getListeners();
        Intrinsics.checkNotNullExpressionValue(delayedRemovalArray, "getListeners(...)");
        Iterable $this$filterIsInstance$iv = delayedRemovalArray;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KeyboardPanningListener)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (KeyboardPanningListener oldPanningListener : (List)destination$iv$iv) {
            this.getStage().removeListener(oldPanningListener);
            oldPanningListener.dispose();
        }
        if (!enable) {
            return;
        }
        Stage stage = this.getStage();
        EditorMapHolder editorMapHolder = holder;
        if (editorMapHolder == null) {
            editorMapHolder = this.mapHolder;
        }
        stage.addListener(new KeyboardPanningListener(editorMapHolder, false));
    }

    public static /* synthetic */ void enableKeyboardPanningListener$core$default(MapEditorScreen mapEditorScreen, EditorMapHolder editorMapHolder, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            editorMapHolder = null;
        }
        mapEditorScreen.enableKeyboardPanningListener$core(editorMapHolder, bl);
    }

    @Override
    @NotNull
    public Function1<Actor, KeyShortcutDispatcherVeto.DispatcherVetoResult> getShortcutDispatcherVetoer() {
        return KeyShortcutDispatcherVeto.INSTANCE.createTileGroupMapDispatcherVetoer();
    }

    public final void loadMap(@NotNull TileMap map2, @Nullable Ruleset newRuleset, int selectPage) {
        Intrinsics.checkNotNullParameter(map2, "map");
        this.clearOverlayImages();
        this.mapHolder.remove();
        this.tileMap = map2;
        this.descriptionTextField.setText(map2.getDescription());
        Ruleset ruleset = newRuleset;
        if (ruleset == null) {
            ruleset = RulesetCache.INSTANCE.getComplexRuleset(map2.getMapParameters());
        }
        this.ruleset = ruleset;
        this.mapHolder = this.newMapHolder();
        this.isDirty = false;
        Gdx.input.setInputProcessor(this.getStage());
        TabbedPager.selectPage$default((TabbedPager)this.tabs, selectPage, false, 2, null);
    }

    public static /* synthetic */ void loadMap$default(MapEditorScreen mapEditorScreen, TileMap tileMap, Ruleset ruleset, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            ruleset = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        mapEditorScreen.loadMap(tileMap, ruleset, n);
    }

    @NotNull
    public final TileMap getMapCloneForSave() {
        TileMap tileMap;
        TileMap $this$getMapCloneForSave_u24lambda_u240 = tileMap = this.tileMap.clone();
        boolean bl = false;
        TileMap.setTransients$default($this$getMapCloneForSave_u24lambda_u240, null, false, 1, null);
        return tileMap;
    }

    public final void applyRuleset(@NotNull Ruleset newRuleset, @NotNull String newBaseRuleset, @NotNull LinkedHashSet<String> mods) {
        Intrinsics.checkNotNullParameter(newRuleset, "newRuleset");
        Intrinsics.checkNotNullParameter(newBaseRuleset, "newBaseRuleset");
        Intrinsics.checkNotNullParameter(mods, "mods");
        this.recreateMapHolder(() -> MapEditorScreen.applyRuleset$lambda$0(this, newBaseRuleset, mods, newRuleset));
        this.modsTabNeedsRefresh = false;
    }

    public final void closeEditor$core() {
        MapEditorScreen.askIfDirty$default(this, "Do you want to leave without saving the recent changes?", "Leave", false, () -> MapEditorScreen.closeEditor$lambda$0(this), 4, null);
    }

    private final void askIfDirty(String question, String confirmText, boolean isConfirmPositive, Function0<Unit> action2) {
        if (!this.isDirty) {
            action2.invoke();
            return;
        }
        Popup.open$default(new ConfirmPopup(this, question, confirmText, isConfirmPositive, null, action2, 16, null), false, 1, null);
    }

    static /* synthetic */ void askIfDirty$default(MapEditorScreen mapEditorScreen, String string, String string2, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        mapEditorScreen.askIfDirty(string, string2, bl, function0);
    }

    public final void askIfDirtyForLoad(@NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, "action");
        MapEditorScreen.askIfDirty$default(this, "Do you want to load another map without saving the recent changes?", "Load map", false, action2, 4, null);
    }

    public final void hideSelection() {
        Iterator<TileGroup> iterator2 = this.highlightedTileGroups.iterator();
        while (iterator2.hasNext()) {
            TileGroup group;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            group.getLayerOverlay().hideHighlight();
        }
        this.highlightedTileGroups.clear();
    }

    public final void highlightTile(@NotNull Tile tile, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(color, "color");
        TileGroup tileGroup = this.mapHolder.getTileGroups().get(tile);
        if (tileGroup == null) {
            return;
        }
        TileGroup group = tileGroup;
        TileLayerOverlay.showHighlight$default(group.getLayerOverlay(), color, 0.0f, 2, null);
        this.highlightedTileGroups.add(group);
    }

    public static /* synthetic */ void highlightTile$default(MapEditorScreen mapEditorScreen, Tile tile, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        mapEditorScreen.highlightTile(tile, color);
    }

    public final void updateTile(@NotNull Tile tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        TileGroup tileGroup = this.mapHolder.getTileGroups().get(tile);
        Intrinsics.checkNotNull(tileGroup);
        TileGroup.update$default(tileGroup, null, null, 3, null);
    }

    public final void updateAndHighlight(@NotNull Tile tile, @NotNull Color color) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(color, "color");
        this.updateTile(tile);
        this.highlightTile(tile, color);
    }

    public static /* synthetic */ void updateAndHighlight$default(MapEditorScreen mapEditorScreen, Tile tile, Color color, int n, Object object) {
        if ((n & 2) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        mapEditorScreen.updateAndHighlight(tile, color);
    }

    @Override
    @NotNull
    public BaseScreen recreate() {
        this.cancelJobs();
        return new MapEditorScreen(this.tileMap);
    }

    @Override
    public void dispose() {
        this.cancelJobs();
        super.dispose();
    }

    public final void startBackgroundJob(@NotNull String name, boolean isDaemon, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> block) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(block, "block");
        CoroutineScope scope2 = CoroutineScopeKt.CoroutineScope(isDaemon ? Dispatcher.INSTANCE.getDAEMON() : Dispatcher.INSTANCE.getNON_DAEMON());
        Job newJob = Concurrency.INSTANCE.run(name, scope2, block);
        this.jobs.add(newJob);
        newJob.invokeOnCompletion(arg_0 -> MapEditorScreen.startBackgroundJob$lambda$0(this, newJob, arg_0));
    }

    public static /* synthetic */ void startBackgroundJob$default(MapEditorScreen mapEditorScreen, String string, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        mapEditorScreen.startBackgroundJob(string, bl, function2);
    }

    private final void cancelJobs() {
        for (Job job2 : CollectionsKt.toList((Iterable)this.jobs)) {
            Job.DefaultImpls.cancel$default(job2, null, 1, null);
        }
        this.jobs.clear();
    }

    @Nullable
    public final FileHandle getOverlayFile$core() {
        return this.overlayFile;
    }

    public final void setOverlayFile$core(@Nullable FileHandle value) {
        this.overlayFile = value;
        this.overlayFileChanged(value);
    }

    public final float getOverlayAlpha$core() {
        return this.overlayAlpha;
    }

    public final void setOverlayAlpha$core(float value) {
        this.overlayAlpha = value;
        this.overlayAlphaChanged(value);
    }

    private final void clearOverlayImages() {
        block1: {
            Image image = this.imageOverlay;
            if (image == null) {
                return;
            }
            Image oldImage = image;
            this.imageOverlay = null;
            oldImage.remove();
            Drawable drawable = oldImage.getDrawable();
            Object object = drawable instanceof TextureRegionDrawable ? (TextureRegionDrawable)drawable : null;
            if (object == null || (object = ((TextureRegionDrawable)object).getRegion()) == null || (object = ((TextureRegion)object).getTexture()) == null) break block1;
            ((Texture)object).dispose();
        }
    }

    private final void overlayFileChanged(FileHandle value) {
        this.clearOverlayImages();
        if (value == null) {
            return;
        }
        if (this.tileMap.getMapParameters().getWorldWrap()) {
            this.setWorldWrapFixOddWidth(false);
            new ToastPopup("World wrap is incompatible with an overlay and was deactivated.", this.getStage(), 4000L);
            this.tabs.getOptions().update();
        }
        MapEditorScreen.recreateMapHolder$default(this, null, 1, null);
    }

    private final void overlayAlphaChanged(float value) {
        block0: {
            Object object = this.imageOverlay;
            if (object == null || (object = ((Actor)object).getColor()) == null) break block0;
            ((Color)object).a = value;
        }
    }

    private final void addOverlayToMapHolder(Group newHolderContent) {
        block3: {
            Image image;
            this.clearOverlayImages();
            if (this.overlayFile == null) {
                return;
            }
            try {
                Texture texture = new Texture(this.overlayFile);
                texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
                this.imageOverlay = new ImageWithCustomSize(new TextureRegion(texture));
            }
            catch (Throwable ex) {
                Log.INSTANCE.error("Invalid overlay image", ex);
                this.setOverlayFile$core(null);
                new ToastPopup("Invalid overlay image", this.getStage(), 3000L);
                this.tabs.getOptions().update();
                return;
            }
            Image image2 = this.imageOverlay;
            if (image2 == null) break block3;
            Image $this$addOverlayToMapHolder_u24lambda_u240 = image = image2;
            boolean bl = false;
            $this$addOverlayToMapHolder_u24lambda_u240.setTouchable(Touchable.disabled);
            $this$addOverlayToMapHolder_u24lambda_u240.setFillParent(true);
            $this$addOverlayToMapHolder_u24lambda_u240.getColor().a = this.overlayAlpha;
            newHolderContent.addActor($this$addOverlayToMapHolder_u24lambda_u240);
        }
    }

    private static final Unit _init_$lambda$1(MapEditorScreen this$0, ChangeListener.ChangeEvent it) {
        this$0.isDirty = true;
        return Unit.INSTANCE;
    }

    private static final void _init_$selectGeneratePage(MapEditorScreen this$0, int index) {
        MapEditorMainTabs $this$selectGeneratePage_u24lambda_u242 = this$0.tabs;
        boolean bl = false;
        TabbedPager.selectPage$default((TabbedPager)$this$selectGeneratePage_u24lambda_u242, 1, false, 2, null);
        TabbedPager.selectPage$default((TabbedPager)$this$selectGeneratePage_u24lambda_u242.getGenerate(), index, false, 2, null);
    }

    private static final Unit _init_$lambda$3(MapEditorScreen this$0) {
        MapEditorScreen._init_$selectGeneratePage(this$0, 0);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(MapEditorScreen this$0) {
        MapEditorScreen._init_$selectGeneratePage(this$0, 1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(MapEditorScreen this$0) {
        this$0.closeEditor$core();
        return Unit.INSTANCE;
    }

    private static final Unit recreateMapHolder$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit newMapHolder$lambda$0(MapEditorScreen this$0, Tile it) {
        block0: {
            Intrinsics.checkNotNullParameter(it, "it");
            Function1<? super Tile, Unit> function1 = this$0.tileClickHandler;
            if (function1 == null) break block0;
            function1.invoke(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit applyRuleset$lambda$0(MapEditorScreen this$0, String $newBaseRuleset, LinkedHashSet $mods, Ruleset $newRuleset) {
        this$0.tileMap.getMapParameters().setBaseRuleset($newBaseRuleset);
        this$0.tileMap.getMapParameters().setMods($mods);
        this$0.tileMap.setRuleset($newRuleset);
        this$0.ruleset = $newRuleset;
        return Unit.INSTANCE;
    }

    private static final Unit closeEditor$lambda$0(MapEditorScreen this$0) {
        this$0.cancelJobs();
        UncivGame.popScreen$default(this$0.getGame(), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit startBackgroundJob$lambda$0(MapEditorScreen this$0, Job $newJob, Throwable it) {
        this$0.jobs.remove($newJob);
        return Unit.INSTANCE;
    }

    public MapEditorScreen() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/mapeditorscreen/MapEditorScreen$Companion;", "", "<init>", "()V", "getDefaultParameters", "Lcom/unciv/logic/map/MapParameters;", "saveDefaultParameters", "", "parameters", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final MapParameters getDefaultParameters() {
            MapParameters mapParameters;
            GameSetupInfo gameSetupInfo = UncivGame.Companion.getCurrent().getSettings().getLastGameSetup();
            if (gameSetupInfo == null) {
                return new MapParameters();
            }
            GameSetupInfo lastSetup = gameSetupInfo;
            MapParameters $this$getDefaultParameters_u24lambda_u240 = mapParameters = lastSetup.getMapParameters().clone();
            boolean bl = false;
            $this$getDefaultParameters_u24lambda_u240.reseed();
            $this$getDefaultParameters_u24lambda_u240.getMods().removeAll(CollectionsKt.toSet((Iterable)RulesetCache.INSTANCE.getSortedBaseRulesets()));
            return mapParameters;
        }

        public final void saveDefaultParameters(@NotNull MapParameters parameters) {
            Intrinsics.checkNotNullParameter(parameters, "parameters");
            GameSettings settings = UncivGame.Companion.getCurrent().getSettings();
            Object object = settings.getLastGameSetup();
            if (object == null || (object = ((GameSetupInfo)object).getGameParameters()) == null) {
                object = new GameParameters();
            }
            Object gameParameters = object;
            settings.setLastGameSetup(new GameSetupInfo((GameParameters)gameParameters, parameters));
            settings.save();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

