/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.multiplayer.chat;

import com.badlogic.gdx.Gdx;
import com.unciv.logic.multiplayer.chat.ChatWebSocket;
import com.unciv.logic.multiplayer.chat.Message;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011J\u0016\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011J \u0010\u0019\u001a\u00020\u00152\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u001bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\tH\u00d6\u0001J\t\u0010\"\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/unciv/logic/multiplayer/chat/Chat;", "", "gameId", "Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;)V", "getGameId", "()Ljava/util/UUID;", "unreadCount", "", "getUnreadCount", "()I", "setUnreadCount", "(I)V", "messages", "", "Lkotlin/Pair;", "", "length", "getLength", "requestMessageSend", "", "civName", "message", "addMessage", "forEachMessage", "action", "Lkotlin/Function2;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "core"})
public final class Chat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID gameId;
    private int unreadCount;
    @NotNull
    private final List<Pair<String, String>> messages;
    @NotNull
    private static final Pair<String, String> INITIAL_MESSAGE = TuplesKt.to("System", "Welcome to Chat!");

    public Chat(@NotNull UUID gameId) {
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        this.gameId = gameId;
        Pair[] pairArray = new Pair[]{INITIAL_MESSAGE};
        this.messages = CollectionsKt.mutableListOf(pairArray);
    }

    @NotNull
    public final UUID getGameId() {
        return this.gameId;
    }

    public final int getUnreadCount() {
        return this.unreadCount;
    }

    public final void setUnreadCount(int n) {
        this.unreadCount = n;
    }

    public final int getLength() {
        return this.messages.size();
    }

    public final void requestMessageSend(@NotNull String civName, @NotNull String message) {
        Intrinsics.checkNotNullParameter(civName, "civName");
        Intrinsics.checkNotNullParameter(message, "message");
        Gdx.app.postRunnable(() -> Chat.requestMessageSend$lambda$0(civName, message, this));
    }

    public final void addMessage(@NotNull String civName, @NotNull String message) {
        Intrinsics.checkNotNullParameter(civName, "civName");
        Intrinsics.checkNotNullParameter(message, "message");
        this.messages.add(new Pair<String, String>(civName, message));
    }

    public final void forEachMessage(@NotNull Function2<? super String, ? super String, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, "action");
        for (Pair<String, String> pair : this.messages) {
            String civName = pair.component1();
            String message = pair.component2();
            action2.invoke(civName, message);
        }
    }

    @NotNull
    public final UUID component1() {
        return this.gameId;
    }

    @NotNull
    public final Chat copy(@NotNull UUID gameId) {
        Intrinsics.checkNotNullParameter(gameId, "gameId");
        return new Chat(gameId);
    }

    public static /* synthetic */ Chat copy$default(Chat chat, UUID uUID, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = chat.gameId;
        }
        return chat.copy(uUID);
    }

    @NotNull
    public String toString() {
        return "Chat(gameId=" + this.gameId + ')';
    }

    public int hashCode() {
        return this.gameId.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Chat)) {
            return false;
        }
        Chat chat = (Chat)other;
        return Intrinsics.areEqual(this.gameId, chat.gameId);
    }

    private static final void requestMessageSend$lambda$0(String $civName, String $message, Chat this$0) {
        String string = this$0.gameId.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        ChatWebSocket.INSTANCE.requestMessageSend(new Message.Chat($civName, $message, string));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/unciv/logic/multiplayer/chat/Chat$Companion;", "", "<init>", "()V", "INITIAL_MESSAGE", "Lkotlin/Pair;", "", "getINITIAL_MESSAGE", "()Lkotlin/Pair;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<String, String> getINITIAL_MESSAGE() {
            return INITIAL_MESSAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

