set(program_name ninja)
set(program_version 1.13.2)
set(version_command --version)
if(CMAKE_HOST_WIN32)
    if(DEFINED ENV{PROCESSOR_ARCHITEW6432})
        set(build_arch $ENV{PROCESSOR_ARCHITEW6432})
    else()
        set(build_arch $ENV{PROCESSOR_ARCHITECTURE})
    endif()
    if(build_arch MATCHES "^(ARM|arm)64$")
        set(download_filename "ninja-winarm64-${program_version}.zip")
        set(tool_subdirectory "${program_version}-windows-arm64")
        set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-winarm64.zip")
        set(download_sha512 11541733eede64fe928ad645cd6e5c06cfc2fb7d8c2225aea270a6ed91ffd17c3a13332a348af236e6732cb9f1972fca088cab186439907ca2455b79709d70f6)
    else()
        set(download_filename "ninja-win-${program_version}.zip")
        set(tool_subdirectory "${program_version}-windows")
        set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-win.zip")
        set(download_sha512 55d3d891e8fc6c8ad7f92e172125319896761e57c5125944613d9bbfa5b9374387e9fc1468ad5bcb31464f43fb1c455ea251343942595f42955dc67090aa12ee)
    endif()
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Darwin")
    set(download_filename "ninja-mac-${program_version}.zip")
    set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-mac.zip")
    set(tool_subdirectory "${program_version}-osx")
    set(paths_to_search "${DOWNLOADS}/tools/ninja-${program_version}-osx")
    set(download_sha512 bf71f820791bb2ef97da6e7f8376aaa1c51f3860884df1acde692d2df4c0747a2e167d843dcd5537813da2e5d14457d6ee3f48df13cdd678cea87e68fe73e9f0)
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "FreeBSD")
    set(paths_to_search "${DOWNLOADS}/tools/${tool_subdirectory}-freebsd")
    set(version_command "")
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "OpenBSD")
    set(paths_to_search "${DOWNLOADS}/tools/${tool_subdirectory}-openbsd")
    set(version_command "")
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Linux")
    vcpkg_execute_in_download_mode(COMMAND "uname" "-m" OUTPUT_VARIABLE HOST_ARCH OUTPUT_STRIP_TRAILING_WHITESPACE)
    if(HOST_ARCH MATCHES "x86_64|amd64|AMD64")
        set(download_filename "ninja-linux-${program_version}.zip")
        set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-linux.zip")
        set(tool_subdirectory "${program_version}-linux")
        set(paths_to_search "${DOWNLOADS}/tools/ninja-${program_version}-linux")
        set(download_sha512 714b900cf10b7ecb1b641c91f4ef696250c64984e5955a8088e4a538d6e8077f43e55f6da47efcedbe316c68d51a9e98feff51734eb0eac1b17aa85af5698753)
    elseif(HOST_ARCH MATCHES "arm64|aarch64|ARM64|AARCH64")
        set(download_filename "ninja-linux-aarch64-${program_version}.zip")
        set(download_urls "https://github.com/ninja-build/ninja/releases/download/v${program_version}/ninja-linux-aarch64.zip")
        set(tool_subdirectory "${program_version}-linux-aarch64")
        set(paths_to_search "${DOWNLOADS}/tools/ninja-${program_version}-linux-aarch64")
        set(download_sha512 318714ef0f7cb81fe5aab99032d19cfec07035e784ec9a1de63825ce8bed70f9ad6c5801b84bb7130a0b7acb6d5ed960b2953b27256ff51e18dfd720840faa39)
    else()
        set(version_command "") # somewhat hacky way to skip version check and use system binary
    endif()
else()
    set(version_command "")
endif()
