/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.nbt;

import com.jfoenix.controls.JFXButton;
import java.io.IOException;
import java.nio.file.Path;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PageCloseEvent;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.nbt.NBTFileType;
import org.jackhuang.hmcl.ui.nbt.NBTTreeView;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.logging.Logger;

public final class NBTEditorPage
extends SpinnerPane
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state;
    private final Path file;
    private final NBTFileType type;
    private final BorderPane root = new BorderPane();

    public NBTEditorPage(Path file) throws IOException {
        this.getStyleClass().add((Object)"gray-background");
        this.state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("nbt.title", file.toString())));
        this.file = file;
        this.type = NBTFileType.ofFile(file);
        if (this.type == null) {
            throw new IOException("Unknown type of file " + String.valueOf(file));
        }
        this.setContent((Node)this.root);
        this.setLoading(true);
        HBox actions = new HBox(8.0);
        actions.setPadding(new Insets(8.0));
        actions.setAlignment(Pos.CENTER_RIGHT);
        JFXButton saveButton = FXUtils.newRaisedButton(I18n.i18n("button.save"));
        saveButton.setOnAction(e -> {
            try {
                this.save();
            }
            catch (IOException ex) {
                Logger.LOG.warning("Failed to save NBT file", ex);
                Controllers.dialog(I18n.i18n("nbt.save.failed") + "\n\n" + StringUtils.getStackTrace(ex));
            }
        });
        JFXButton cancelButton = FXUtils.newRaisedButton(I18n.i18n("button.cancel"));
        cancelButton.setOnAction(e -> this.fireEvent(new PageCloseEvent()));
        FXUtils.onEscPressed((Node)this, () -> ((JFXButton)cancelButton).fire());
        actions.getChildren().setAll((Object[])new Node[]{saveButton, cancelButton});
        Task.supplyAsync(() -> this.type.readAsTree(file)).whenComplete(Schedulers.javafx(), (result, exception) -> {
            if (exception == null) {
                this.setLoading(false);
                this.root.setCenter((Node)new NBTTreeView((NBTTreeView.Item)((Object)result)));
            } else {
                Logger.LOG.warning("Fail to open nbt file", exception);
                Controllers.dialog(I18n.i18n("nbt.open.failed") + "\n\n" + StringUtils.getStackTrace(exception), null, MessageDialogPane.MessageType.WARNING, () -> ((JFXButton)cancelButton).fire());
            }
        }).start();
    }

    public void save() throws IOException {
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state;
    }
}

