/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ModTranslations {
    MOD("/assets/mod_data.txt"){

        @Override
        public String getMcmodUrl(Mod mod) {
            return String.format("https://www.mcmod.cn/class/%s.html", mod.getMcmod());
        }
    }
    ,
    MODPACK("/assets/modpack_data.txt"){

        @Override
        public String getMcmodUrl(Mod mod) {
            return String.format("https://www.mcmod.cn/modpack/%s.html", mod.getMcmod());
        }
    }
    ,
    EMPTY(""){

        @Override
        public String getMcmodUrl(Mod mod) {
            return "";
        }
    };

    private final String resourceName;
    private volatile List<Mod> mods;
    private volatile Map<String, Mod> modIdMap;
    private volatile Map<String, Mod> subnameMap;
    private volatile Map<String, Mod> curseForgeMap;
    private volatile List<Pair<String, Mod>> keywords;
    private volatile int maxKeywordLength = -1;

    public static ModTranslations getTranslationsByRepositoryType(RemoteModRepository.Type type) {
        return switch (type) {
            case RemoteModRepository.Type.MOD -> MOD;
            case RemoteModRepository.Type.MODPACK -> MODPACK;
            default -> EMPTY;
        };
    }

    private static String cleanSubname(String subname) {
        int ch;
        if (StringUtils.isBlank(subname)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(subname.length());
        for (int i = 0; i < subname.length(); i += Character.charCount(ch)) {
            ch = subname.codePointAt(i);
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 || ".+\\".indexOf(ch) >= 0) {
                builder.appendCodePoint(ch);
                continue;
            }
            if (Character.isWhitespace(ch) || "':_-/&()[]{}|,!?~\u2022".indexOf(ch) >= 0 || ch >= 127744 && ch <= 129791) continue;
            return "";
        }
        return builder.length() == subname.length() ? subname : builder.toString();
    }

    private ModTranslations(String resourceName) {
        this.resourceName = resourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Mod> getMods() {
        List<Mod> mods = this.mods;
        if (mods != null) {
            return mods;
        }
        ModTranslations modTranslations = this;
        synchronized (modTranslations) {
            List<Mod> list;
            mods = this.mods;
            if (mods != null) {
                return mods;
            }
            if (StringUtils.isBlank(this.resourceName)) {
                this.mods = List.of();
                return this.mods;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(ModTranslations.class.getResourceAsStream(this.resourceName), StandardCharsets.UTF_8));
            try {
                this.mods = reader.lines().filter(line -> !line.startsWith("#")).map(Mod::new).toList();
                list = this.mods;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.LOG.warning("Failed to load " + this.resourceName, e);
                    this.mods = List.of();
                    return this.mods;
                }
            }
            reader.close();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<String, Mod> getModIdMap() {
        Map<String, Mod> modIdMap = this.modIdMap;
        if (modIdMap != null) {
            return modIdMap;
        }
        ModTranslations modTranslations = this;
        synchronized (modTranslations) {
            modIdMap = this.modIdMap;
            if (modIdMap != null) {
                return modIdMap;
            }
            List<Mod> mods = this.getMods();
            modIdMap = new HashMap<String, Mod>(mods.size());
            for (Mod mod : mods) {
                for (String id : mod.getModIds()) {
                    if (!StringUtils.isNotBlank(id)) continue;
                    modIdMap.putIfAbsent(id, mod);
                }
            }
            this.modIdMap = modIdMap;
            return this.modIdMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<String, Mod> getSubnameMap() {
        Map<String, Mod> subnameMap = this.subnameMap;
        if (subnameMap != null) {
            return subnameMap;
        }
        ModTranslations modTranslations = this;
        synchronized (modTranslations) {
            subnameMap = this.subnameMap;
            if (subnameMap != null) {
                return subnameMap;
            }
            subnameMap = new HashMap<String, Mod>();
            List<Mod> mods = this.getMods();
            for (Mod mod : mods) {
                String subname = ModTranslations.cleanSubname(mod.getSubname());
                if (!StringUtils.isNotBlank(subname)) continue;
                subnameMap.putIfAbsent(subname, mod);
            }
            this.subnameMap = subnameMap;
            return this.subnameMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<String, Mod> getCurseForgeMap() {
        Map<String, Mod> curseForgeMap = this.curseForgeMap;
        if (curseForgeMap != null) {
            return curseForgeMap;
        }
        ModTranslations modTranslations = this;
        synchronized (modTranslations) {
            curseForgeMap = this.curseForgeMap;
            if (curseForgeMap != null) {
                return curseForgeMap;
            }
            List<Mod> mods = this.getMods();
            curseForgeMap = new HashMap<String, Mod>(mods.size());
            for (Mod mod : mods) {
                if (!StringUtils.isNotBlank(mod.getCurseforge())) continue;
                curseForgeMap.putIfAbsent(mod.getCurseforge(), mod);
            }
            this.curseForgeMap = curseForgeMap;
            return this.curseForgeMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<Pair<String, Mod>> getKeywords() {
        List<Pair<String, Mod>> keywords = this.keywords;
        if (keywords != null) {
            return keywords;
        }
        ModTranslations modTranslations = this;
        synchronized (modTranslations) {
            keywords = this.keywords;
            if (keywords != null) {
                return keywords;
            }
            List<Mod> mods = this.getMods();
            keywords = new ArrayList<Pair<String, Mod>>();
            int maxKeywordLength = -1;
            for (Mod mod : mods) {
                if (StringUtils.isNotBlank(mod.getName())) {
                    keywords.add(Pair.pair(mod.getName(), mod));
                    maxKeywordLength = Math.max(maxKeywordLength, mod.getName().length());
                }
                if (StringUtils.isNotBlank(mod.getSubname())) {
                    keywords.add(Pair.pair(mod.getSubname(), mod));
                    maxKeywordLength = Math.max(maxKeywordLength, mod.getSubname().length());
                }
                if (!StringUtils.isNotBlank(mod.getAbbr())) continue;
                keywords.add(Pair.pair(mod.getAbbr(), mod));
                maxKeywordLength = Math.max(maxKeywordLength, mod.getAbbr().length());
            }
            this.maxKeywordLength = maxKeywordLength;
            this.keywords = keywords;
            return this.keywords;
        }
    }

    private int getMaxKeywordLength() {
        int maxKeywordLength = this.maxKeywordLength;
        if (maxKeywordLength >= 0) {
            return maxKeywordLength;
        }
        this.getKeywords();
        return this.maxKeywordLength;
    }

    @Nullable
    public Mod getModByCurseForgeId(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        return this.getCurseForgeMap().get(id);
    }

    @Nullable
    public Mod getMod(String id, String subname) {
        Mod mod;
        if (StringUtils.isNotBlank(subname = ModTranslations.cleanSubname(subname)) && (mod = this.getSubnameMap().get(subname)) != null && (StringUtils.isBlank(id) || mod.getModIds().contains(id))) {
            return mod;
        }
        if (StringUtils.isNotBlank(id)) {
            return this.getModIdMap().get(id);
        }
        return null;
    }

    public abstract String getMcmodUrl(Mod var1);

    public List<Mod> searchMod(String query) {
        StringBuilder newQuery = query.chars().filter(ch -> !Character.isSpaceChar(ch)).collect(StringBuilder::new, (sb, value) -> sb.append((char)value), StringBuilder::append);
        query = newQuery.toString();
        StringUtils.LongestCommonSubsequence lcs = new StringUtils.LongestCommonSubsequence(query.length(), this.getMaxKeywordLength());
        ArrayList<Pair<Integer, Mod>> modList = new ArrayList<Pair<Integer, Mod>>();
        for (Pair<String, Mod> keyword : this.getKeywords()) {
            int value2 = lcs.calc(query, keyword.getKey());
            if (value2 < Math.max(1, query.length() - 3)) continue;
            modList.add(Pair.pair(value2, keyword.getValue()));
        }
        return modList.stream().sorted((a, b) -> -((Integer)a.getKey()).compareTo((Integer)b.getKey())).map(Pair::getValue).toList();
    }

    public static final class Mod {
        private final String curseforge;
        private final String mcmod;
        private final List<String> modIds;
        private final String name;
        private final String subname;
        private final String abbr;

        public Mod(String line) {
            String[] items = line.split(";", -1);
            if (items.length != 6) {
                throw new IllegalArgumentException("Illegal mod data line, 6 items expected " + line);
            }
            this.curseforge = items[0];
            this.mcmod = items[1];
            this.modIds = List.of(items[2].split(","));
            this.name = items[3];
            this.subname = items[4];
            this.abbr = items[5];
        }

        public Mod(String curseforge, String mcmod, List<String> modIds, String name, String subname, String abbr) {
            this.curseforge = curseforge;
            this.mcmod = mcmod;
            this.modIds = modIds;
            this.name = name;
            this.subname = subname;
            this.abbr = abbr;
        }

        public String getDisplayName() {
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotBlank(this.abbr)) {
                builder.append("[").append(this.abbr.trim()).append("] ");
            }
            builder.append(this.name);
            if (StringUtils.isNotBlank(this.subname)) {
                builder.append(" (").append(this.subname).append(")");
            }
            return builder.toString();
        }

        public String getCurseforge() {
            return this.curseforge;
        }

        public String getMcmod() {
            return this.mcmod;
        }

        public List<String> getModIds() {
            return this.modIds;
        }

        public String getName() {
            return this.name;
        }

        public String getSubname() {
            return this.subname;
        }

        public String getAbbr() {
            return this.abbr;
        }
    }
}

