/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.tree;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kala.compress.archivers.ArchiveEntry;
import kala.compress.archivers.zip.ZipArchiveReader;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.tree.TarFileTree;
import org.jackhuang.hmcl.util.tree.ZipFileTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class ArchiveFileTree<R, E extends ArchiveEntry>
implements Closeable {
    protected final R reader;
    protected final Dir<E> root = new Dir("", "");

    public static ArchiveFileTree<?, ?> open(Path file) throws IOException {
        Path namePath = file.getFileName();
        if (namePath == null) {
            throw new IOException(String.valueOf(file) + " is not a valid archive file");
        }
        String name = namePath.toString();
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            return new ZipFileTree(new ZipArchiveReader(file));
        }
        if (name.endsWith(".tar") || name.endsWith(".tar.gz") || name.endsWith(".tgz")) {
            return TarFileTree.open(file);
        }
        throw new IOException(String.valueOf(file) + " is not a valid archive file");
    }

    public ArchiveFileTree(R reader) {
        this.reader = reader;
    }

    public R getReader() {
        return this.reader;
    }

    public Dir<E> getRoot() {
        return this.root;
    }

    @Nullable
    public E getEntry(@NotNull String entryPath) {
        Dir<E> subDir;
        String fileName;
        Dir<E> dir = this.root;
        if (entryPath.indexOf(47) < 0) {
            fileName = entryPath;
            if (fileName.isEmpty()) {
                return this.root.getEntry();
            }
        } else {
            String[] path = entryPath.split("/");
            if (path.length == 0) {
                return this.root.getEntry();
            }
            for (int i = 0; i < path.length - 1; ++i) {
                String item = path[i];
                if (item.isEmpty() || (dir = dir.getSubDirs().get(item)) != null) continue;
                return null;
            }
            fileName = path[path.length - 1];
            ArchiveEntry entry = (ArchiveEntry)dir.getFiles().get(fileName);
            if (entry != null) {
                return (E)entry;
            }
        }
        return (subDir = dir.getSubDirs().get(fileName)) != null ? (E)subDir.getEntry() : null;
    }

    protected void addEntry(E entry) throws IOException {
        int end;
        String[] path = entry.getName().split("/");
        List<String> pathList = Arrays.asList(path);
        Dir dir = this.root;
        int n = end = entry.isDirectory() ? path.length : path.length - 1;
        for (int i = 0; i < end; ++i) {
            String item = path[i];
            if (item.equals(".")) continue;
            if (item.equals("..") || item.isEmpty()) {
                throw new IOException("Invalid entry: " + entry.getName());
            }
            if (dir.files.containsKey(item)) {
                throw new IOException("A file and a directory have the same name: " + entry.getName());
            }
            int nameEnd = i + 1;
            dir = dir.subDirs.computeIfAbsent(item, name -> new Dir((String)name, String.join((CharSequence)"/", pathList.subList(0, nameEnd))));
        }
        if (entry.isDirectory()) {
            if (dir.entry != null) {
                throw new IOException("Duplicate entry: " + entry.getName());
            }
            dir.entry = entry;
        } else {
            String fileName = path[path.length - 1];
            if (dir.subDirs.containsKey(fileName)) {
                throw new IOException("A file and a directory have the same name: " + entry.getName());
            }
            if (dir.files.containsKey(fileName)) {
                throw new IOException("Duplicate entry: " + entry.getName());
            }
            dir.files.put(fileName, entry);
        }
    }

    public abstract InputStream getInputStream(E var1) throws IOException;

    @NotNull
    public InputStream getInputStream(String entryPath) throws IOException {
        E entry = this.getEntry(entryPath);
        if (entry == null) {
            throw new FileNotFoundException("Entry not found: " + entryPath);
        }
        return this.getInputStream(entry);
    }

    public byte[] readBinaryEntry(@NotNull E entry) throws IOException {
        try (InputStream input = this.getInputStream(entry);){
            byte[] byArray = input.readAllBytes();
            return byArray;
        }
    }

    public String readTextEntry(@NotNull String entryPath) throws IOException {
        E entry = this.getEntry(entryPath);
        if (entry == null) {
            throw new FileNotFoundException("Entry not found: " + entryPath);
        }
        return this.readTextEntry(entry);
    }

    public String readTextEntry(@NotNull E entry) throws IOException {
        return new String(this.readBinaryEntry(entry), StandardCharsets.UTF_8);
    }

    protected void copyAttributes(@NotNull E source, @NotNull Path targetFile) throws IOException {
        FileTime lastModifiedTime = source.getLastModifiedTime();
        if (lastModifiedTime != null) {
            Files.setLastModifiedTime(targetFile, lastModifiedTime);
        }
    }

    public void extractTo(@NotNull String entryPath, @NotNull Path targetFile) throws IOException {
        E entry = this.getEntry(entryPath);
        if (entry == null) {
            throw new FileNotFoundException("Entry not found: " + entryPath);
        }
        this.extractTo(entry, targetFile);
    }

    public void extractTo(@NotNull E entry, @NotNull Path targetFile) throws IOException {
        try (InputStream input = this.getInputStream(entry);){
            Files.copy(input, targetFile, StandardCopyOption.REPLACE_EXISTING);
        }
        try {
            this.copyAttributes(entry, targetFile);
        }
        catch (Throwable e) {
            Logger.LOG.warning("Failed to copy attributes to " + String.valueOf(targetFile), e);
        }
    }

    public abstract boolean isLink(E var1);

    public abstract String getLink(E var1) throws IOException;

    public abstract boolean isExecutable(E var1);

    @Override
    public abstract void close() throws IOException;

    public static final class Dir<E extends ArchiveEntry> {
        private final String name;
        private final String fullName;
        private E entry;
        final Map<String, Dir<E>> subDirs = new HashMap<String, Dir<E>>();
        final Map<String, E> files = new HashMap<String, E>();

        public Dir(String name, String fullName) {
            this.name = name;
            this.fullName = fullName;
        }

        public boolean isRoot() {
            return this.name.isEmpty();
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getFullName() {
            return this.fullName;
        }

        @Nullable
        public E getEntry() {
            return this.entry;
        }

        @NotNull
        public @UnmodifiableView Map<String, Dir<E>> getSubDirs() {
            return this.subDirs;
        }

        @NotNull
        public @UnmodifiableView Map<String, E> getFiles() {
            return this.files;
        }
    }
}

