/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXButton;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;

public class JFXSnackbar
extends StackPane {
    private Label toast;
    private JFXButton action;
    private Pane snackbarContainer;
    private Group popup;
    private ChangeListener<? super Number> sizeListener;
    private AtomicBoolean processingQueue = new AtomicBoolean(false);
    private ConcurrentLinkedQueue<SnackbarEvent> eventQueue = new ConcurrentLinkedQueue();
    private StackPane actionContainer;
    private Interpolator easeInterpolator = Interpolator.SPLINE((double)0.25, (double)0.1, (double)0.25, (double)1.0);
    private BorderPane content = new BorderPane();
    private String activePseudoClass = null;

    public JFXSnackbar() {
        this(null);
    }

    public JFXSnackbar(Pane snackbarContainer) {
        this.toast = new Label();
        this.toast.setMinWidth(Double.NEGATIVE_INFINITY);
        this.toast.getStyleClass().add((Object)"jfx-snackbar-toast");
        this.toast.setWrapText(true);
        StackPane toastContainer = new StackPane(new Node[]{this.toast});
        toastContainer.setPadding(new Insets(20.0));
        this.content.setLeft((Node)toastContainer);
        this.action = new JFXButton();
        this.action.setMinWidth(Double.NEGATIVE_INFINITY);
        this.action.setButtonType(JFXButton.ButtonType.FLAT);
        this.action.getStyleClass().add((Object)"jfx-snackbar-action");
        this.actionContainer = new StackPane(new Node[]{this.action});
        this.actionContainer.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
        this.content.setRight((Node)this.actionContainer);
        this.toast.prefWidthProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            if (this.getPrefWidth() == -1.0) {
                return this.getPrefWidth();
            }
            double actionWidth = this.actionContainer.isVisible() ? this.actionContainer.getWidth() : 0.0;
            return this.prefWidthProperty().get() - actionWidth;
        }, (Observable[])new Observable[]{this.prefWidthProperty(), this.actionContainer.widthProperty(), this.actionContainer.visibleProperty()}));
        this.content.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        this.content.getStyleClass().add((Object)"jfx-snackbar-content");
        this.popup = new Group();
        this.popup.getChildren().add((Object)this.content);
        this.popup.setManaged(false);
        this.popup.setVisible(false);
        this.popup.idProperty().bind((ObservableValue)this.idProperty());
        this.getStyleClass().addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    this.popup.getStyleClass().addAll((Collection)c.getAddedSubList());
                }
                if (!c.wasRemoved()) continue;
                this.popup.getStyleClass().removeAll((Collection)c.getRemoved());
            }
        });
        this.sizeListener = (o, oldVal, newVal) -> this.refreshPopup();
        this.registerSnackbarContainer(snackbarContainer);
        this.popup.layoutBoundsProperty().addListener((o, oldVal, newVal) -> this.refreshPopup());
        this.addEventHandler(SnackbarEvent.SNACKBAR, e -> this.enqueue((SnackbarEvent)e));
        this.setVisible(false);
        this.setManaged(false);
    }

    public Pane getPopupContainer() {
        return this.snackbarContainer;
    }

    public void registerSnackbarContainer(Pane snackbarContainer) {
        if (snackbarContainer != null) {
            if (this.snackbarContainer != null) {
                throw new IllegalArgumentException("Snackbar Container already set");
            }
            this.snackbarContainer = snackbarContainer;
            this.snackbarContainer.getChildren().add((Object)this.popup);
            this.snackbarContainer.heightProperty().addListener(this.sizeListener);
            this.snackbarContainer.widthProperty().addListener(this.sizeListener);
        }
    }

    public void unregisterSnackbarContainer(Pane snackbarContainer) {
        if (snackbarContainer != null) {
            if (this.snackbarContainer == null) {
                throw new IllegalArgumentException("Snackbar Container not set");
            }
            this.snackbarContainer.getChildren().remove((Object)this.popup);
            this.snackbarContainer.heightProperty().removeListener(this.sizeListener);
            this.snackbarContainer.widthProperty().removeListener(this.sizeListener);
            this.snackbarContainer = null;
        }
    }

    public void show(String toastMessage, long timeout) {
        this.show(toastMessage, null, timeout, null);
    }

    public void show(String message, String actionText, EventHandler<? super MouseEvent> actionHandler) {
        this.show(message, actionText, -1L, actionHandler);
    }

    public void show(String toastMessage, String pseudoClass, long timeout) {
        this.show(toastMessage, pseudoClass, null, timeout, null);
    }

    public void show(String message, String pseudoClass, String actionText, EventHandler<? super MouseEvent> actionHandler) {
        this.show(message, pseudoClass, actionText, -1L, actionHandler);
    }

    public void show(String message, String actionText, long timeout, EventHandler<? super MouseEvent> actionHandler) {
        this.show(message, null, actionText, -1L, actionHandler);
    }

    public void show(String message, String pseudoClass, String actionText, long timeout, EventHandler<? super MouseEvent> actionHandler) {
        this.toast.setText(message);
        if (actionText != null && !actionText.isEmpty()) {
            this.action.setVisible(true);
            this.actionContainer.setVisible(true);
            this.actionContainer.setManaged(true);
            this.action.setText("");
            this.action.setText(actionText);
            this.action.setOnMouseClicked(actionHandler);
        } else {
            this.actionContainer.setVisible(false);
            this.actionContainer.setManaged(false);
            this.action.setVisible(false);
        }
        Timeline animation = this.getTimeline(timeout);
        if (pseudoClass != null) {
            this.activePseudoClass = pseudoClass;
            this.content.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)this.activePseudoClass), true);
        }
        animation.play();
    }

    private Timeline getTimeline(long timeout) {
        Timeline animation;
        if (timeout <= 0L) {
            animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, e -> this.popup.toBack(), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)this.popup.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)10.0), e -> this.popup.toFront(), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)0, this.easeInterpolator)})});
            animation.setCycleCount(1);
        } else {
            animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, e -> this.popup.toBack(), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)this.popup.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)10.0), e -> this.popup.toFront(), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)(timeout / 2L)), new KeyValue[0])});
            animation.setAutoReverse(true);
            animation.setCycleCount(2);
            animation.setOnFinished(e -> {
                this.resetPseudoClass();
                this.processSnackbars();
            });
        }
        return animation;
    }

    public void close() {
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, e -> this.popup.toFront(), new KeyValue[]{new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)1, this.easeInterpolator), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)0, this.easeInterpolator)}), new KeyFrame(Duration.millis((double)290.0), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)true, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)300.0), e -> this.popup.toBack(), new KeyValue[]{new KeyValue((WritableValue)this.popup.visibleProperty(), (Object)false, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.popup.translateYProperty(), (Object)this.popup.getLayoutBounds().getHeight(), this.easeInterpolator), new KeyValue((WritableValue)this.popup.opacityProperty(), (Object)0, this.easeInterpolator)})});
        animation.setCycleCount(1);
        animation.setOnFinished(e -> {
            this.resetPseudoClass();
            this.processSnackbars();
        });
        animation.play();
    }

    private void resetPseudoClass() {
        if (this.activePseudoClass != null) {
            this.content.pseudoClassStateChanged(PseudoClass.getPseudoClass((String)this.activePseudoClass), false);
            this.activePseudoClass = null;
        }
    }

    private void processSnackbars() {
        SnackbarEvent qevent = this.eventQueue.poll();
        if (qevent != null) {
            if (qevent.isPersistent()) {
                this.show(qevent.getMessage(), qevent.getpseudoClass(), qevent.getActionText(), qevent.getActionHandler());
            } else {
                this.show(qevent.getMessage(), qevent.getpseudoClass(), qevent.getActionText(), qevent.getTimeout(), qevent.getActionHandler());
            }
        } else {
            this.processingQueue.getAndSet(false);
        }
    }

    public void refreshPopup() {
        Bounds contentBound = this.popup.getLayoutBounds();
        double offsetX = Math.ceil(this.snackbarContainer.getWidth() / 2.0) - Math.ceil(contentBound.getWidth() / 2.0);
        double offsetY = this.snackbarContainer.getHeight() - contentBound.getHeight();
        this.popup.setLayoutX(offsetX);
        this.popup.setLayoutY(offsetY);
    }

    public void enqueue(SnackbarEvent event) {
        this.eventQueue.add(event);
        if (this.processingQueue.compareAndSet(false, true)) {
            Platform.runLater(() -> {
                SnackbarEvent qevent = this.eventQueue.poll();
                if (qevent != null) {
                    if (qevent.isPersistent()) {
                        this.show(qevent.getMessage(), qevent.getpseudoClass(), qevent.getActionText(), qevent.getActionHandler());
                    } else {
                        this.show(qevent.getMessage(), qevent.getpseudoClass(), qevent.getActionText(), qevent.getTimeout(), qevent.getActionHandler());
                    }
                }
            });
        }
    }

    public static class SnackbarEvent
    extends Event {
        public static final EventType<SnackbarEvent> SNACKBAR = new EventType(Event.ANY, "SNACKBAR");
        private final String message;
        private final String actionText;
        private final String pseudoClass;
        private final long timeout;
        private final boolean persistent;
        private final EventHandler<? super MouseEvent> actionHandler;

        public SnackbarEvent(String message) {
            this(message, null, 3000L, false, null);
        }

        public SnackbarEvent(String message, String pseudoClass) {
            this(message, pseudoClass, null, 3000L, false, null);
        }

        public SnackbarEvent(String message, String actionText, long timeout, boolean persistent, EventHandler<? super MouseEvent> actionHandler) {
            this(message, null, null, 3000L, false, null);
        }

        public SnackbarEvent(String message, String pseudoClass, String actionText, long timeout, boolean persistent, EventHandler<? super MouseEvent> actionHandler) {
            super(SNACKBAR);
            this.message = message;
            this.pseudoClass = pseudoClass;
            this.actionText = actionText;
            this.timeout = timeout < 1L ? 3000L : timeout;
            this.actionHandler = actionHandler;
            this.persistent = persistent;
        }

        public String getMessage() {
            return this.message;
        }

        public String getActionText() {
            return this.actionText;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public EventHandler<? super MouseEvent> getActionHandler() {
            return this.actionHandler;
        }

        public EventType<? extends SnackbarEvent> getEventType() {
            return super.getEventType();
        }

        public boolean isPersistent() {
            return this.persistent;
        }

        public String getpseudoClass() {
            return this.pseudoClass;
        }
    }
}

