/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.animation;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.animation.AnimationUtils;
import org.jackhuang.hmcl.ui.animation.TransitionPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ContainerAnimations implements TransitionPane.AnimationProducer
{
    NONE{

        @Override
        public void init(TransitionPane container, Node previousNode, Node nextNode) {
            AnimationUtils.reset(previousNode, false);
            AnimationUtils.reset(nextNode, true);
        }

        public Timeline animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
            return new Timeline();
        }

        @Override
        public TransitionPane.AnimationProducer opposite() {
            return this;
        }
    }
    ,
    FADE{

        public Timeline animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
            return new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)1, interpolator)})});
        }

        @Override
        public TransitionPane.AnimationProducer opposite() {
            return this;
        }
    }
    ,
    SWIPE_LEFT{

        @Override
        public void init(TransitionPane container, Node previousNode, Node nextNode) {
            AnimationUtils.reset(previousNode, true);
            AnimationUtils.reset(nextNode, true);
            nextNode.setTranslateX(container.getWidth());
        }

        public Timeline animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
            return new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)container.getWidth(), interpolator), new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)0, interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)(-container.getWidth()), interpolator)})});
        }

        @Override
        public TransitionPane.AnimationProducer opposite() {
            return SWIPE_RIGHT;
        }
    }
    ,
    SWIPE_RIGHT{

        @Override
        public void init(TransitionPane container, Node previousNode, Node nextNode) {
            AnimationUtils.reset(previousNode, true);
            AnimationUtils.reset(nextNode, true);
            nextNode.setTranslateX(-container.getWidth());
        }

        public Timeline animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
            return new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)(-container.getWidth()), interpolator), new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)0, interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)container.getWidth(), interpolator)})});
        }

        @Override
        public TransitionPane.AnimationProducer opposite() {
            return SWIPE_LEFT;
        }
    }
    ,
    FORWARD{

        public Timeline animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
            double offset = container.getWidth() > 0.0 ? container.getWidth() * 0.2 : 50.0;
            return new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator)}), new KeyFrame(duration.multiply(0.5), new KeyValue[]{new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)(-offset), interpolator), new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)offset, interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)0, interpolator)})});
        }

        @Override
        public TransitionPane.AnimationProducer opposite() {
            return BACKWARD;
        }
    }
    ,
    BACKWARD{

        public Timeline animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
            double offset = container.getWidth() > 0.0 ? container.getWidth() * 0.2 : 50.0;
            return new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator)}), new KeyFrame(duration.multiply(0.5), new KeyValue[]{new KeyValue((WritableValue)previousNode.translateXProperty(), (Object)offset, interpolator), new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)(-offset), interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)nextNode.translateXProperty(), (Object)0, interpolator)})});
        }

        @Override
        public TransitionPane.AnimationProducer opposite() {
            return FORWARD;
        }
    }
    ,
    SLIDE_UP_FADE_IN{

        public Timeline animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
            double offset = container.getHeight() > 0.0 ? container.getHeight() * 0.2 : 50.0;
            return new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)previousNode.translateYProperty(), (Object)0, interpolator), new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator), new KeyValue((WritableValue)nextNode.translateYProperty(), (Object)offset, interpolator)}), new KeyFrame(duration.multiply(0.5), new KeyValue[]{new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)0, interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)1, interpolator), new KeyValue((WritableValue)nextNode.translateYProperty(), (Object)0, interpolator)})});
        }
    }
    ,
    NAVIGATION{

        @Override
        public Animation animate(Pane container, Node previousNode, Node nextNode, Duration duration, Interpolator interpolator) {
            StackPane center;
            VBox left;
            Timeline timeline = new Timeline();
            Duration halfDuration = duration.divide(2.0);
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)1, interpolator)}));
            timeline.getKeyFrames().add((Object)new KeyFrame(halfDuration, new KeyValue[]{new KeyValue((WritableValue)previousNode.opacityProperty(), (Object)0, interpolator)}));
            if (previousNode instanceof DecoratorAnimatedPage) {
                DecoratorAnimatedPage prevPage = (DecoratorAnimatedPage)previousNode;
                left = prevPage.getLeft();
                center = prevPage.getCenter();
                timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)left.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)center.translateXProperty(), (Object)0, interpolator)}));
                timeline.getKeyFrames().add((Object)new KeyFrame(halfDuration, new KeyValue[]{new KeyValue((WritableValue)left.translateXProperty(), (Object)-30, interpolator), new KeyValue((WritableValue)center.translateXProperty(), (Object)30, interpolator)}));
            }
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator)}));
            timeline.getKeyFrames().add((Object)new KeyFrame(halfDuration, new KeyValue[]{new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)0, interpolator)}));
            timeline.getKeyFrames().add((Object)new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)nextNode.opacityProperty(), (Object)1, interpolator)}));
            if (nextNode instanceof DecoratorAnimatedPage) {
                DecoratorAnimatedPage nextPage = (DecoratorAnimatedPage)nextNode;
                left = nextPage.getLeft();
                center = nextPage.getCenter();
                timeline.getKeyFrames().add((Object)new KeyFrame(halfDuration, new KeyValue[]{new KeyValue((WritableValue)left.translateXProperty(), (Object)-30, interpolator), new KeyValue((WritableValue)center.translateXProperty(), (Object)30, interpolator)}));
                timeline.getKeyFrames().add((Object)new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)left.translateXProperty(), (Object)0, interpolator), new KeyValue((WritableValue)center.translateXProperty(), (Object)0, interpolator)}));
            }
            return timeline;
        }
    };

}

