/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.skin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.animation.Animation;
import javafx.event.EventHandler;
import org.jackhuang.hmcl.ui.skin.FunctionHelper;
import org.jackhuang.hmcl.ui.skin.SkinTransition;

public class SkinAnimation {
    protected int weight;
    protected int left;
    protected List<SkinTransition> transitions;

    public SkinAnimation() {
        this.transitions = new ArrayList<SkinTransition>();
    }

    public SkinAnimation(int weight, SkinTransition ... transitions) {
        this.weight = weight;
        this.transitions = Arrays.asList(transitions);
        this.init();
    }

    protected void init() {
        this.transitions.forEach(t -> {
            EventHandler oldHandler = t.getOnFinished();
            EventHandler newHandler = e -> --this.left;
            newHandler = oldHandler == null ? newHandler : FunctionHelper.link(oldHandler, newHandler);
            t.setOnFinished(newHandler);
        });
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isPlaying() {
        return this.left > 0;
    }

    public void play() {
        this.transitions.forEach(SkinTransition::play);
        this.left = this.transitions.size();
    }

    public void playFromStart() {
        this.transitions.forEach(Animation::playFromStart);
        this.left = this.transitions.size();
    }

    public void stop() {
        this.transitions.forEach(Animation::stop);
        this.left = 0;
    }
}

