/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.alert;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.database.dao.impl.AlertDao;
import com.ghostchu.peerbanhelper.database.table.AlertEntity;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TextManager;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.CommonUtil;
import com.ghostchu.peerbanhelper.util.push.PushManagerImpl;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.stereotype.Component;

@Component
public final class AlertManagerImpl
implements AlertManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertManagerImpl.class);
    private final AlertDao alertDao;
    private final PushManagerImpl pushManager;

    public AlertManagerImpl(AlertDao alertDao, PushManagerImpl pushManager) {
        this.alertDao = alertDao;
        this.pushManager = pushManager;
        CommonUtil.getScheduler().scheduleWithFixedDelay(this::cleanup, 0L, 1L, TimeUnit.DAYS);
    }

    private void cleanup() {
        try {
            int removed = this.alertDao.deleteOldAlerts(new Timestamp(System.currentTimeMillis() - 31536000000L));
            log.info(TextManager.tlUI(Lang.ALERT_MANAGER_CLEAN_UP, removed));
        }
        catch (SQLException e) {
            log.warn("Unable to cleanup expired history alerts", (Throwable)e);
        }
    }

    @Override
    public void markAlertAsRead(@NotNull String identifier) {
        try {
            if (!this.alertDao.identifierAlertExists(identifier)) {
                return;
            }
            this.alertDao.markAsRead(identifier);
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.UNABLE_READ_ALERT, new Object[0]), (Throwable)e);
        }
    }

    @Override
    public boolean identifierAlertExists(@NotNull String identifier) {
        try {
            return this.alertDao.identifierAlertExists(identifier);
        }
        catch (SQLException e) {
            log.warn("Unable query alert for identifier {}", (Object)identifier, (Object)e);
            return false;
        }
    }

    @Override
    public boolean identifierAlertExistsIncludeRead(@NotNull String identifier) {
        try {
            return this.alertDao.identifierAlertExistsIncludeRead(identifier);
        }
        catch (SQLException e) {
            log.warn("Unable query alert for identifier {}", (Object)identifier, (Object)e);
            return false;
        }
    }

    @Override
    public void publishAlert(boolean push, @NotNull AlertLevel level, @NotNull String identifier, @NotNull TranslationComponent title, @NotNull TranslationComponent content) {
        try {
            if (this.alertDao.identifierAlertExists(identifier)) {
                return;
            }
            AlertEntity alertEntity = new AlertEntity();
            alertEntity.setLevel(level);
            alertEntity.setIdentifier(Objects.requireNonNullElseGet(identifier, () -> UUID.randomUUID().toString() + System.currentTimeMillis()));
            alertEntity.setTitle(title);
            alertEntity.setContent(content);
            alertEntity.setCreateAt(new Timestamp(System.currentTimeMillis()));
            this.alertDao.create(alertEntity);
            if (push && !this.pushManager.pushMessage("[PeerBanHelper/" + level.name() + "] " + TextManager.tlUI(title), TextManager.tlUI(content))) {
                log.error(TextManager.tlUI(Lang.UNABLE_TO_PUSH_ALERT_VIA_PROVIDERS, new Object[0]));
            }
            Level slf4jLevel = switch (level) {
                case AlertLevel.ERROR, AlertLevel.FATAL -> Level.ERROR;
                case AlertLevel.WARN -> Level.WARN;
                default -> Level.INFO;
            };
            Main.getGuiManager().createNotification(slf4jLevel, TextManager.tlUI(title), TextManager.tlUI(content));
        }
        catch (Exception e) {
            log.error(TextManager.tlUI(Lang.UNABLE_TO_PUSH_ALERT, new Object[0]), (Throwable)e);
        }
    }

    @Override
    @Nullable
    public AlertLevel getHighestUnreadAlertLevel() {
        AlertLevel alertLevel = null;
        try {
            List<AlertEntity> unreadAlerts = this.alertDao.getUnreadAlertsUnPaged();
            for (AlertEntity unreadAlert : unreadAlerts) {
                if (alertLevel == null) {
                    alertLevel = unreadAlert.getLevel();
                    continue;
                }
                if (unreadAlert.getLevel().ordinal() <= alertLevel.ordinal()) continue;
                alertLevel = unreadAlert.getLevel();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return alertLevel;
    }

    @Override
    @NotNull
    public List<AlertEntity> getUnreadAlerts() {
        try {
            return this.alertDao.getUnreadAlertsUnPaged();
        }
        catch (SQLException e) {
            return List.of();
        }
    }
}

